/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.graphic;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Image;
import com.lowagie2.text.pdf.codec.wmf.MetaDo;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.text.RtfParagraph;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RtfImage
extends RtfElement {
    private static final byte[] PICTURE;
    private static final byte[] PICTURE_BMP;
    private static final byte[] PICTURE_GROUP;
    private static final byte[] PICTURE_HEIGHT;
    private static final byte[] PICTURE_JPEG;
    private static final byte[] PICTURE_PNG;
    private static final byte[] PICTURE_SCALED_HEIGHT;
    private static final byte[] PICTURE_SCALED_WIDTH;
    private static final byte[] PICTURE_SCALEX;
    private static final byte[] PICTURE_SCALEY;
    private static final byte[] PICTURE_WIDTH;
    private static final byte[] PICTURE_WMF;
    private int alignment = 0;
    private float height = 0.0f;
    private byte[] image = new byte[0];
    private int imageType = 0;
    private float plainHeight = 0.0f;
    private float plainWidth = 0.0f;
    private boolean topLevelElement = false;
    private float width = 0.0f;

    static {
        PICTURE_GROUP = "\\*\\shppict".getBytes();
        PICTURE = "\\pict".getBytes();
        PICTURE_JPEG = "\\jpegblip".getBytes();
        PICTURE_PNG = "\\pngblip".getBytes();
        PICTURE_BMP = "\\dibitmap0".getBytes();
        PICTURE_WMF = "\\wmetafile8".getBytes();
        PICTURE_WIDTH = "\\picw".getBytes();
        PICTURE_HEIGHT = "\\pich".getBytes();
        PICTURE_SCALED_WIDTH = "\\picwgoal".getBytes();
        PICTURE_SCALED_HEIGHT = "\\pichgoal".getBytes();
        PICTURE_SCALEX = "\\picscalex".getBytes();
        PICTURE_SCALEY = "\\picscaley".getBytes();
    }

    public RtfImage(RtfDocument doc, Image image) throws DocumentException {
        super(doc);
        this.imageType = image.getOriginalType();
        if (this.imageType != 1 && this.imageType != 4 && this.imageType != 2 && this.imageType != 6) {
            throw new DocumentException("Only BMP, PNG, WMF and JPEG images are supported by the RTF Writer");
        }
        this.alignment = image.alignment();
        this.width = image.width();
        this.height = image.height();
        this.plainWidth = image.plainWidth();
        this.plainHeight = image.plainHeight();
        this.image = this.getImage(image);
    }

    private byte[] getImage(Image image) throws DocumentException {
        ByteArrayOutputStream imageTemp = new ByteArrayOutputStream();
        try {
            InputStream imageIn;
            if (this.imageType == 4) {
                imageIn = new ByteArrayInputStream(MetaDo.wrapBMP(image));
            } else {
                imageIn = image.getOriginalData() == null ? image.url().openStream() : new ByteArrayInputStream(image.getOriginalData());
                if (this.imageType == 6) {
                    long skipLength = 22L;
                    while (skipLength > 0L) {
                        skipLength -= imageIn.skip(skipLength);
                    }
                }
            }
            int buffer = 0;
            int count = 0;
            while ((buffer = imageIn.read()) != -1) {
                String helperStr = Integer.toHexString(buffer);
                if (helperStr.length() < 2) {
                    helperStr = "0" + helperStr;
                }
                imageTemp.write(helperStr.getBytes());
                if (++count != 64) continue;
                imageTemp.write(10);
                count = 0;
            }
        }
        catch (IOException ioe) {
            throw new DocumentException(ioe.getMessage());
        }
        return imageTemp.toByteArray();
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setTopLevelElement(boolean topLevelElement) {
        this.topLevelElement = topLevelElement;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.topLevelElement) {
                result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            }
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(PICTURE_GROUP);
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(PICTURE);
            switch (this.imageType) {
                case 1: {
                    result.write(PICTURE_JPEG);
                    break;
                }
                case 2: {
                    result.write(PICTURE_PNG);
                    break;
                }
                case 4: 
                case 6: {
                    result.write(PICTURE_WMF);
                }
            }
            result.write(PICTURE_WIDTH);
            result.write(this.intToByteArray((int)this.width));
            result.write(PICTURE_HEIGHT);
            result.write(this.intToByteArray((int)this.height));
            if (this.width != this.plainWidth || this.imageType == 4) {
                result.write(PICTURE_SCALEX);
                result.write(this.intToByteArray((int)(100.0f / this.width * this.plainWidth)));
            }
            if (this.height != this.plainHeight || this.imageType == 4) {
                result.write(PICTURE_SCALEY);
                result.write(this.intToByteArray((int)(100.0f / this.height * this.plainHeight)));
            }
            result.write(RtfBasicElement.DELIMITER);
            result.write(10);
            result.write(this.image);
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(RtfBasicElement.CLOSE_GROUP);
            if (this.topLevelElement) {
                result.write(RtfParagraph.PARAGRAPH);
                result.write(RtfParagraph.PARAGRAPH);
            }
            result.write(10);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

