/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.graphic;

import com.lowagie2.text.rtf.RtfAddableElement;
import com.lowagie2.text.rtf.RtfBasicElement;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfShapeProperty
extends RtfAddableElement {
    public static final String PROPERTY_ADJUST_VALUE = "adjustValue";
    public static final String PROPERTY_FILL_COLOR = "fillColor";
    public static final String PROPERTY_FLIP_H = "fFlipH";
    public static final String PROPERTY_FLIP_V = "fFlipV";
    public static final String PROPERTY_GEO_BOTTOM = "geoBottom";
    public static final String PROPERTY_GEO_LEFT = "geoLeft";
    public static final String PROPERTY_GEO_RIGHT = "geoRight";
    public static final String PROPERTY_GEO_TOP = "geoTop";
    public static final String PROPERTY_LAYOUT_IN_CELL = "fLayoutInCell";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    private static final int PROPERTY_TYPE_ARRAY = 5;
    private static final int PROPERTY_TYPE_BOOLEAN = 2;
    private static final int PROPERTY_TYPE_COLOR = 4;
    private static final int PROPERTY_TYPE_DOUBLE = 3;
    private static final int PROPERTY_TYPE_LONG = 1;
    public static final String PROPERTY_VERTICIES = "pVerticies";
    private String name = "";
    private int type = 0;
    private Object value = null;

    public RtfShapeProperty(String name, Point[] value) {
        this(name, (Object)value);
        this.type = 5;
    }

    public RtfShapeProperty(String name, int[] value) {
        this(name, (Object)value);
        this.type = 5;
    }

    public RtfShapeProperty(String name, Color value) {
        this(name, (Object)value);
        this.type = 4;
    }

    public RtfShapeProperty(String name, boolean value) {
        this(name, new Boolean(value));
        this.type = 2;
    }

    public RtfShapeProperty(String name, double value) {
        this(name, new Double(value));
        this.type = 3;
    }

    public RtfShapeProperty(String name, long value) {
        this(name, new Long(value));
        this.type = 1;
    }

    private RtfShapeProperty(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write("\\sp".getBytes());
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write("\\sn".getBytes());
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.name.getBytes());
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write("\\sv".getBytes());
            result.write(RtfBasicElement.DELIMITER);
            switch (this.type) {
                case 1: 
                case 3: {
                    result.write(this.value.toString().getBytes());
                    break;
                }
                case 2: {
                    if (((Boolean)this.value).booleanValue()) {
                        result.write("1".getBytes());
                        break;
                    }
                    result.write("0".getBytes());
                    break;
                }
                case 4: {
                    result.write(this.intToByteArray(((Color)this.value).getRGB()));
                    break;
                }
                case 5: {
                    if (this.value instanceof int[]) {
                        int[] values = (int[])this.value;
                        result.write("4;".getBytes());
                        result.write(this.intToByteArray(values.length));
                        result.write(RtfBasicElement.COMMA_DELIMITER);
                        int i = 0;
                        while (i < values.length) {
                            result.write(this.intToByteArray(values[i]));
                            if (i < values.length - 1) {
                                result.write(RtfBasicElement.COMMA_DELIMITER);
                            }
                            ++i;
                        }
                    } else {
                        if (!(this.value instanceof Point[])) break;
                        Point[] values = (Point[])this.value;
                        result.write("8;".getBytes());
                        result.write(this.intToByteArray(values.length));
                        result.write(RtfBasicElement.COMMA_DELIMITER);
                        int i = 0;
                        while (i < values.length) {
                            result.write("(".getBytes());
                            result.write(this.intToByteArray(values[i].x));
                            result.write(",".getBytes());
                            result.write(this.intToByteArray(values[i].y));
                            result.write(")".getBytes());
                            if (i < values.length - 1) {
                                result.write(RtfBasicElement.COMMA_DELIMITER);
                            }
                            ++i;
                        }
                    }
                    break;
                }
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

