/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.headerfooter;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.HeaderFooter;
import com.lowagie2.text.Image;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Table;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.field.RtfPageNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfHeaderFooter
extends HeaderFooter
implements RtfBasicElement {
    public static final int DISPLAY_ALL_PAGES = 1;
    public static final int DISPLAY_FIRST_PAGE = 0;
    public static final int DISPLAY_LEFT_PAGES = 2;
    public static final int DISPLAY_RIGHT_PAGES = 4;
    private static final byte[] FOOTER_ALL;
    private static final byte[] FOOTER_FIRST;
    private static final byte[] FOOTER_LEFT;
    private static final byte[] FOOTER_RIGHT;
    private static final byte[] HEADER_ALL;
    private static final byte[] HEADER_FIRST;
    private static final byte[] HEADER_LEFT;
    private static final byte[] HEADER_RIGHT;
    public static final int TYPE_FOOTER = 2;
    public static final int TYPE_HEADER = 1;
    private Object[] content = null;
    private int displayAt = 1;
    private RtfDocument document = null;
    private int type = 1;

    static {
        HEADER_ALL = "\\header".getBytes();
        HEADER_FIRST = "\\headerf".getBytes();
        HEADER_LEFT = "\\headerl".getBytes();
        HEADER_RIGHT = "\\headerr".getBytes();
        FOOTER_ALL = "\\footer".getBytes();
        FOOTER_FIRST = "\\footerf".getBytes();
        FOOTER_LEFT = "\\footerl".getBytes();
        FOOTER_RIGHT = "\\footerr".getBytes();
    }

    public RtfHeaderFooter(Element[] elements) {
        super(new Phrase(""), false);
        this.content = new Object[elements.length];
        int i = 0;
        while (i < elements.length) {
            this.content[i] = elements[i];
            ++i;
        }
    }

    public RtfHeaderFooter(Element element) {
        this(new Element[]{element});
    }

    protected RtfHeaderFooter(RtfDocument doc, HeaderFooter headerFooter) {
        super(new Phrase(""), false);
        this.document = doc;
        Paragraph par = new Paragraph();
        par.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            par.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            par.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            par.add(headerFooter.getAfter());
        }
        try {
            this.content = new Object[1];
            this.content[0] = doc.getMapper().mapElement(par);
            ((RtfBasicElement)this.content[0]).setInHeader(true);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    protected RtfHeaderFooter(RtfDocument doc, RtfHeaderFooter headerFooter, int displayAt) {
        super(new Phrase(""), false);
        this.document = doc;
        this.content = headerFooter.getContent();
        this.displayAt = displayAt;
        int i = 0;
        while (i < this.content.length) {
            if (this.content[i] instanceof Element) {
                try {
                    this.content[i] = this.document.getMapper().mapElement((Element)this.content[i]);
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
            }
            if (this.content[i] instanceof RtfBasicElement) {
                ((RtfBasicElement)this.content[i]).setInHeader(true);
            }
            ++i;
        }
    }

    protected RtfHeaderFooter(RtfDocument doc, HeaderFooter headerFooter, int type, int displayAt) {
        super(new Phrase(""), false);
        this.document = doc;
        this.type = type;
        this.displayAt = displayAt;
        Paragraph par = new Paragraph();
        par.setAlignment(headerFooter.alignment());
        if (headerFooter.getBefore() != null) {
            par.add(headerFooter.getBefore());
        }
        if (headerFooter.isNumbered()) {
            par.add(new RtfPageNumber(this.document));
        }
        if (headerFooter.getAfter() != null) {
            par.add(headerFooter.getAfter());
        }
        try {
            this.content = new Object[1];
            if (this.document != null) {
                this.content[0] = this.document.getMapper().mapElement(par);
                ((RtfBasicElement)this.content[0]).setInHeader(true);
            } else {
                this.content[0] = par;
            }
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    private Object[] getContent() {
        return this.content;
    }

    public void setAlignment(int alignment) {
        super.setAlignment(alignment);
        int i = 0;
        while (i < this.content.length) {
            if (this.content[i] instanceof Paragraph) {
                ((Paragraph)this.content[i]).setAlignment(alignment);
            } else if (this.content[i] instanceof Table) {
                ((Table)this.content[i]).setAlignment(alignment);
            } else if (this.content[i] instanceof Image) {
                ((Image)this.content[i]).setAlignment(alignment);
            }
            ++i;
        }
    }

    public void setDisplayAt(int displayAt) {
        this.displayAt = displayAt;
    }

    public void setInHeader(boolean inHeader) {
    }

    public void setInTable(boolean inTable) {
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        if (this.document != null) {
            int i = 0;
            while (i < this.content.length) {
                try {
                    if (this.content[i] instanceof Element) {
                        this.content[i] = this.document.getMapper().mapElement((Element)this.content[i]);
                        ((RtfBasicElement)this.content[i]).setInHeader(true);
                    } else if (this.content[i] instanceof RtfBasicElement) {
                        ((RtfBasicElement)this.content[i]).setRtfDocument(this.document);
                        ((RtfBasicElement)this.content[i]).setInHeader(true);
                    }
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfBasicElement.OPEN_GROUP);
            if (this.type == 1) {
                if (this.displayAt == 1) {
                    result.write(HEADER_ALL);
                } else if (this.displayAt == 0) {
                    result.write(HEADER_FIRST);
                } else if (this.displayAt == 2) {
                    result.write(HEADER_LEFT);
                } else if (this.displayAt == 4) {
                    result.write(HEADER_RIGHT);
                }
            } else if (this.displayAt == 1) {
                result.write(FOOTER_ALL);
            } else if (this.displayAt == 0) {
                result.write(FOOTER_FIRST);
            } else if (this.displayAt == 2) {
                result.write(FOOTER_LEFT);
            } else if (this.displayAt == 4) {
                result.write(FOOTER_RIGHT);
            }
            result.write(RtfBasicElement.DELIMITER);
            int i = 0;
            while (i < this.content.length) {
                if (this.content[i] instanceof RtfBasicElement) {
                    result.write(((RtfBasicElement)this.content[i]).write());
                }
                ++i;
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

