/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.list;

import com.lowagie2.text.ListItem;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.list.RtfList;
import com.lowagie2.text.rtf.text.RtfChunk;
import com.lowagie2.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfListItem
extends RtfParagraph {
    private boolean containsInnerList = false;
    private RtfList parentList = null;

    public RtfListItem(RtfDocument doc, ListItem listItem) {
        super(doc, listItem);
    }

    protected void correctIndentation() {
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfElement instanceof RtfList) {
                ((RtfList)rtfElement).correctIndentation();
            }
            ++i;
        }
    }

    public void inheritListSettings(int listNumber, int listLevel) {
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfElement instanceof RtfList) {
                ((RtfList)rtfElement).setListNumber(listNumber);
                ((RtfList)rtfElement).setListLevel(listLevel);
                ((RtfList)rtfElement).setParent(this.parentList);
            }
            ++i;
        }
    }

    public boolean isContainsInnerList() {
        return this.containsInnerList;
    }

    public void setParent(RtfList parentList) {
        this.parentList = parentList;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < this.chunks.size()) {
                RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
                if (rtfElement instanceof RtfChunk) {
                    ((RtfChunk)rtfElement).setSoftLineBreaks(true);
                } else if (rtfElement instanceof RtfList) {
                    result.write(RtfParagraph.PARAGRAPH);
                    this.containsInnerList = true;
                }
                result.write(rtfElement.write());
                if (rtfElement instanceof RtfList) {
                    result.write(this.parentList.writeListBeginning());
                    result.write("\\tab".getBytes());
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeDefinition() {
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfElement instanceof RtfList) {
                return ((RtfList)rtfElement).writeDefinition();
            }
            ++i;
        }
        return new byte[0];
    }
}

