/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.style;

import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.RtfExtendedElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfColor
extends RtfElement
implements RtfExtendedElement {
    private static final byte COLON = 59;
    private static final byte[] COLOR_BLUE;
    private static final byte[] COLOR_GREEN;
    private static final byte[] COLOR_NUMBER;
    private static final byte[] COLOR_RED;
    private int blue = 0;
    private int colorNumber = 0;
    private int green = 0;
    private int red = 0;

    static {
        COLOR_RED = "\\red".getBytes();
        COLOR_GREEN = "\\green".getBytes();
        COLOR_BLUE = "\\blue".getBytes();
        COLOR_NUMBER = "\\cf".getBytes();
    }

    public RtfColor(RtfDocument doc, int red, int green, int blue) {
        super(doc);
        this.red = red;
        this.blue = blue;
        this.green = green;
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument doc, Color col) {
        super(doc);
        if (col != null) {
            this.red = col.getRed();
            this.blue = col.getBlue();
            this.green = col.getGreen();
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument doc, RtfColor col) {
        super(doc);
        if (col != null) {
            this.red = col.getRed();
            this.green = col.getGreen();
            this.blue = col.getBlue();
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    protected RtfColor(RtfDocument doc, int red, int green, int blue, int colorNumber) {
        super(doc);
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.colorNumber = colorNumber;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RtfColor)) {
            return false;
        }
        RtfColor color = (RtfColor)obj;
        return this.red == color.getRed() && this.green == color.getGreen() && this.blue == color.getBlue();
    }

    public int getBlue() {
        return this.blue;
    }

    public int getColorNumber() {
        return this.colorNumber;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRed() {
        return this.red;
    }

    public int hashCode() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public byte[] writeBegin() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(COLOR_NUMBER);
            result.write(this.intToByteArray(this.colorNumber));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(COLOR_RED);
            result.write(this.intToByteArray(this.red));
            result.write(COLOR_GREEN);
            result.write(this.intToByteArray(this.green));
            result.write(COLOR_BLUE);
            result.write(this.intToByteArray(this.blue));
            result.write(59);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeEnd() {
        return new byte[0];
    }
}

