/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.table;

import com.lowagie2.text.Cell;
import com.lowagie2.text.Row;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.table.RtfCell;
import com.lowagie2.text.rtf.table.RtfEmbedTableCell;
import com.lowagie2.text.rtf.table.RtfTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfRow
extends RtfElement {
    private static final byte[] ROW_ALIGN_CENTER;
    private static final byte[] ROW_ALIGN_JUSTIFIED;
    private static final byte[] ROW_ALIGN_LEFT;
    private static final byte[] ROW_ALIGN_RIGHT;
    private static final byte[] ROW_BEGIN;
    private static final byte[] ROW_CELL_PADDING_LEFT;
    private static final byte[] ROW_CELL_PADDING_LEFT_STYLE;
    private static final byte[] ROW_CELL_PADDING_RIGHT;
    private static final byte[] ROW_CELL_PADDING_RIGHT_STYLE;
    private static final byte[] ROW_CELL_SPACING_BOTTOM;
    private static final byte[] ROW_CELL_SPACING_BOTTOM_STYLE;
    private static final byte[] ROW_CELL_SPACING_LEFT;
    private static final byte[] ROW_CELL_SPACING_LEFT_STYLE;
    private static final byte[] ROW_CELL_SPACING_RIGHT;
    private static final byte[] ROW_CELL_SPACING_RIGHT_STYLE;
    private static final byte[] ROW_CELL_SPACING_TOP;
    private static final byte[] ROW_CELL_SPACING_TOP_STYLE;
    private static final byte[] ROW_END;
    private static final byte[] ROW_GRAPH;
    private static final byte[] ROW_HEADER_ROW;
    private static final byte[] ROW_HEIGHT;
    private static final byte[] ROW_KEEP_TOGETHER;
    private static final byte[] ROW_WIDTH;
    private static final byte[] ROW_WIDTH_STYLE;
    private ArrayList cells = null;
    private int height = 0;
    private RtfTable parentTable = null;
    private int rowNumber = 0;
    private int width = 0;

    static {
        ROW_HEIGHT = "\\trrh".getBytes();
        ROW_BEGIN = "\\trowd".getBytes();
        ROW_WIDTH_STYLE = "\\trftsWidth3".getBytes();
        ROW_WIDTH = "\\trwWidth".getBytes();
        ROW_KEEP_TOGETHER = "\\trkeep".getBytes();
        ROW_HEADER_ROW = "\\trhdr".getBytes();
        ROW_ALIGN_LEFT = "\\trql".getBytes();
        ROW_ALIGN_RIGHT = "\\trqr".getBytes();
        ROW_ALIGN_CENTER = "\\trqc".getBytes();
        ROW_ALIGN_JUSTIFIED = "\\trqj".getBytes();
        ROW_GRAPH = "\\trgaph10".getBytes();
        ROW_CELL_SPACING_LEFT = "\\trspdl".getBytes();
        ROW_CELL_SPACING_TOP = "\\trspdt".getBytes();
        ROW_CELL_SPACING_RIGHT = "\\trspdr".getBytes();
        ROW_CELL_SPACING_BOTTOM = "\\trspdb".getBytes();
        ROW_CELL_SPACING_LEFT_STYLE = "\\trspdfl3".getBytes();
        ROW_CELL_SPACING_TOP_STYLE = "\\trspdft3".getBytes();
        ROW_CELL_SPACING_RIGHT_STYLE = "\\trspdfr3".getBytes();
        ROW_CELL_SPACING_BOTTOM_STYLE = "\\trspdfb3".getBytes();
        ROW_CELL_PADDING_LEFT = "\\trpaddl".getBytes();
        ROW_CELL_PADDING_RIGHT = "\\trpaddr".getBytes();
        ROW_CELL_PADDING_LEFT_STYLE = "\\trpaddfl3".getBytes();
        ROW_CELL_PADDING_RIGHT_STYLE = "\\trpaddfr3".getBytes();
        ROW_END = "\\row".getBytes();
    }

    protected RtfRow(RtfDocument doc, RtfTable rtfTable, Row row, int rowNumber) {
        super(doc);
        this.parentTable = rtfTable;
        this.rowNumber = rowNumber;
        this.importRow(row);
    }

    protected void cleanRow() {
        int i = 0;
        while (i < this.cells.size()) {
            if (((RtfCell)this.cells.get(i)).isDeleted()) {
                this.cells.remove(i);
                continue;
            }
            ++i;
        }
    }

    protected ArrayList getCells() {
        return this.cells;
    }

    protected RtfTable getParentTable() {
        return this.parentTable;
    }

    protected void handleCellSpanning() {
        RtfCell deletedCell = new RtfCell(true);
        int i = 0;
        while (i < this.cells.size()) {
            int j;
            RtfCell rtfCell = (RtfCell)this.cells.get(i);
            if (rtfCell.getColspan() > 1) {
                int cSpan = rtfCell.getColspan();
                j = i + 1;
                while (j < i + cSpan) {
                    if (j < this.cells.size()) {
                        RtfCell rtfCellMerge = (RtfCell)this.cells.get(j);
                        rtfCell.setCellRight(rtfCell.getCellRight() + rtfCellMerge.getCellWidth());
                        rtfCell.setCellWidth(rtfCell.getCellWidth() + rtfCellMerge.getCellWidth());
                        this.cells.set(j, deletedCell);
                    }
                    ++j;
                }
            }
            if (rtfCell.getRowspan() > 1) {
                ArrayList rows = this.parentTable.getRows();
                j = 1;
                while (j < rtfCell.getRowspan()) {
                    RtfRow mergeRow = (RtfRow)rows.get(this.rowNumber + j);
                    if (this.rowNumber + j < rows.size()) {
                        RtfCell rtfCellMerge = (RtfCell)mergeRow.getCells().get(i);
                        rtfCellMerge.setCellMergeChild(rtfCell);
                    }
                    if (rtfCell.getColspan() > 1) {
                        int cSpan = rtfCell.getColspan();
                        int k = i + 1;
                        while (k < i + cSpan) {
                            if (k < mergeRow.getCells().size()) {
                                mergeRow.getCells().set(k, deletedCell);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void importRow(Row row) {
        this.cells = new ArrayList();
        this.width = this.document.getDocumentHeader().getPageSetting().getPageWidth() - this.document.getDocumentHeader().getPageSetting().getMarginLeft() - this.document.getDocumentHeader().getPageSetting().getMarginRight();
        this.width = (int)((float)(this.width / 100) * this.parentTable.getTableWidthPercent());
        this.height = row.getHeight();
        int cellRight = 0;
        int cellWidth = 0;
        int i = 0;
        while (i < row.columns()) {
            cellWidth = (int)((float)(this.width / 100) * this.parentTable.getProportionalWidths()[i]);
            Cell cell = (Cell)row.getCell(i);
            RtfCell rtfCell = null;
            rtfCell = cell instanceof RtfEmbedTableCell ? new RtfEmbedTableCell(this.document, this, cell) : new RtfCell(this.document, this, cell);
            rtfCell.setCellRight(cellRight += cellWidth);
            rtfCell.setCellWidth(cellWidth);
            this.cells.add(rtfCell);
            ++i;
        }
    }

    public byte[] write(boolean previous, byte[] rtfPageSettingDefinition) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.writeRowDefinitions());
            int i = 0;
            while (i < this.cells.size()) {
                RtfCell rtfCell = (RtfCell)this.cells.get(i);
                result.write(rtfCell.write());
                ++i;
            }
            result.write(RtfBasicElement.DELIMITER);
            if (this.document.getDocumentSettings().isOutputTableRowDefinitionAfter()) {
                result.write(this.writeRowDefinitions());
            }
            if (previous) {
                result.write("\\sect\\sectd".getBytes());
            }
            if (rtfPageSettingDefinition.length > 0) {
                result.write("\\sect\\sectd".getBytes());
                result.write(rtfPageSettingDefinition);
            }
            result.write(ROW_END);
            result.write("\n".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.writeRowDefinitions());
            int i = 0;
            while (i < this.cells.size()) {
                RtfCell rtfCell = (RtfCell)this.cells.get(i);
                result.write(rtfCell.write());
                ++i;
            }
            result.write(RtfBasicElement.DELIMITER);
            if (this.document.getDocumentSettings().isOutputTableRowDefinitionAfter()) {
                result.write(this.writeRowDefinitions());
            }
            result.write(ROW_END);
            result.write("\n".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeEmbed() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            byte[] embTable = "\\pard\\intbl\\itap2".getBytes();
            result.write(embTable);
            result.write("\n".getBytes());
            int i = 0;
            while (i < this.cells.size()) {
                RtfCell rtfCell = (RtfCell)this.cells.get(i);
                result.write(rtfCell.writeEmbed());
                ++i;
            }
            result.write(embTable);
            result.write("{{\\*\\nesttableprops".getBytes());
            result.write(this.writeRowDefinitions());
            result.write(RtfBasicElement.DELIMITER);
            result.write("\\nestrow}{\\nonesttables\\par }}".getBytes());
            result.write("\n".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    private byte[] writeRowDefinitions() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(ROW_BEGIN);
            result.write(10);
            result.write(ROW_WIDTH_STYLE);
            result.write(ROW_WIDTH);
            result.write(this.intToByteArray(this.width));
            if (this.parentTable.getCellsFitToPage()) {
                result.write(ROW_KEEP_TOGETHER);
            }
            if (this.rowNumber <= this.parentTable.getHeaderRows()) {
                result.write(ROW_HEADER_ROW);
            }
            switch (this.parentTable.getAlignment()) {
                case 0: {
                    result.write(ROW_ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(ROW_ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(ROW_ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    result.write(ROW_ALIGN_JUSTIFIED);
                }
            }
            result.write(ROW_GRAPH);
            if (this.height > 0) {
                result.write(ROW_HEIGHT);
                result.write(this.intToByteArray(this.height));
            }
            if (this.parentTable.getCellSpacing() > 0.0f) {
                result.write(ROW_CELL_SPACING_LEFT);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_LEFT_STYLE);
                result.write(ROW_CELL_SPACING_TOP);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_TOP_STYLE);
                result.write(ROW_CELL_SPACING_RIGHT);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_RIGHT_STYLE);
                result.write(ROW_CELL_SPACING_BOTTOM);
                result.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                result.write(ROW_CELL_SPACING_BOTTOM_STYLE);
            }
            result.write(ROW_CELL_PADDING_LEFT);
            result.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
            result.write(ROW_CELL_PADDING_RIGHT);
            result.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
            result.write(ROW_CELL_PADDING_LEFT_STYLE);
            result.write(ROW_CELL_PADDING_RIGHT_STYLE);
            result.write(10);
            int i = 0;
            while (i < this.cells.size()) {
                RtfCell rtfCell = (RtfCell)this.cells.get(i);
                result.write(rtfCell.writeDefinition());
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

