/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.table;

import com.lowagie2.text.Row;
import com.lowagie2.text.Table;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.table.RtfBorderGroup;
import com.lowagie2.text.rtf.table.RtfRow;
import com.lowagie2.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable
extends RtfElement {
    private int alignment = 1;
    private RtfBorderGroup borders = null;
    private float cellPadding = 0.0f;
    private float cellSpacing = 0.0f;
    private boolean cellsFitToPage = false;
    private int headerRows = 0;
    private float[] proportionalWidths = null;
    private ArrayList rows = null;
    private boolean tableFitToPage = false;
    private float tableWidthPercent = 80.0f;

    public RtfTable(RtfDocument doc, Table table) {
        super(doc);
        table.complete();
        this.importTable(table);
    }

    protected int getAlignment() {
        return this.alignment;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    protected float getCellPadding() {
        return this.cellPadding;
    }

    protected float getCellSpacing() {
        return this.cellSpacing;
    }

    protected boolean getCellsFitToPage() {
        return this.cellsFitToPage;
    }

    protected int getHeaderRows() {
        return this.headerRows;
    }

    protected float[] getProportionalWidths() {
        return (float[])this.proportionalWidths.clone();
    }

    protected ArrayList getRows() {
        return this.rows;
    }

    protected boolean getTableFitToPage() {
        return this.tableFitToPage;
    }

    protected float getTableWidthPercent() {
        return this.tableWidthPercent;
    }

    private void importTable(Table table) {
        this.rows = new ArrayList();
        this.tableWidthPercent = table.widthPercentage();
        this.proportionalWidths = table.getProportionalWidths();
        this.cellPadding = (float)((double)table.cellpadding() * 20.0);
        this.cellSpacing = (float)((double)table.cellspacing() * 20.0);
        this.borders = new RtfBorderGroup(this.document, 1, table.border(), table.borderWidth(), table.borderColor());
        this.alignment = table.alignment();
        int i = 0;
        Iterator rowIterator = table.iterator();
        while (rowIterator.hasNext()) {
            this.rows.add(new RtfRow(this.document, this, (Row)rowIterator.next(), i));
            ++i;
        }
        i = 0;
        while (i < this.rows.size()) {
            ((RtfRow)this.rows.get(i)).handleCellSpanning();
            ((RtfRow)this.rows.get(i)).cleanRow();
            ++i;
        }
        this.headerRows = table.lastHeaderRow();
        this.cellsFitToPage = table.hasToFitPageCells();
        this.tableFitToPage = table.hasToFitPageTable();
    }

    protected void setEmbedAlignment(int align) {
        this.alignment = align;
    }

    public byte[] write(boolean previous, byte[] rtfPageSettingDefinition) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (!this.inHeader) {
                result.write(RtfParagraph.PARAGRAPH);
            }
            int i = 0;
            while (i < this.rows.size()) {
                RtfElement re = (RtfElement)this.rows.get(i);
                if (i == this.rows.size() - 1 && re instanceof RtfRow) {
                    result.write(((RtfRow)re).write(previous, rtfPageSettingDefinition));
                } else {
                    result.write(re.write());
                }
                ++i;
            }
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (!this.inHeader) {
                result.write(RtfParagraph.PARAGRAPH);
            }
            int i = 0;
            while (i < this.rows.size()) {
                result.write(((RtfElement)this.rows.get(i)).write());
                ++i;
            }
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeEmbed() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < this.rows.size()) {
                result.write(((RtfRow)this.rows.get(i)).writeEmbed());
                ++i;
            }
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

