/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.text;

import com.lowagie2.text.Annotation;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfAnnotation
extends RtfElement {
    private static final byte[] ANNOTATION;
    private static final byte[] ANNOTATION_AUTHOR;
    private static final byte[] ANNOTATION_ID;
    private String content = "";
    private String title = "";

    static {
        ANNOTATION_ID = "\\*\\atnid".getBytes();
        ANNOTATION_AUTHOR = "\\*\\atnauthor".getBytes();
        ANNOTATION = "\\*\\annotation".getBytes();
    }

    public RtfAnnotation(RtfDocument doc, Annotation annotation) {
        super(doc);
        this.title = annotation.title();
        this.content = annotation.content();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(ANNOTATION_ID);
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.intToByteArray(this.document.getRandomInt()));
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(ANNOTATION_AUTHOR);
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.title.getBytes());
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(ANNOTATION);
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.content.getBytes());
            result.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

