/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.tools.plugins;

import com.lowagie2.text.Document;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfImportedPage;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfWriter;
import com.lowagie2.tools.arguments.FileArgument;
import com.lowagie2.tools.arguments.LabelAccessory;
import com.lowagie2.tools.arguments.PdfFilter;
import com.lowagie2.tools.arguments.ToolArgument;
import com.lowagie2.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Burst
extends AbstractTool {
    static {
        AbstractTool.addVersion("$Id: Burst.java,v 1.9 2006/08/21 13:32:23 blowagie Exp $");
    }

    public Burst() {
        FileArgument f = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        f.setLabel(new LabelAccessory());
        this.arguments.add(f);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Burst", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Burst OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            File directory = src.getParentFile();
            String name = src.getName();
            name = name.substring(0, name.lastIndexOf("."));
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int n = reader.getNumberOfPages();
            int digits = 1 + n / 10;
            System.out.println("There are " + n + " pages in the original file.");
            int i = 0;
            while (i < n) {
                int pagenumber = i + 1;
                String filename = String.valueOf(pagenumber);
                while (filename.length() < digits) {
                    filename = "0" + filename;
                }
                filename = "_" + filename + ".pdf";
                Document document = new Document(reader.getPageSizeWithRotation(pagenumber));
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(new File(directory, name + filename)));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfImportedPage page = writer.getImportedPage(reader, pagenumber);
                int rotation = reader.getPageRotation(pagenumber);
                if (rotation == 90 || rotation == 270) {
                    cb.addTemplate(page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(pagenumber).height());
                } else {
                    cb.addTemplate(page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
                document.close();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }

    public static void main(String[] args) {
        Burst tool = new Burst();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }
}

