/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.tools.plugins;

import com.lowagie2.text.pdf.PdfEncryptor;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.tools.arguments.BitsetArgument;
import com.lowagie2.tools.arguments.FileArgument;
import com.lowagie2.tools.arguments.OptionArgument;
import com.lowagie2.tools.arguments.PdfFilter;
import com.lowagie2.tools.arguments.ToolArgument;
import com.lowagie2.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Encrypt
extends AbstractTool {
    private static final int[] PERMISSIONS;
    private static final String[] PERMISSION_OPTIONS;
    static /* synthetic */ Class class$java$lang$String;

    static {
        AbstractTool.addVersion("$Id: Encrypt.java,v 1.11 2005/11/29 21:05:02 blowagie Exp $");
        PERMISSIONS = new int[]{2052, 8, 16, 32, 256, 512, 1024, 4};
        PERMISSION_OPTIONS = new String[]{"AllowPrinting", "AllowModifyContents", "AllowCopy", "AllowModifyAnnotations", "AllowFillIn (128 bit only)", "AllowScreenReaders (128 bit only)", "AllowAssembly (128 bit only)", "AllowDegradedPrinting (128 bit only)"};
    }

    public Encrypt() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to encrypt", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the encrypted PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "ownerpassword", "The ownerpassword you want to add to the PDF file", (class$java$lang$String == null ? (class$java$lang$String = Encrypt.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new ToolArgument(this, "userpassword", "The userpassword you want to add to the PDF file", (class$java$lang$String == null ? (class$java$lang$String = Encrypt.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new BitsetArgument((AbstractTool)this, "permissions", "Permissions on the file", PERMISSION_OPTIONS));
        OptionArgument oa = new OptionArgument(this, "strength", "Strength of the encryption");
        oa.addOption("40 bit encryption", "40");
        oa.addOption("128 bit encryption", "128");
        this.arguments.add(oa);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Encrypt", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Encrypt OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            int permissions = 0;
            String p = (String)this.getValue("permissions");
            if (p != null) {
                int k = 0;
                while (k < p.length()) {
                    permissions |= p.charAt(k) == '0' ? 0 : PERMISSIONS[k];
                    ++k;
                }
            }
            byte[] userpassword = null;
            if (this.getValue("userpassword") != null) {
                userpassword = ((String)this.getValue("userpassword")).getBytes();
            }
            byte[] ownerpassword = null;
            if (this.getValue("ownerpassword") != null) {
                ownerpassword = ((String)this.getValue("ownerpassword")).getBytes();
            }
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            PdfEncryptor.encrypt(reader, (OutputStream)new FileOutputStream((File)this.getValue("destfile")), userpassword, ownerpassword, permissions, "128".equals(this.getValue("strength")));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    public static void main(String[] args) {
        Encrypt tool = new Encrypt();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }
}

