/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.tools.plugins;

import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfGState;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfStamper;
import com.lowagie2.tools.arguments.FileArgument;
import com.lowagie2.tools.arguments.PdfFilter;
import com.lowagie2.tools.arguments.ToolArgument;
import com.lowagie2.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Watermarker
extends AbstractTool {
    static /* synthetic */ Class class$java$lang$String;

    static {
        AbstractTool.addVersion("$Id: Watermarker.java,v 1.7 2006/08/24 10:51:06 blowagie Exp $");
    }

    public Watermarker() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to watermark", false, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "watermark", "The text that can be used as watermark", (class$java$lang$String == null ? (class$java$lang$String = Watermarker.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new ToolArgument(this, "fontsize", "The fontsize of the watermark text", (class$java$lang$String == null ? (class$java$lang$String = Watermarker.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new ToolArgument(this, "opacity", "The opacity of the watermark text", (class$java$lang$String == null ? (class$java$lang$String = Watermarker.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the watermarked PDF has to be written", true, new PdfFilter()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Watermark", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Watermark OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            if (this.getValue("watermark") == null) {
                throw new InstantiationException("You need to add a text for the watermark");
            }
            int fontsize = Integer.parseInt((String)this.getValue("fontsize"));
            float opacity = Float.parseFloat((String)this.getValue("opacity"));
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            int pagecount = reader.getNumberOfPages();
            PdfGState gs1 = new PdfGState();
            gs1.setFillOpacity(opacity);
            String text = (String)this.getValue("watermark");
            PdfStamper stamp = new PdfStamper(reader, new FileOutputStream((File)this.getValue("destfile")));
            float txtwidth = bf.getWidthPoint(text, (float)fontsize);
            int i = 1;
            while (i <= pagecount) {
                PdfContentByte seitex = stamp.getOverContent(i);
                Rectangle recc = reader.getCropBox(i);
                float winkel = (float)Math.atan(recc.height() / recc.width());
                float m1 = (float)Math.cos(winkel);
                float m2 = (float)(-Math.sin(winkel));
                float m3 = (float)Math.sin(winkel);
                float m4 = (float)Math.cos(winkel);
                float xoff = (float)(-Math.cos(winkel) * (double)txtwidth / 2.0 - Math.sin(winkel) * (double)fontsize / 2.0);
                float yoff = (float)(Math.sin(winkel) * (double)txtwidth / 2.0 - Math.cos(winkel) * (double)fontsize / 2.0);
                seitex.saveState();
                seitex.setGState(gs1);
                seitex.beginText();
                seitex.setFontAndSize(bf, fontsize);
                seitex.setTextMatrix(m1, m2, m3, m4, xoff + recc.width() / 2.0f, yoff + recc.height() / 2.0f);
                seitex.showText(text);
                seitex.endText();
                seitex.restoreState();
                ++i;
            }
            stamp.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    public static void main(String[] args) {
        Watermarker watermarker = new Watermarker();
        if (args.length != 5) {
            System.err.println(watermarker.getUsage());
        }
        watermarker.setArguments(args);
        watermarker.execute();
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }
}

