/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.management.J2EEManagedObject;
import org.apache.geronimo.management.geronimo.JCAAdminObject;
import org.apache.geronimo.management.geronimo.JCAConnectionFactory;
import org.apache.geronimo.management.geronimo.JCAManagedConnectionFactory;
import org.apache.geronimo.management.geronimo.JCAResource;
import org.apache.geronimo.management.geronimo.JCAResourceAdapter;

public class JCAResourceImpl
implements JCAResource {
    private final String objectName;
    private final Collection connectionFactories;
    private final Collection resourceAdapters;
    private final Collection adminObjects;

    public JCAResourceImpl(String objectName, Collection connectionFactories, Collection resourceAdapters, Collection adminObjects) {
        this.objectName = objectName;
        this.connectionFactories = connectionFactories;
        this.resourceAdapters = resourceAdapters;
        this.adminObjects = adminObjects;
    }

    public String[] getConnectionFactories() {
        return Util.getObjectNames((J2EEManagedObject[])this.getConnectionFactoryInstances());
    }

    public String[] getResourceAdapterInstanceNames() {
        ArrayList<String> temp = new ArrayList<String>();
        Iterator iterator = this.resourceAdapters.iterator();
        while (iterator.hasNext()) {
            JCAResourceAdapter resourceAdapter = (JCAResourceAdapter)iterator.next();
            temp.add(resourceAdapter.getObjectName());
        }
        return temp.toArray(new String[temp.size()]);
    }

    public JCAResourceAdapter[] getResourceAdapterInstances() {
        return this.resourceAdapters.toArray(new JCAResourceAdapter[this.resourceAdapters.size()]);
    }

    public JCAConnectionFactory[] getConnectionFactoryInstances() {
        return this.connectionFactories.toArray(new JCAConnectionFactory[this.connectionFactories.size()]);
    }

    public JCAManagedConnectionFactory[] getOutboundFactories() {
        return this.getOutboundFactories((String[])null);
    }

    public JCAManagedConnectionFactory[] getOutboundFactories(String connectionFactoryInterface) {
        return this.getOutboundFactories(new String[]{connectionFactoryInterface});
    }

    public JCAManagedConnectionFactory[] getOutboundFactories(String[] connectionFactoryInterfaces) {
        HashSet<String> interfaceFilter = null;
        if (connectionFactoryInterfaces != null) {
            interfaceFilter = new HashSet<String>(Arrays.asList(connectionFactoryInterfaces));
        }
        ArrayList<JCAManagedConnectionFactory> list = new ArrayList<JCAManagedConnectionFactory>();
        Iterator iterator = this.connectionFactories.iterator();
        block0: while (iterator.hasNext()) {
            JCAConnectionFactory jcaConnectionFactory = (JCAConnectionFactory)iterator.next();
            JCAManagedConnectionFactory mcf = jcaConnectionFactory.getManagedConnectionFactoryInstance();
            if (interfaceFilter == null || interfaceFilter.contains(mcf.getConnectionFactoryInterface())) {
                list.add(mcf);
                continue;
            }
            for (int m = 0; m < mcf.getImplementedInterfaces().length; ++m) {
                String iface = mcf.getImplementedInterfaces()[m];
                if (interfaceFilter != null && !interfaceFilter.contains(iface)) continue;
                list.add(mcf);
                continue block0;
            }
        }
        return list.toArray(new JCAManagedConnectionFactory[list.size()]);
    }

    public String[] getAdminObjects() {
        return Util.getObjectNames((J2EEManagedObject[])this.getAdminObjectInstances());
    }

    public JCAAdminObject[] getAdminObjectInstances() {
        return this.adminObjects.toArray(new JCAAdminObject[this.connectionFactories.size()]);
    }

    public JCAAdminObject[] getAdminObjectInstances(String adminObjectInterface) {
        return this.getAdminObjectInstances(new String[]{adminObjectInterface});
    }

    public JCAAdminObject[] getAdminObjectInstances(String[] adminObjectInterfaces) {
        HashSet<String> interfaceFilter = null;
        if (adminObjectInterfaces != null) {
            interfaceFilter = new HashSet<String>(Arrays.asList(adminObjectInterfaces));
        }
        ArrayList<JCAAdminObject> list = new ArrayList<JCAAdminObject>();
        Iterator iterator = this.adminObjects.iterator();
        while (iterator.hasNext()) {
            JCAAdminObject adminObject = (JCAAdminObject)iterator.next();
            if (interfaceFilter != null && !interfaceFilter.contains(adminObject.getAdminObjectInterface())) continue;
            list.add(adminObject);
        }
        return list.toArray(new JCAAdminObject[list.size()]);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }
}

