/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.transaction.manager.NamedXAResource;

public interface ConnectionManagerContainer {
    public Object createConnectionFactory(ManagedConnectionFactory var1) throws ResourceException;

    public ReturnableXAResource getRecoveryXAResource(ManagedConnectionFactory var1) throws ResourceException;

    public ConnectionManager getConnectionManager();

    public static class ReturnableXAResource
    implements NamedXAResource {
        private final ConnectionInterceptor stack;
        private final ConnectionInfo connectionInfo;
        private final NamedXAResource delegate;

        public ReturnableXAResource(NamedXAResource delegate, ConnectionInterceptor stack, ConnectionInfo connectionInfo) {
            this.delegate = delegate;
            this.stack = stack;
            this.connectionInfo = connectionInfo;
        }

        public void returnConnection() {
            this.stack.returnConnection(this.connectionInfo, ConnectionReturnAction.DESTROY);
        }

        public String getName() {
            return this.delegate.getName();
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            this.delegate.commit(xid, onePhase);
        }

        public void end(Xid xid, int flags) throws XAException {
            this.delegate.end(xid, flags);
        }

        public void forget(Xid xid) throws XAException {
            this.delegate.forget(xid);
        }

        public int getTransactionTimeout() throws XAException {
            return this.delegate.getTransactionTimeout();
        }

        public boolean isSameRM(XAResource other) throws XAException {
            if (other instanceof ReturnableXAResource) {
                return this.delegate.isSameRM(((ReturnableXAResource)other).delegate);
            }
            return this.delegate.isSameRM(other);
        }

        public int prepare(Xid xid) throws XAException {
            return this.delegate.prepare(xid);
        }

        public Xid[] recover(int flag) throws XAException {
            return this.delegate.recover(flag);
        }

        public void rollback(Xid xid) throws XAException {
            this.delegate.rollback(xid);
        }

        public boolean setTransactionTimeout(int seconds) throws XAException {
            return this.delegate.setTransactionTimeout(seconds);
        }

        public void start(Xid xid, int flags) throws XAException {
            this.delegate.start(xid, flags);
        }
    }
}

