/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.ConnectionHandleInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.MCFConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SubjectInterceptor;
import org.apache.geronimo.connector.outbound.TCCLInterceptor;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class GenericConnectionManager
extends AbstractConnectionManager {
    public GenericConnectionManager() {
    }

    public GenericConnectionManager(TransactionSupport transactionSupport, PoolingSupport pooling, boolean containerManagedSecurity, ConnectionTracker connectionTracker, TransactionContextManager transactionContextManager, String objectName, ClassLoader classLoader) {
        super(new InterceptorsImpl(transactionSupport, pooling, containerManagedSecurity, objectName, connectionTracker, transactionContextManager, classLoader));
    }

    private static class InterceptorsImpl
    implements AbstractConnectionManager.Interceptors {
        private final ConnectionInterceptor stack;
        private final ConnectionInterceptor recoveryStack;
        private final PoolingSupport poolingSupport;

        public InterceptorsImpl(TransactionSupport transactionSupport, PoolingSupport pooling, boolean containerManagedSecurity, String objectName, ConnectionTracker connectionTracker, TransactionContextManager transactionContextManager, ClassLoader classLoader) {
            MCFConnectionInterceptor tail;
            if (!containerManagedSecurity && pooling instanceof PartitionedPool && ((PartitionedPool)pooling).isPartitionBySubject()) {
                throw new IllegalStateException("To use Subject in pooling, you need a SecurityDomain");
            }
            ConnectionInterceptor stack = tail = new MCFConnectionInterceptor();
            stack = transactionSupport.addXAResourceInsertionInterceptor(stack, objectName);
            stack = pooling.addPoolingInterceptors(stack);
            this.poolingSupport = pooling;
            stack = transactionSupport.addTransactionInterceptors(stack, transactionContextManager);
            if (containerManagedSecurity) {
                stack = new SubjectInterceptor(stack);
            }
            ConnectionInterceptor recoveryStack = stack;
            this.recoveryStack = new TCCLInterceptor(recoveryStack, classLoader);
            stack = new ConnectionHandleInterceptor(stack);
            stack = new TCCLInterceptor(stack, classLoader);
            if (connectionTracker != null) {
                stack = new ConnectionTrackingInterceptor(stack, objectName, connectionTracker);
            }
            tail.setStack(stack);
            this.stack = stack;
        }

        public ConnectionInterceptor getStack() {
            return this.stack;
        }

        public ConnectionInterceptor getRecoveryStack() {
            return this.recoveryStack;
        }

        public PoolingSupport getPoolingAttributes() {
            return this.poolingSupport;
        }
    }
}

