/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkAdapter;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.ImportedTransactionActiveException;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class WorkerContext
implements Work {
    private static final Log log;
    private static final WorkListener NULL_WORK_LISTENER;
    private int threadPriority;
    private Work adaptee;
    private boolean isAccepted;
    private long acceptedTime;
    private int nbRetry;
    private long startTimeOut;
    private final ExecutionContext executionContext;
    private final TransactionContextManager transactionContextManager;
    private WorkListener workListener = NULL_WORK_LISTENER;
    private WorkException workException;
    private Latch startLatch = new Latch();
    private Latch endLatch = new Latch();
    static final /* synthetic */ boolean $assertionsDisabled;

    public WorkerContext(Work work, TransactionContextManager transactionContextManager) {
        this.adaptee = work;
        this.executionContext = null;
        this.transactionContextManager = transactionContextManager;
    }

    public WorkerContext(Work aWork, long aStartTimeout, ExecutionContext execContext, TransactionContextManager transactionContextManager, WorkListener workListener) {
        this.adaptee = aWork;
        this.startTimeOut = aStartTimeout;
        this.executionContext = execContext;
        this.transactionContextManager = transactionContextManager;
        if (null != workListener) {
            this.workListener = workListener;
        }
    }

    public void release() {
        this.adaptee.release();
    }

    public void setThreadPriority(int aPriority) {
        this.threadPriority = aPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void workAccepted(Object anObject) {
        this.isAccepted = true;
        this.acceptedTime = System.currentTimeMillis();
        this.workListener.workAccepted(new WorkEvent(anObject, 1, this.adaptee, null));
    }

    public synchronized long getAcceptedTime() {
        return this.acceptedTime;
    }

    public long getStartTimeout() {
        return this.startTimeOut;
    }

    public synchronized boolean isTimedOut() {
        boolean isTimeout;
        if (!$assertionsDisabled && !this.isAccepted) {
            throw new AssertionError((Object)"The work is not accepted.");
        }
        if (0L == this.startTimeOut || this.startTimeOut == Long.MAX_VALUE) {
            return false;
        }
        boolean bl = isTimeout = this.acceptedTime + this.startTimeOut > 0L && System.currentTimeMillis() > this.acceptedTime + this.startTimeOut;
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " accepted at " + this.acceptedTime + (isTimeout ? " has timed out." : " has not timed out. ") + this.nbRetry + " retries have been performed."));
        }
        if (isTimeout) {
            this.workException = new WorkRejectedException(this + " has timed out.", "1");
            this.workListener.workRejected(new WorkEvent(this, 2, this.adaptee, this.workException));
            return true;
        }
        ++this.nbRetry;
        return isTimeout;
    }

    public synchronized WorkException getWorkException() {
        return this.workException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.isTimedOut()) {
            this.startLatch.release();
            this.endLatch.release();
            return;
        }
        this.workListener.workStarted(new WorkEvent(this, 3, this.adaptee, null));
        this.startLatch.release();
        try {
            block17: {
                if (this.executionContext == null || this.executionContext.getXid() == null) {
                    TransactionContext context = this.transactionContextManager.newUnspecifiedTransactionContext();
                    try {
                        this.adaptee.run();
                        Object var3_8 = null;
                        TransactionContext returningContext = this.transactionContextManager.getContext();
                        this.transactionContextManager.setContext(null);
                        if (context == returningContext) break block17;
                        throw new WorkCompletedException("Wrong TransactionContext on return from work done");
                    }
                    catch (Throwable throwable) {
                        Object var3_9 = null;
                        TransactionContext returningContext = this.transactionContextManager.getContext();
                        this.transactionContextManager.setContext(null);
                        if (context == returningContext) throw throwable;
                        throw new WorkCompletedException("Wrong TransactionContext on return from work done");
                    }
                }
                try {
                    long transactionTimeout = this.executionContext.getTransactionTimeout();
                    this.transactionContextManager.begin(this.executionContext.getXid(), transactionTimeout == -1L ? 0L : transactionTimeout);
                }
                catch (XAException e) {
                    throw new WorkCompletedException("Transaction import failed for xid " + this.executionContext.getXid(), "3").initCause(e);
                }
                catch (InvalidTransactionException e) {
                    throw new WorkCompletedException("Transaction import failed for xid " + this.executionContext.getXid(), "3").initCause(e);
                }
                catch (SystemException e) {
                    throw new WorkCompletedException("Transaction import failed for xid " + this.executionContext.getXid(), "3").initCause(e);
                }
                catch (ImportedTransactionActiveException e) {
                    throw new WorkCompletedException("Transaction already active for xid " + this.executionContext.getXid(), "2");
                }
                try {
                    this.adaptee.run();
                }
                finally {
                    this.transactionContextManager.end(this.executionContext.getXid());
                }
            }
            this.workListener.workCompleted(new WorkEvent(this, 4, this.adaptee, null));
            return;
        }
        catch (Throwable e) {
            this.workException = (WorkException)(e instanceof WorkCompletedException ? e : new WorkCompletedException("Unknown error", "0").initCause(e));
            this.workListener.workCompleted(new WorkEvent(this, 2, this.adaptee, this.workException));
            return;
        }
        finally {
            this.endLatch.release();
        }
    }

    public synchronized Latch provideStartLatch() {
        return this.startLatch;
    }

    public synchronized Latch provideEndLatch() {
        return this.endLatch;
    }

    public String toString() {
        return "Work :" + this.adaptee;
    }

    static {
        $assertionsDisabled = !WorkerContext.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)WorkerContext.class);
        NULL_WORK_LISTENER = new WorkAdapter(){

            public void workRejected(WorkEvent event) {
                if (event.getException() != null) {
                    if (event.getException() instanceof WorkCompletedException && event.getException().getCause() != null) {
                        log.error((Object)event.getWork().toString(), event.getException().getCause());
                    } else {
                        log.error((Object)event.getWork().toString(), (Throwable)event.getException());
                    }
                }
            }
        };
    }
}

