/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ConfigurationOverride {
    private final Artifact name;
    private boolean load;
    private final Map gbeans = new LinkedHashMap();

    public ConfigurationOverride(Artifact name, boolean load) {
        this.name = name;
        this.load = load;
    }

    public ConfigurationOverride(ConfigurationOverride base, Artifact name) {
        this.name = name;
        this.load = base.load;
        Iterator it = base.gbeans.keySet().iterator();
        while (it.hasNext()) {
            Object gbeanName = it.next();
            GBeanOverride gbean = (GBeanOverride)base.gbeans.get(gbeanName);
            GBeanOverride replacement = new GBeanOverride(gbean, base.name.toString(), name.toString());
            this.gbeans.put(replacement.getName(), replacement);
        }
    }

    public ConfigurationOverride(Element element) throws InvalidGBeanException {
        this.name = Artifact.create((String)element.getAttribute("name"));
        String loadConfigString = element.getAttribute("load");
        this.load = !"false".equals(loadConfigString);
        NodeList gbeans = element.getElementsByTagName("gbean");
        for (int g = 0; g < gbeans.getLength(); ++g) {
            Element gbeanElement = (Element)gbeans.item(g);
            GBeanOverride gbean = new GBeanOverride(gbeanElement);
            this.addGBean(gbean);
        }
    }

    public Artifact getName() {
        return this.name;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    public GBeanOverride getGBean(String gbeanName) {
        return (GBeanOverride)this.gbeans.get(gbeanName);
    }

    public void addGBean(GBeanOverride gbean) {
        this.gbeans.put(gbean.getName(), gbean);
    }

    public void addGBean(String gbeanName, GBeanOverride gbean) {
        this.gbeans.put(gbeanName, gbean);
    }

    public Map getGBeans() {
        return this.gbeans;
    }

    public GBeanOverride getGBean(AbstractName gbeanName) {
        return (GBeanOverride)this.gbeans.get(gbeanName);
    }

    public void addGBean(AbstractName gbeanName, GBeanOverride gbean) {
        this.gbeans.put(gbeanName, gbean);
    }

    public Element writeXml(Document doc, Element root) {
        Element module = doc.createElement("module");
        root.appendChild(module);
        module.setAttribute("name", this.name.toString());
        if (!this.load) {
            module.setAttribute("load", "false");
        }
        Iterator gb = this.gbeans.entrySet().iterator();
        while (gb.hasNext()) {
            Map.Entry gbean = gb.next();
            GBeanOverride gbeanOverride = (GBeanOverride)gbean.getValue();
            gbeanOverride.writeXml(doc, module);
        }
        return module;
    }
}

