/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationStoreUtil {
    private static final Log log = LogFactory.getLog((Class)ConfigurationStoreUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChecksumFor(File file) throws IOException {
        String actualChecksum;
        File sumFile = new File(file.getParentFile(), file.getName() + ".sha1");
        if (sumFile.exists()) {
            throw new IOException("Sum file already exists");
        }
        try {
            actualChecksum = ConfigurationStoreUtil.calculateChecksum(file, "SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("SHA-1 algorithm not available");
        }
        FileWriter writer = new FileWriter(sumFile);
        try {
            writer.write(actualChecksum);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ignored) {}
        }
    }

    public static boolean verifyChecksum(File file) {
        String expectedChecksum = ConfigurationStoreUtil.getExpectedChecksum(file);
        if (expectedChecksum == null) {
            return false;
        }
        String actualChecksum = ConfigurationStoreUtil.getActualChecksum(file);
        if (actualChecksum == null) {
            return false;
        }
        if (!actualChecksum.equals(expectedChecksum)) {
            log.warn((Object)("Configuration file was modified: " + file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getExpectedChecksum(File file) {
        String expectedChecksum;
        LineNumberReader lineNumberReader;
        File sumFile;
        block12: {
            sumFile = new File(file.getParentFile(), file.getName() + ".sha1");
            if (!sumFile.exists()) {
                log.warn((Object)("Checksum file not found: " + sumFile.getAbsolutePath()));
                return null;
            }
            if (!sumFile.canRead()) {
                log.warn((Object)("Checksum file is not readable: " + sumFile.getAbsolutePath()));
                return null;
            }
            lineNumberReader = null;
            lineNumberReader = new LineNumberReader(new FileReader(sumFile));
            expectedChecksum = lineNumberReader.readLine();
            if (expectedChecksum != null) break block12;
            log.error((Object)("Checksum file was empty: " + sumFile.getAbsolutePath()));
            String string = null;
            Object var6_7 = null;
            if (lineNumberReader == null) return string;
            try {
                lineNumberReader.close();
                return string;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return string;
        }
        String string = expectedChecksum.trim();
        Object var6_8 = null;
        if (lineNumberReader == null) return string;
        try {
            lineNumberReader.close();
            return string;
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return string;
        catch (IOException e) {
            try {
                log.error((Object)("Unable to read checksum file: " + sumFile.getAbsolutePath()), (Throwable)e);
                Object var6_9 = null;
                if (lineNumberReader == null) return null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (lineNumberReader == null) throw throwable;
                try {
                    lineNumberReader.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                lineNumberReader.close();
                return null;
            }
            catch (IOException ignored) {}
            return null;
        }
    }

    public static String getActualChecksum(File file) {
        return ConfigurationStoreUtil.getActualChecksum(file, "SHA-1");
    }

    public static String getActualChecksum(File file, String algorithm) {
        try {
            return ConfigurationStoreUtil.calculateChecksum(file, algorithm);
        }
        catch (Exception e) {
            log.error((Object)("Unable to calculate checksum for configuration file: " + file.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String calculateChecksum(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        String string;
        FileInputStream stream = null;
        try {
            String actualChecksum;
            stream = new FileInputStream(file);
            MessageDigest digester = MessageDigest.getInstance(algorithm);
            digester.reset();
            byte[] buf = new byte[4096];
            int len = 0;
            while ((len = ((InputStream)stream).read(buf, 0, 1024)) != -1) {
                digester.update(buf, 0, len);
            }
            string = actualChecksum = ConfigurationStoreUtil.encode(digester.digest());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException ignored) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return string;
    }

    private static String encode(byte[] binaryData) {
        if (binaryData.length != 16 && binaryData.length != 20) {
            int bitLength = binaryData.length * 8;
            throw new IllegalArgumentException("Unrecognised length for binary data: " + bitLength + " bits");
        }
        String retValue = "";
        for (int i = 0; i < binaryData.length; ++i) {
            String t = Integer.toHexString(binaryData[i] & 0xFF);
            retValue = t.length() == 1 ? retValue + "0" + t : retValue + t;
        }
        return retValue.trim();
    }

    public static class ChecksumOutputStream
    extends OutputStream {
        private final OutputStream out;
        private MessageDigest digester;

        public ChecksumOutputStream(OutputStream out) throws IOException {
            this.out = out;
            try {
                this.digester = MessageDigest.getInstance("SHA-1");
                this.digester.reset();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("SHA-1 algorithm not available");
            }
        }

        public String getChecksum() {
            String actualChecksum = ConfigurationStoreUtil.encode(this.digester.digest());
            return actualChecksum;
        }

        public void write(int b) throws IOException {
            this.digester.update((byte)b);
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.digester.update(b);
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.digester.update(b, off, len);
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

