/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.system.configuration.ConfigurationStoreUtil;

public final class ExecutableConfigurationUtil {
    private static final String META_INF = "META-INF";
    private static final String CONFIG_SER = "config.ser";
    private static final String CONFIG_INFO = "config.info";
    private static final String META_INF_STARTUP_JAR = "META-INF/startup-jar";
    private static final String META_INF_CONFIG_SER = "META-INF/config.ser";
    private static final String META_INF_CONFIG_SER_SHA1 = "META-INF/config.ser.sha1";
    private static final String META_INF_CONFIG_INFO = "META-INF/config.info";
    private static final Collection EXCLUDED = Arrays.asList("META-INF/startup-jar", "META-INF/config.ser", "META-INF/config.ser.sha1", "META-INF/config.info");

    private ExecutableConfigurationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createExecutableConfiguration(ConfigurationData configurationData, Manifest manifest, File destinationFile) throws IOException {
        File configurationDir = configurationData.getConfigurationDir();
        File parent = destinationFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream fos = null;
        JarOutputStream out = null;
        try {
            byte[] buffer = new byte[4096];
            fos = new FileOutputStream(destinationFile, false);
            if (manifest != null) {
                out = new JarOutputStream((OutputStream)fos, manifest);
                out.putNextEntry(new ZipEntry(META_INF_STARTUP_JAR));
                out.closeEntry();
            } else {
                out = new JarOutputStream(fos);
            }
            ExecutableConfigurationUtil.writeConfiguration(configurationData, out);
            URI baseURI = configurationDir.getAbsoluteFile().toURI();
            Collection files = ExecutableConfigurationUtil.listRecursiveFiles(configurationDir);
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                String relativePath = baseURI.relativize(file.toURI()).getPath();
                if (EXCLUDED.contains(relativePath)) continue;
                FileInputStream in = new FileInputStream(file);
                try {
                    out.putNextEntry(new ZipEntry(relativePath));
                    try {
                        int count;
                        while ((count = ((InputStream)in).read(buffer)) > 0) {
                            out.write(buffer, 0, count);
                        }
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                finally {
                    ExecutableConfigurationUtil.close(in);
                }
            }
        }
        catch (Throwable throwable) {
            ExecutableConfigurationUtil.close(out);
            ExecutableConfigurationUtil.close(fos);
            throw throwable;
        }
        ExecutableConfigurationUtil.close(out);
        ExecutableConfigurationUtil.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfiguration(ConfigurationData configurationData, JarOutputStream out) throws IOException {
        Writer writer;
        out.putNextEntry(new ZipEntry(META_INF_CONFIG_SER));
        ConfigurationStoreUtil.ChecksumOutputStream sumOut = null;
        try {
            sumOut = new ConfigurationStoreUtil.ChecksumOutputStream(out);
            ConfigurationUtil.writeConfigurationData((ConfigurationData)configurationData, (OutputStream)sumOut);
        }
        finally {
            out.closeEntry();
        }
        out.putNextEntry(new ZipEntry(META_INF_CONFIG_SER_SHA1));
        try {
            writer = new OutputStreamWriter(out);
            writer.write(sumOut.getChecksum());
            ((OutputStreamWriter)writer).flush();
        }
        finally {
            out.closeEntry();
        }
        out.putNextEntry(new ZipEntry(META_INF_CONFIG_INFO));
        try {
            writer = new PrintWriter(new OutputStreamWriter(out));
            ConfigurationUtil.writeConfigInfo((PrintWriter)writer, (ConfigurationData)configurationData);
            ((PrintWriter)writer).flush();
        }
        finally {
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfiguration(ConfigurationData configurationData, File source) throws IOException {
        File metaInf = new File(source, META_INF);
        metaInf.mkdirs();
        File configSer = new File(metaInf, CONFIG_SER);
        FileOutputStream out = new FileOutputStream(configSer);
        try {
            ConfigurationUtil.writeConfigurationData((ConfigurationData)configurationData, (OutputStream)out);
        }
        finally {
            ExecutableConfigurationUtil.flush(out);
            ExecutableConfigurationUtil.close(out);
        }
        ConfigurationStoreUtil.writeChecksumFor(configSer);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(new File(metaInf, CONFIG_INFO)));
            ConfigurationUtil.writeConfigInfo((PrintWriter)writer, (ConfigurationData)configurationData);
        }
        catch (Throwable throwable) {
            ExecutableConfigurationUtil.flush(writer);
            ExecutableConfigurationUtil.close(writer);
            throw throwable;
        }
        ExecutableConfigurationUtil.flush(writer);
        ExecutableConfigurationUtil.close(writer);
    }

    private static Collection listRecursiveFiles(File file) {
        LinkedList list = new LinkedList();
        ExecutableConfigurationUtil.listRecursiveFiles(file, list);
        return Collections.unmodifiableCollection(list);
    }

    private static void listRecursiveFiles(File file, Collection collection) {
        File[] files = file.listFiles();
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ExecutableConfigurationUtil.listRecursiveFiles(files[i], collection);
                continue;
            }
            collection.add(files[i]);
        }
    }

    private static void flush(OutputStream thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void flush(Writer thing) {
        if (thing != null) {
            try {
                thing.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void close(InputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void close(OutputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void close(Writer thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

