/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.geronimo.kernel.config.ConfigurationData;

class InPlaceConfigurationUtil {
    private static final String IN_PLACE_LOCATION_FILE = "inPlaceLocation.config";

    InPlaceConfigurationUtil() {
    }

    public boolean isInPlaceConfiguration(File source) {
        File inPlaceLocation = this.getInPlaceLocation(source);
        return inPlaceLocation.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeInPlaceLocation(ConfigurationData configurationData, File source) throws IOException {
        if (null == configurationData.getInPlaceConfigurationDir()) {
            return;
        }
        File inPlaceLocation = this.getInPlaceLocation(source);
        PrintWriter writer = null;
        try {
            FileOutputStream os = new FileOutputStream(inPlaceLocation);
            writer = new PrintWriter(os);
            File inPlaceConfigurationDir = configurationData.getInPlaceConfigurationDir();
            String absolutePath = inPlaceConfigurationDir.getAbsolutePath();
            ((Writer)writer).write(absolutePath);
            ((Writer)writer).close();
            return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (null == writer) throw throwable;
            try {
                ((Writer)writer).close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File readInPlaceLocation(File source) throws IOException {
        File file;
        block6: {
            File inPlaceLocation = this.getInPlaceLocation(source);
            if (!inPlaceLocation.exists()) {
                return null;
            }
            BufferedReader reader = null;
            try {
                FileInputStream is = new FileInputStream(inPlaceLocation);
                reader = new BufferedReader(new InputStreamReader(is));
                String path = reader.readLine();
                file = new File(path);
                Object var8_7 = null;
                if (null == reader) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_8 = null;
                    if (null == reader) break block7;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return file;
    }

    private File getInPlaceLocation(File source) {
        File inPlaceLocation = new File(source, "META-INF");
        inPlaceLocation.mkdirs();
        return new File(inPlaceLocation, IN_PLACE_LOCATION_FILE);
    }
}

