/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.ConfigurationOverride;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.apache.geronimo.system.configuration.InvalidAttributeException;
import org.apache.geronimo.system.configuration.PluginAttributeStore;
import org.apache.geronimo.system.configuration.ServerOverride;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LocalAttributeManager
implements PluginAttributeStore,
PersistentConfigurationList,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)LocalAttributeManager.class);
    private static final String CONFIG_FILE_PROPERTY = "org.apache.geronimo.config.file";
    private static final String BACKUP_EXTENSION = ".bak";
    private static final String TEMP_EXTENSION = ".working";
    private static final int SAVE_BUFFER_MS = 5000;
    private final ServerInfo serverInfo;
    private final String configFile;
    private final boolean readOnly;
    private File attributeFile;
    private File backupFile;
    private File tempFile;
    private ServerOverride serverOverride;
    private Timer timer;
    private TimerTask currentTask;
    private boolean kernelFullyStarted;
    public static final GBeanInfo GBEAN_INFO;

    public LocalAttributeManager(String configFile, boolean readOnly, ServerInfo serverInfo) {
        this.configFile = System.getProperty(CONFIG_FILE_PROPERTY, configFile);
        this.readOnly = readOnly;
        this.serverInfo = serverInfo;
        this.serverOverride = new ServerOverride();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized Collection applyOverrides(Artifact configName, Collection gbeanDatas, ClassLoader classLoader) throws InvalidConfigException {
        gbeanDatas = new ArrayList<GBeanData>(gbeanDatas);
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return gbeanDatas;
        }
        HashMap<Object, GBeanData> datasByName = new HashMap<Object, GBeanData>();
        Iterator<Object> iterator = gbeanDatas.iterator();
        while (iterator.hasNext()) {
            GBeanData gbeanData = (GBeanData)iterator.next();
            datasByName.put(gbeanData.getAbstractName(), gbeanData);
            datasByName.put(gbeanData.getAbstractName().getName().get("name"), gbeanData);
        }
        iterator = configuration.getGBeans().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object name = entry.getKey();
            GBeanOverride gbean = (GBeanOverride)entry.getValue();
            if (datasByName.containsKey(name) || !gbean.isLoad()) continue;
            if (gbean.getGBeanInfo() == null || !(name instanceof AbstractName)) {
                String sep = "";
                StringBuffer message = new StringBuffer("New GBeans must be specified with ");
                if (gbean.getGBeanInfo() == null) {
                    message.append("a GBeanInfo ");
                    sep = "and ";
                }
                if (!(name instanceof AbstractName)) {
                    message.append(sep).append("a full AbstractName ");
                }
                message.append("configuration=").append(configName);
                message.append(" gbeanName=").append(name);
                throw new InvalidConfigException(message.toString());
            }
            GBeanInfo gbeanInfo = GBeanInfo.getGBeanInfo((String)gbean.getGBeanInfo(), (ClassLoader)classLoader);
            AbstractName abstractName = (AbstractName)name;
            GBeanData gBeanData = new GBeanData(abstractName, gbeanInfo);
            gbeanDatas.add(gBeanData);
        }
        iterator = gbeanDatas.iterator();
        while (iterator.hasNext()) {
            GBeanData data = (GBeanData)iterator.next();
            boolean load = this.setAttributes(data, configuration, configName, classLoader);
            if (load) continue;
            iterator.remove();
        }
        return gbeanDatas;
    }

    private synchronized boolean setAttributes(GBeanData data, ConfigurationOverride configuration, Artifact configName, ClassLoader classLoader) throws InvalidConfigException {
        String attribute;
        Map.Entry entry;
        AbstractName gbeanName = data.getAbstractName();
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean((String)gbeanName.getName().get("name"));
        }
        if (gbean == null) {
            return true;
        }
        if (!gbean.isLoad()) {
            return false;
        }
        GBeanInfo gbeanInfo = data.getGBeanInfo();
        Iterator iterator = gbean.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String attributeName = (String)entry.getKey();
            GAttributeInfo attributeInfo = gbeanInfo.getAttribute(attributeName);
            if (attributeInfo == null) {
                throw new InvalidConfigException("No attribute: " + attributeName + " for gbean: " + data.getAbstractName());
            }
            String valueString = (String)entry.getValue();
            Object value = this.getValue(attributeInfo, valueString, configName, gbeanName, classLoader);
            data.setAttribute(attributeName, value);
        }
        iterator = gbean.getClearAttributes().iterator();
        while (iterator.hasNext()) {
            attribute = (String)((Object)iterator.next());
            if (!gbean.getClearAttribute(attribute)) continue;
            data.clearAttribute(attribute);
        }
        iterator = gbean.getNullAttributes().iterator();
        while (iterator.hasNext()) {
            attribute = (String)((Object)iterator.next());
            if (!gbean.getNullAttribute(attribute)) continue;
            data.setAttribute(attribute, null);
        }
        iterator = gbean.getReferences().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String referenceName = (String)entry.getKey();
            GReferenceInfo referenceInfo = gbeanInfo.getReference(referenceName);
            if (referenceInfo == null) {
                throw new InvalidConfigException("No reference: " + referenceName + " for gbean: " + data.getAbstractName());
            }
            ReferencePatterns referencePatterns = (ReferencePatterns)entry.getValue();
            data.setReferencePatterns(referenceName, referencePatterns);
        }
        iterator = gbean.getClearReferences().iterator();
        while (iterator.hasNext()) {
            String reference = (String)((Object)iterator.next());
            if (!gbean.getClearReference(reference)) continue;
            data.clearReference(reference);
        }
        return true;
    }

    private synchronized Object getValue(GAttributeInfo attribute, String value, Artifact configurationName, AbstractName gbeanName, ClassLoader classLoader) {
        if (value == null) {
            return null;
        }
        try {
            PropertyEditor editor = PropertyEditors.findEditor((String)attribute.getType(), (ClassLoader)classLoader);
            if (editor == null) {
                log.debug((Object)("Unable to parse attribute of type " + attribute.getType() + "; no editor found"));
                return null;
            }
            editor.setAsText(value);
            log.debug((Object)("Setting value for " + configurationName + "/" + gbeanName + "/" + attribute.getName() + " to value " + value));
            return editor.getValue();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to load attribute type " + attribute.getType()));
            return null;
        }
    }

    public void setModuleGBeans(Artifact moduleName, GBeanOverride[] gbeans) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(moduleName, true);
        for (int i = 0; i < gbeans.length; ++i) {
            GBeanOverride gbean = gbeans[i];
            configuration.addGBean(gbean);
        }
        this.attributeChanged();
    }

    public synchronized void setValue(Artifact configurationName, AbstractName gbeanName, GAttributeInfo attribute, Object value) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean((String)gbeanName.getName().get("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true);
            configuration.addGBean(gbeanName, gbean);
        }
        try {
            gbean.setAttribute(attribute.getName(), value, attribute.getType());
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
        }
    }

    public synchronized void setReferencePatterns(Artifact configurationName, AbstractName gbeanName, GReferenceInfo reference, ReferencePatterns patterns) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null && (gbean = configuration.getGBean((String)gbeanName.getName().get("name"))) == null) {
            gbean = new GBeanOverride(gbeanName, true);
            configuration.addGBean(gbeanName, gbean);
        }
        gbean.setReferencePatterns(reference.getName(), patterns);
        this.attributeChanged();
    }

    public synchronized void setShouldLoad(Artifact configurationName, AbstractName gbeanName, boolean load) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, true);
        GBeanOverride gbean = configuration.getGBean(gbeanName);
        if (gbean == null) {
            gbean = configuration.getGBean((String)gbeanName.getName().get("name"));
        }
        if (gbean == null) {
            gbean = new GBeanOverride(gbeanName, load);
            configuration.addGBean(gbeanName, gbean);
        } else {
            gbean.setLoad(load);
        }
        this.attributeChanged();
    }

    public void addGBean(Artifact configurationName, GBeanData gbeanData) {
        if (this.readOnly) {
            return;
        }
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName);
        if (configuration == null) {
            log.debug((Object)("Can not add GBean; Configuration not found " + configurationName));
            return;
        }
        try {
            GBeanOverride gbean = new GBeanOverride(gbeanData);
            configuration.addGBean(gbean);
            this.attributeChanged();
        }
        catch (InvalidAttributeException e) {
            log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws IOException {
        this.ensureParentDirectory();
        if (!this.attributeFile.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(this.attributeFile);
        InputSource in = new InputSource(fis);
        in.setSystemId(this.attributeFile.toString());
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        try {
            dFactory.setValidating(true);
            dFactory.setNamespaceAware(true);
            dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", LocalAttributeManager.class.getResourceAsStream("/META-INF/schema/local-attributes-1.1.xsd"));
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) {
                    log.error((Object)("Unable to read saved manageable attributes. SAX parse error: " + exception.getMessage() + " at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + " in entity " + exception.getSystemId()));
                }

                public void fatalError(SAXParseException exception) {
                    log.error((Object)("Unable to read saved manageable attributes. Fatal SAX parse error: " + exception.getMessage() + " at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + " in entity " + exception.getSystemId()));
                }

                public void warning(SAXParseException exception) {
                    log.error((Object)("SAX parse warning whilst reading saved manageable attributes: " + exception.getMessage() + " at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + " in entity " + exception.getSystemId()));
                }
            });
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            this.serverOverride = new ServerOverride(root);
        }
        catch (SAXException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        catch (InvalidGBeanException e) {
            log.error((Object)"Unable to read saved manageable attributes", (Throwable)e);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public synchronized void save() throws IOException {
        if (this.readOnly) {
            return;
        }
        this.ensureParentDirectory();
        if (!this.tempFile.exists() && !this.tempFile.createNewFile()) {
            throw new IOException("Unable to create manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        if (!this.tempFile.canWrite()) {
            throw new IOException("Unable to write to manageable attribute working file for save " + this.tempFile.getAbsolutePath());
        }
        LocalAttributeManager.saveXmlToFile(this.tempFile, this.serverOverride);
        if (this.backupFile.exists() && !this.backupFile.delete()) {
            throw new IOException("Unable to delete old backup file in order to back up current manageable attribute working file for save");
        }
        if (this.attributeFile.exists() && !this.attributeFile.renameTo(this.backupFile)) {
            throw new IOException("Unable to rename " + this.attributeFile.getAbsolutePath() + " to " + this.backupFile.getAbsolutePath() + " in order to back up manageable attribute save file");
        }
        if (!this.tempFile.renameTo(this.attributeFile)) {
            throw new IOException("EXTREMELY CRITICAL!  Unable to move manageable attributes working file to proper file name!  Configuration will revert to defaults unless this is manually corrected!  (could not rename " + this.tempFile.getAbsolutePath() + " to " + this.attributeFile.getAbsolutePath() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveXmlToFile(File file, ServerOverride serverOverride) {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setValidating(true);
        dFactory.setNamespaceAware(true);
        dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", LocalAttributeManager.class.getResourceAsStream("/META-INF/schema/local-attributes-1.1.xsd"));
        FileOutputStream fos = null;
        Document doc = dFactory.newDocumentBuilder().newDocument();
        serverOverride.writeXml(doc);
        TransformerFactory xfactory = TransformerFactory.newInstance();
        Transformer xform = xfactory.newTransformer();
        xform.setOutputProperty("indent", "yes");
        xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        fos = new FileOutputStream(file);
        StreamResult sr = new StreamResult(fos);
        xform.transform(new DOMSource(doc), sr);
        Object var9_11 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (FileNotFoundException e) {
                log.error((Object)"Unable to write config.xml", (Throwable)e);
                Object var9_12 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
            catch (ParserConfigurationException e) {
                log.error((Object)"Unable to write config.xml", (Throwable)e);
                Object var9_13 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
            catch (TransformerException e) {
                log.error((Object)"Unable to write config.xml", (Throwable)e);
                Object var9_14 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean isKernelFullyStarted() {
        return this.kernelFullyStarted;
    }

    public synchronized void setKernelFullyStarted(boolean kernelFullyStarted) {
        this.kernelFullyStarted = kernelFullyStarted;
    }

    public synchronized List restore() throws IOException {
        ArrayList<Artifact> configs = new ArrayList<Artifact>();
        Iterator iterator = this.serverOverride.getConfigurations().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ConfigurationOverride configuration = (ConfigurationOverride)entry.getValue();
            if (!configuration.isLoad()) continue;
            Artifact configID = (Artifact)entry.getKey();
            configs.add(configID);
        }
        return configs;
    }

    public void startConfiguration(Artifact configurationName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, false);
        if (configuration == null) {
            return;
        }
        configuration.setLoad(true);
        this.attributeChanged();
    }

    public synchronized void addConfiguration(Artifact configurationName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configurationName, false);
        if (configuration == null) {
            configuration = this.serverOverride.getConfiguration(configurationName, true);
            configuration.setLoad(false);
            this.attributeChanged();
        }
    }

    public synchronized void removeConfiguration(Artifact configName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return;
        }
        this.serverOverride.removeConfiguration(configName);
        this.attributeChanged();
    }

    public Artifact[] getListedConfigurations(Artifact query) {
        return this.serverOverride.queryConfigurations(query);
    }

    public void stopConfiguration(Artifact configName) {
        ConfigurationOverride configuration = this.serverOverride.getConfiguration(configName);
        if (configuration == null) {
            return;
        }
        configuration.setLoad(false);
        this.attributeChanged();
    }

    public void migrateConfiguration(Artifact oldName, Artifact newName, Configuration configuration) {
        ConfigurationOverride configInfo = this.serverOverride.getConfiguration(oldName);
        if (configInfo == null) {
            throw new IllegalArgumentException("Trying to migrate unknown configuration: " + oldName);
        }
        this.serverOverride.removeConfiguration(oldName);
        configInfo = new ConfigurationOverride(configInfo, newName);
        this.serverOverride.addConfiguration(configInfo);
        this.attributeChanged();
    }

    public synchronized void doStart() throws Exception {
        this.load();
        if (!this.readOnly) {
            this.timer = new Timer();
        }
        log.debug((Object)("Started LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doStop() throws Exception {
        boolean doSave = false;
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                    doSave = true;
                }
            }
        }
        if (doSave) {
            this.save();
        }
        log.debug((Object)("Stopped LocalAttributeManager with data on " + this.serverOverride.getConfigurations().size() + " configurations"));
        this.serverOverride = new ServerOverride();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doFail() {
        LocalAttributeManager localAttributeManager = this;
        synchronized (localAttributeManager) {
            if (this.timer != null) {
                this.timer.cancel();
                if (this.currentTask != null) {
                    this.currentTask.cancel();
                }
            }
        }
        this.serverOverride = new ServerOverride();
    }

    private synchronized void ensureParentDirectory() throws IOException {
        File parent;
        if (this.attributeFile == null) {
            this.attributeFile = this.serverInfo.resolveServer(this.configFile);
            this.tempFile = new File(this.attributeFile.getAbsolutePath() + TEMP_EXTENSION);
            this.backupFile = new File(this.attributeFile.getAbsolutePath() + BACKUP_EXTENSION);
        }
        if (!(parent = this.attributeFile.getParentFile()).isDirectory() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory for list:" + parent);
        }
        if (!parent.canRead() || !parent.canWrite()) {
            throw new IOException("Unable to write manageable attribute files to directory " + parent.getAbsolutePath());
        }
    }

    private synchronized void attributeChanged() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        if (this.timer != null) {
            this.currentTask = new TimerTask(){

                public void run() {
                    try {
                        LocalAttributeManager.this.save();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error saving attributes", (Throwable)e);
                    }
                }
            };
            this.timer.schedule(this.currentTask, 5000L);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)LocalAttributeManager.class, (String)"AttributeStore");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addAttribute("configFile", String.class, true);
        infoFactory.addAttribute("readOnly", Boolean.TYPE, true);
        infoFactory.addInterface(ManageableAttributeStore.class);
        infoFactory.addInterface(PersistentConfigurationList.class);
        infoFactory.setConstructor(new String[]{"configFile", "readOnly", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

