/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.geronimo.system.configuration.OutputFormat;

public class Printer {
    protected final OutputFormat format;
    protected Writer writer;
    protected StringWriter dtdWriter;
    protected Writer docWriter;
    protected IOException exception;
    private static final int BufferSize = 4096;
    private final char[] buffer = new char[4096];
    private int pos = 0;

    public Printer(Writer writer, OutputFormat format) {
        this.writer = writer;
        this.format = format;
        this.exception = null;
        this.dtdWriter = null;
        this.docWriter = null;
        this.pos = 0;
    }

    public IOException getException() {
        return this.exception;
    }

    public void enterDTD() throws IOException {
        if (this.dtdWriter == null) {
            this.flushLine(false);
            this.dtdWriter = new StringWriter();
            this.docWriter = this.writer;
            this.writer = this.dtdWriter;
        }
    }

    public String leaveDTD() throws IOException {
        if (this.writer == this.dtdWriter) {
            this.flushLine(false);
            this.writer = this.docWriter;
            return this.dtdWriter.toString();
        }
        return null;
    }

    public void printText(String text) throws IOException {
        try {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                if (this.pos == 4096) {
                    this.writer.write(this.buffer);
                    this.pos = 0;
                }
                this.buffer[this.pos] = text.charAt(i);
                ++this.pos;
            }
        }
        catch (IOException except) {
            if (this.exception == null) {
                this.exception = except;
            }
            throw except;
        }
    }

    public void printText(StringBuffer text) throws IOException {
        try {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                if (this.pos == 4096) {
                    this.writer.write(this.buffer);
                    this.pos = 0;
                }
                this.buffer[this.pos] = text.charAt(i);
                ++this.pos;
            }
        }
        catch (IOException except) {
            if (this.exception == null) {
                this.exception = except;
            }
            throw except;
        }
    }

    public void printText(char[] chars, int start, int length) throws IOException {
        try {
            while (length-- > 0) {
                if (this.pos == 4096) {
                    this.writer.write(this.buffer);
                    this.pos = 0;
                }
                this.buffer[this.pos] = chars[start];
                ++start;
                ++this.pos;
            }
        }
        catch (IOException except) {
            if (this.exception == null) {
                this.exception = except;
            }
            throw except;
        }
    }

    public void printText(char ch) throws IOException {
        try {
            if (this.pos == 4096) {
                this.writer.write(this.buffer);
                this.pos = 0;
            }
            this.buffer[this.pos] = ch;
            ++this.pos;
        }
        catch (IOException except) {
            if (this.exception == null) {
                this.exception = except;
            }
            throw except;
        }
    }

    public void printSpace() throws IOException {
        try {
            if (this.pos == 4096) {
                this.writer.write(this.buffer);
                this.pos = 0;
            }
            this.buffer[this.pos] = 32;
            ++this.pos;
        }
        catch (IOException except) {
            if (this.exception == null) {
                this.exception = except;
            }
            throw except;
        }
    }

    public void breakLine() throws IOException {
        try {
            if (this.pos == 4096) {
                this.writer.write(this.buffer);
                this.pos = 0;
            }
            this.buffer[this.pos] = 10;
            ++this.pos;
        }
        catch (IOException except) {
            if (this.exception == null) {
                this.exception = except;
            }
            throw except;
        }
    }

    public void breakLine(boolean preserveSpace) throws IOException {
        this.breakLine();
    }

    public void flushLine(boolean preserveSpace) throws IOException {
        block2: {
            try {
                this.writer.write(this.buffer, 0, this.pos);
            }
            catch (IOException except) {
                if (this.exception != null) break block2;
                this.exception = except;
            }
        }
        this.pos = 0;
    }

    public void flush() throws IOException {
        try {
            this.writer.write(this.buffer, 0, this.pos);
            this.writer.flush();
        }
        catch (IOException except) {
            if (this.exception == null) {
                this.exception = except;
            }
            throw except;
        }
        this.pos = 0;
    }

    public void indent() {
    }

    public void unindent() {
    }

    public int getNextIndent() {
        return 0;
    }

    public void setNextIndent(int indent) {
    }

    public void setThisIndent(int indent) {
    }
}

