/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.util.Collections;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Jsr77Naming;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.CommandLine;
import org.apache.geronimo.system.main.ExceptionUtil;

public class ClientCommandLine
extends CommandLine {
    public static void main(String[] args) {
        log.info((Object)"Client startup begun");
        if (args.length == 0) {
            System.out.println();
            System.out.println("ERROR: No arguments");
            ClientCommandLine.showHelp();
            System.exit(1);
        } else if (args[0].equals("--help") || args[0].equals("-h") || args[0].equals("/?")) {
            ClientCommandLine.showHelp();
            System.exit(0);
        }
        try {
            Artifact configuration = Artifact.create((String)args[0]);
            String[] clientArgs = new String[args.length - 1];
            System.arraycopy(args, 1, clientArgs, 0, clientArgs.length);
            new ClientCommandLine(configuration, clientArgs);
            log.info((Object)"Client shutdown completed");
        }
        catch (Exception e) {
            ExceptionUtil.trimStackTrace(e);
            e.printStackTrace();
            System.exit(2);
            throw new AssertionError();
        }
    }

    private static void showHelp() {
        System.out.println();
        System.out.println("syntax:   java -jar bin/client.jar config-name [app arg] [app arg] ...");
        System.out.println();
        System.out.println("The first argument should identify the Geronimo configuration that");
        System.out.println("contains the application client you want to run.");
        System.out.println();
        System.out.println("The rest of the arguments will be passed as arguments to the");
        System.out.println("application client when it is started.");
        System.out.println();
    }

    public ClientCommandLine(Artifact configuration, String[] args) throws Exception {
        Jsr77Naming naming = new Jsr77Naming();
        AbstractName baseName = naming.createRootName(configuration, configuration.toString(), "J2EEApplication");
        AbstractNameQuery baseNameQuery = new AbstractNameQuery(baseName);
        this.invokeMainGBean(Collections.singletonList(configuration), baseNameQuery, "main", args);
    }
}

