/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.util.ArrayList;

public class ExceptionUtil {
    private static final String[] excludedPackages = new String[]{"org.apache.geronimo.gbean.jmx.", "mx4j.", "net.sf.cglib.reflect.", "sun.reflect."};
    private static final String[] excludedStrings = new String[]{"$$EnhancerByCGLIB$$", "$$FastClassByCGLIB$$"};

    public static void trimStackTrace(Throwable t) {
        int i;
        if (t == null) {
            return;
        }
        StackTraceElement[] trace = t.getStackTrace();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        boolean skip = true;
        for (i = 0; i < trace.length && skip; ++i) {
            skip = skip && ExceptionUtil.isExcluded(trace[i].getClassName());
        }
        list.add(trace[i - 1]);
        while (i < trace.length) {
            if (!ExceptionUtil.isExcluded(trace[i].getClassName())) {
                list.add(trace[i]);
            }
            ++i;
        }
        t.setStackTrace(list.toArray(new StackTraceElement[0]));
        ExceptionUtil.trimStackTrace(t.getCause());
    }

    private static boolean isExcluded(String className) {
        int j;
        for (j = 0; j < excludedPackages.length; ++j) {
            if (!className.startsWith(excludedPackages[j])) continue;
            return true;
        }
        for (j = 0; j < excludedStrings.length; ++j) {
            if (className.indexOf(excludedStrings[j]) == -1) continue;
            return true;
        }
        return false;
    }
}

