/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.main.StartupMonitor;

public class SilentStartupMonitor
implements StartupMonitor {
    private static final Log log = LogFactory.getLog((String)SilentStartupMonitor.class.getName());
    private Kernel kernel;

    public void systemStarting(long startTime) {
    }

    public void systemStarted(Kernel kernel) {
        this.kernel = kernel;
    }

    public void foundModules(Artifact[] modules) {
    }

    public void moduleLoading(Artifact module) {
    }

    public void moduleLoaded(Artifact module) {
    }

    public void moduleStarting(Artifact module) {
    }

    public void moduleStarted(Artifact module) {
    }

    public void startupFinished() {
        try {
            Set gbeans = this.kernel.listGBeans((AbstractNameQuery)null);
            Iterator it = gbeans.iterator();
            while (it.hasNext()) {
                AbstractName name = (AbstractName)it.next();
                int state = this.kernel.getGBeanState(name);
                if (state == 1) continue;
                log.warn((Object)("Unable to start " + name + " (" + State.fromInt((int)state).getName() + ")"));
            }
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
        System.out.println("Geronimo startup complete");
    }

    public void serverStartFailed(Exception problem) {
        System.out.println("Geronimo startup failed:");
        problem.printStackTrace(System.out);
    }
}

