/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.DefaultArtifactResolver;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ExplicitDefaultArtifactResolver
extends DefaultArtifactResolver {
    public static final GBeanInfo GBEAN_INFO;

    public ExplicitDefaultArtifactResolver(String versionMapLocation, ArtifactManager artifactManager, Collection repositories, ServerInfo serverInfo) throws IOException {
        super(artifactManager, repositories, ExplicitDefaultArtifactResolver.buildExplicitResolution(versionMapLocation, serverInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map buildExplicitResolution(String versionMapLocation, ServerInfo serverInfo) throws IOException {
        if (versionMapLocation == null) {
            return null;
        }
        File location = serverInfo == null ? new File(versionMapLocation) : serverInfo.resolve(versionMapLocation);
        FileInputStream in = new FileInputStream(location);
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        finally {
            in.close();
        }
        return ExplicitDefaultArtifactResolver.propertiesToArtifactMap(properties);
    }

    private static Map propertiesToArtifactMap(Properties properties) {
        HashMap<Artifact, Artifact> explicitResolution = new HashMap<Artifact, Artifact>();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            String version = (String)entry.getValue();
            String[] parts = key.split("/", -1);
            if (parts.length != 4) {
                throw new IllegalArgumentException("Invalid id: " + key);
            }
            Artifact source = new Artifact(parts[0], parts[1], (String)null, parts[3]);
            Artifact resolved = new Artifact(source.getGroupId(), source.getArtifactId(), version, source.getType());
            explicitResolution.put(source, resolved);
        }
        return explicitResolution;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)ExplicitDefaultArtifactResolver.class, (String)"ArtifactResolver");
        infoFactory.addAttribute("versionMapLocation", String.class, true, true);
        infoFactory.addReference("ArtifactManager", ArtifactManager.class, "ArtifactManager");
        infoFactory.addReference("Repositories", ListableRepository.class, "Repository");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "ServerInfo");
        infoFactory.addInterface(ArtifactResolver.class);
        infoFactory.setConstructor(new String[]{"versionMapLocation", "ArtifactManager", "Repositories", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

