/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.geronimo.kernel.config.IOUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.system.configuration.ConfigurationStoreUtil;
import org.apache.geronimo.system.configuration.GBeanOverride;
import org.apache.geronimo.system.configuration.RepositoryConfigurationStore;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginInstallerGBean;
import org.apache.geronimo.system.plugin.PluginMetadata;
import org.apache.geronimo.system.repository.CopyArtifactTypeHandler;
import org.apache.geronimo.system.repository.Maven1Repository;
import org.apache.geronimo.system.repository.Maven2Repository;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PluginRepositoryExporter {
    private static final String NAMESPACE = "http://geronimo.apache.org/xml/ns/plugins-1.1";
    private static final Map VERSION_MAP = new HashMap();
    private Maven1Repository sourceRepo;
    private Maven2Repository destRepo;
    private Map targetVersions;
    private PluginInstallerGBean installer;
    private File pluginList;
    private File schema;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginRepositoryExporter(String inPath, String outPath, String schema) throws IOException {
        this.schema = new File(schema);
        if (!this.schema.isFile() || !this.schema.canRead()) {
            throw new IllegalArgumentException("Bad schema file " + this.schema.getAbsolutePath());
        }
        File inFile = new File(inPath);
        if (!inFile.isDirectory() || !inFile.canRead()) {
            throw new IllegalArgumentException("Bad source repo directory " + inFile.getAbsolutePath());
        }
        File outFile = new File(outPath);
        if (outFile.exists()) {
            if (!outFile.isDirectory() || !outFile.canRead()) {
                throw new IllegalArgumentException("Bad target repo directory " + outFile.getAbsolutePath());
            }
        } else if (!outFile.mkdirs()) {
            throw new IllegalArgumentException("Can't create target repo directory " + outFile.getAbsolutePath());
        }
        this.pluginList = new File(outFile, "geronimo-plugins.xml");
        if (!this.pluginList.exists() && !this.pluginList.createNewFile()) {
            throw new IllegalArgumentException("Can't create target plugin list file " + this.pluginList.getAbsolutePath());
        }
        this.sourceRepo = new Maven1Repository(inFile);
        this.destRepo = new Maven2Repository(outFile);
        this.destRepo.setTypeHandler("car", new CopyArtifactTypeHandler());
        Properties props = new Properties();
        InputStream is = PluginRepositoryExporter.class.getResourceAsStream("/META-INF/product-versions.properties");
        if (is == null) {
            throw new IOException("Unable to locate /META-INF/product-versions.properties");
        }
        try {
            props.load(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
        this.targetVersions = new HashMap();
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String product = (String)it.next();
            String version = props.getProperty(product);
            this.targetVersions.put(product, new Version(version));
        }
        RepositoryConfigurationStore store = new RepositoryConfigurationStore(this.destRepo);
        ServerInfo info = new ServerInfo(){

            public String getBaseDirectory() {
                return null;
            }

            public String getBuildDate() {
                return null;
            }

            public String getBuildTime() {
                return null;
            }

            public String getCopyright() {
                return null;
            }

            public String getCurrentBaseDirectory() {
                return null;
            }

            public String getVersion() {
                return null;
            }

            public File resolve(String filename) {
                return null;
            }

            public URI resolve(URI uri) {
                return null;
            }

            public String resolvePath(String filename) {
                return null;
            }

            public File resolveServer(String filename) {
                return null;
            }

            public URI resolveServer(URI uri) {
                return null;
            }

            public String resolveServerPath(String filename) {
                return null;
            }
        };
        this.installer = new PluginInstallerGBean(null, this.destRepo, store, info, null, null);
    }

    public void execute() throws IOException {
        SortedSet list = this.sourceRepo.list();
        try {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                if (!artifact.getGroupId().equals("geronimo") && !artifact.getGroupId().equals("activemq") && !artifact.getGroupId().equals("openejb") && !artifact.getGroupId().equals("tranql") || !artifact.getVersion().equals(this.targetVersions.get(artifact.getGroupId())) || artifact.getType().equals("pom") || artifact.getType().equals("distribution") || artifact.getType().equals("plugin") || artifact.getType().equals("javadoc.jar")) continue;
                System.out.println("Copying " + artifact);
                if (this.destRepo.contains(artifact)) {
                    File location = this.destRepo.getLocation(artifact);
                    IOUtil.recursiveDelete((File)location);
                }
                this.destRepo.copyToRepository(this.sourceRepo.getLocation(artifact), artifact, null);
                File dest = this.destRepo.getLocation(artifact);
                File versionDir = dest.getParentFile();
                File artifactDir = versionDir.getParentFile();
                if (!artifactDir.isDirectory() || !artifactDir.canRead()) {
                    throw new IllegalStateException("Failed to located group/artifact dir for " + artifact + " (got " + artifactDir.getAbsolutePath() + ")");
                }
                this.updatePluginMetadata(artifact);
                this.updateMavenMetadata(artifactDir, artifact);
            }
            Map plugins = this.installer.getInstalledPlugins();
            Document doc = this.generateConfigFile(this.installer, plugins.values());
            TransformerFactory xfactory = TransformerFactory.newInstance();
            Transformer xform = xfactory.newTransformer();
            xform.setOutputProperty("indent", "yes");
            xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            System.out.println("Writing geronimo-plugins.xml file...");
            FileWriter out = new FileWriter(this.pluginList);
            xform.transform(new DOMSource(doc), new StreamResult(out));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Unable to format XML output: " + e.getMessage());
        }
    }

    private void updatePluginMetadata(Artifact artifact) {
        PluginMetadata data = this.installer.getPluginMetadata(artifact);
        if (data == null) {
            return;
        }
        if (data.getGeronimoVersions() != null && data.getGeronimoVersions().length == 1 && VERSION_MAP.containsKey(data.getGeronimoVersions()[0])) {
            data.setGeronimoVersions(((List)VERSION_MAP.get(data.getGeronimoVersions()[0])).toArray(new String[0]));
            if (data.getHash() != null) {
                data = this.copy(data);
            }
            this.installer.updatePluginMetadata(data);
        }
    }

    private PluginMetadata copy(PluginMetadata source) {
        PluginMetadata data = new PluginMetadata(source.getName(), source.getModuleId(), source.getCategory(), source.getDescription(), source.getPluginURL(), source.getAuthor(), null, source.isInstalled(), source.isEligible());
        data.setConfigXmls(source.getConfigXmls());
        data.setDependencies(source.getDependencies());
        data.setFilesToCopy(source.getFilesToCopy());
        data.setForceStart(source.getForceStart());
        data.setGeronimoVersions(source.getGeronimoVersions());
        data.setJvmVersions(source.getJvmVersions());
        data.setLicenses(source.getLicenses());
        data.setObsoletes(source.getObsoletes());
        data.setPrerequisites(source.getPrerequisites());
        data.setRepositories(source.getRepositories());
        return data;
    }

    private void updateMavenMetadata(File dir, Artifact artifact) throws TransformerException, IOException, SAXException, ParserConfigurationException {
        Document doc;
        File mavenFile = new File(dir, "maven-metadata.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (mavenFile.exists()) {
            doc = builder.parse(mavenFile);
        } else {
            doc = builder.newDocument();
            this.createMavenMetadata(doc, artifact);
        }
        NodeList versions = doc.getElementsByTagName("versions");
        Element versionsElement = (Element)versions.item(0);
        versions = versionsElement.getElementsByTagName("version");
        boolean found = false;
        for (int i = 0; i < versions.getLength(); ++i) {
            String version = PluginRepositoryExporter.getText(versions.item(i)).trim();
            if (version.equals(artifact.getVersion().toString())) {
                found = true;
                break;
            }
            Version test = new Version(version);
            if (test.compareTo((Object)artifact.getVersion()) <= 0) continue;
            Element newVersion = doc.createElement("version");
            newVersion.appendChild(doc.createTextNode(artifact.getVersion().toString()));
            versionsElement.insertBefore(newVersion, versions.item(i));
            found = true;
        }
        if (!found) {
            Element newVersion = doc.createElement("version");
            newVersion.appendChild(doc.createTextNode(artifact.getVersion().toString()));
            versionsElement.appendChild(newVersion);
        }
        TransformerFactory xfactory = TransformerFactory.newInstance();
        Transformer xform = xfactory.newTransformer();
        xform.setOutputProperty("indent", "yes");
        xform.transform(new DOMSource(doc), new StreamResult(mavenFile));
    }

    private void createMavenMetadata(Document doc, Artifact artifact) {
        Element root = doc.createElement("metadata");
        doc.appendChild(root);
        this.createText(doc, root, "groupId", artifact.getGroupId());
        this.createText(doc, root, "artifactId", artifact.getArtifactId());
        this.createText(doc, root, "version", artifact.getVersion().toString());
        Element versioning = doc.createElement("versioning");
        root.appendChild(versioning);
        Element versions = doc.createElement("versions");
        versioning.appendChild(versions);
        this.createText(doc, versions, "version", artifact.getVersion().toString());
    }

    private Document generateConfigFile(PluginInstaller installer, Collection plugins) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.schema.getName());
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElementNS(NAMESPACE, "geronimo-plugin-list");
        root.setAttribute("xmlns", NAMESPACE);
        doc.appendChild(root);
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            String version;
            int i;
            Artifact plugin = (Artifact)it.next();
            System.out.println("Including plugin data for " + plugin);
            PluginMetadata data = installer.getPluginMetadata(plugin);
            if (data == null) {
                throw new IllegalArgumentException("Invalid plugin file; Log4J output for a specific error.");
            }
            File file = this.destRepo.getLocation(plugin);
            Element config = doc.createElement("plugin");
            root.appendChild(config);
            this.createText(doc, config, "name", data.getName());
            this.createText(doc, config, "module-id", data.getModuleId().toString());
            this.createText(doc, config, "category", data.getCategory());
            this.createText(doc, config, "description", data.getDescription());
            if (data.getPluginURL() != null) {
                this.createText(doc, config, "url", data.getPluginURL());
            }
            if (data.getAuthor() != null) {
                this.createText(doc, config, "author", data.getAuthor());
            }
            for (int i2 = 0; i2 < data.getLicenses().length; ++i2) {
                PluginMetadata.License license = data.getLicenses()[i2];
                Element lic = doc.createElement("license");
                lic.appendChild(doc.createTextNode(license.getName()));
                lic.setAttribute("osi-approved", license.isOsiApproved() ? "true" : "false");
                config.appendChild(lic);
            }
            if (data.getHash() != null) {
                Element hash = doc.createElement("hash");
                hash.setAttribute("type", data.getHash().getType());
                hash.appendChild(doc.createTextNode(data.getHash().getValue()));
                config.appendChild(hash);
            } else if (file.isFile() && file.canRead()) {
                Element hash = doc.createElement("hash");
                hash.setAttribute("type", "SHA-1");
                hash.appendChild(doc.createTextNode(ConfigurationStoreUtil.getActualChecksum(file)));
                config.appendChild(hash);
            }
            for (i = 0; i < data.getGeronimoVersions().length; ++i) {
                version = data.getGeronimoVersions()[i];
                this.createText(doc, config, "geronimo-version", version);
            }
            for (i = 0; i < data.getJvmVersions().length; ++i) {
                version = data.getJvmVersions()[i];
                this.createText(doc, config, "jvm-version", version);
            }
            for (i = 0; i < data.getPrerequisites().length; ++i) {
                PluginMetadata.Prerequisite prereq = data.getPrerequisites()[i];
                this.writePrerequisite(doc, config, prereq);
            }
            for (i = 0; i < data.getDependencies().length; ++i) {
                version = data.getDependencies()[i];
                this.createText(doc, config, "dependency", version);
            }
            for (i = 0; i < data.getObsoletes().length; ++i) {
                version = data.getObsoletes()[i];
                this.createText(doc, config, "obsoletes", version);
            }
            for (i = 0; i < data.getFilesToCopy().length; ++i) {
                PluginMetadata.CopyFile copyFile = data.getFilesToCopy()[i];
                Element copy = doc.createElement("copy-file");
                copy.setAttribute("relative-to", copyFile.isRelativeToVar() ? "server" : "geronimo");
                copy.setAttribute("dest-dir", copyFile.getDestDir());
                copy.appendChild(doc.createTextNode(copyFile.getSourceFile()));
                config.appendChild(copy);
            }
            if (data.getConfigXmls().length <= 0) continue;
            Element content = doc.createElement("config-xml-content");
            for (int i3 = 0; i3 < data.getConfigXmls().length; ++i3) {
                GBeanOverride override = data.getConfigXmls()[i3];
                Element gbean = override.writeXml(doc, content);
                gbean.setAttribute("xmlns", "http://geronimo.apache.org/xml/ns/attributes-1.1");
            }
            config.appendChild(content);
        }
        Version ger = (Version)this.targetVersions.get("geronimo");
        this.createText(doc, root, "default-repository", "http://www.geronimoplugins.com/repository/geronimo-" + ger.getMajorVersion() + "." + ger.getMinorVersion());
        this.createText(doc, root, "default-repository", "http://www.ibiblio.org/maven2/");
        return doc;
    }

    private void writePrerequisite(Document doc, Element config, PluginMetadata.Prerequisite data) {
        Element prereq = doc.createElement("prerequisite");
        config.appendChild(prereq);
        this.createText(doc, prereq, "id", data.getModuleId().toString());
        this.createText(doc, prereq, "resource-type", data.getResourceType());
        this.createText(doc, prereq, "description", data.getDescription());
    }

    private void createText(Document doc, Element parent, String name, String text) {
        Element child = doc.createElement(name);
        parent.appendChild(child);
        Text node = doc.createTextNode(text);
        child.appendChild(node);
    }

    private static String getText(Node target) {
        NodeList nodes = target.getChildNodes();
        StringBuffer buf = null;
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (node.getNodeType() != 3) continue;
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(node.getNodeValue());
        }
        return buf == null ? null : buf.toString();
    }

    public static void main(String[] args) {
        try {
            new PluginRepositoryExporter(args[0], args[1], args[2]).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1.1-SNAPSHOT");
        list.add("1.1-20060607");
        list.add("1.1-rc1");
        list.add("1.1-rc2");
        list.add("1.1-rc3");
        list.add("1.1");
        VERSION_MAP.put("1.1-SNAPSHOT", list);
        list = new ArrayList();
        list.add("1.2-SNAPSHOT");
        list.add("1.2-beta1");
        list.add("1.2-beta2");
        list.add("1.2-beta3");
        list.add("1.2-rc1");
        list.add("1.2-rc2");
        list.add("1.2-rc3");
        list.add("1.2");
        VERSION_MAP.put("1.2-SNAPSHOT", list);
    }
}

