/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.TransactionTimer;
import org.apache.geronimo.transaction.manager.XidFactory;

public class TransactionImpl
implements Transaction {
    private static final Log log = LogFactory.getLog((String)"Transaction");
    private final XidFactory xidFactory;
    private final Xid xid;
    private final TransactionLog txnLog;
    private final long timeout;
    private final List syncList = new ArrayList(5);
    private final LinkedList resourceManagers = new LinkedList();
    private final IdentityHashMap activeXaResources = new IdentityHashMap(3);
    private final IdentityHashMap suspendedXaResources = new IdentityHashMap(3);
    private int status = 6;
    private Object logMark;

    TransactionImpl(XidFactory xidFactory, TransactionLog txnLog, long transactionTimeoutMilliseconds) throws SystemException {
        this(xidFactory.createXid(), xidFactory, txnLog, transactionTimeoutMilliseconds);
    }

    TransactionImpl(Xid xid, XidFactory xidFactory, TransactionLog txnLog, long transactionTimeoutMilliseconds) throws SystemException {
        this.xidFactory = xidFactory;
        this.txnLog = txnLog;
        this.xid = xid;
        this.timeout = transactionTimeoutMilliseconds + TransactionTimer.getCurrentTime();
        try {
            txnLog.begin(xid);
        }
        catch (LogException e) {
            this.status = 1;
            SystemException ex = new SystemException("Error logging begin; transaction marked for roll back)");
            ex.initCause(e);
            throw ex;
        }
        this.status = 0;
    }

    public TransactionImpl(Xid xid, TransactionLog txLog) {
        this.xidFactory = null;
        this.txnLog = txLog;
        this.xid = xid;
        this.status = 2;
        this.timeout = Long.MAX_VALUE;
    }

    public synchronized int getStatus() throws SystemException {
        return this.status;
    }

    public synchronized void setRollbackOnly() throws IllegalStateException, SystemException {
        switch (this.status) {
            case 0: 
            case 7: {
                this.status = 1;
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot set rollback only, status is " + TransactionImpl.getStateString(this.status));
            }
        }
    }

    public synchronized void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
        if (synch == null) {
            throw new IllegalArgumentException("Synchronization is null");
        }
        switch (this.status) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                throw new RollbackException("Transaction is marked for rollback");
            }
            default: {
                throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
            }
        }
        this.syncList.add(synch);
    }

    public synchronized boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("XAResource is null");
        }
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                throw new RollbackException("Transaction is marked for rollback");
            }
            default: {
                throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
            }
        }
        if (this.activeXaResources.containsKey(xaRes)) {
            throw new IllegalStateException("xaresource: " + xaRes + " is already enlisted!");
        }
        try {
            TransactionBranch manager = (TransactionBranch)this.suspendedXaResources.remove(xaRes);
            if (manager != null) {
                xaRes.start(manager.getBranchId(), 0x8000000);
                this.activeXaResources.put(xaRes, manager);
                return true;
            }
            Iterator i = this.resourceManagers.iterator();
            while (i.hasNext()) {
                boolean sameRM;
                manager = (TransactionBranch)i.next();
                if (xaRes == manager.getCommitter()) {
                    throw new IllegalStateException("xaRes " + xaRes + " is a committer but is not active or suspended");
                }
                try {
                    sameRM = xaRes.isSameRM(manager.getCommitter());
                }
                catch (XAException e) {
                    log.warn((Object)"Unexpected error checking for same RM", (Throwable)e);
                    continue;
                }
                if (!sameRM) continue;
                xaRes.start(manager.getBranchId(), 0x200000);
                this.activeXaResources.put(xaRes, manager);
                return true;
            }
            Xid branchId = this.xidFactory.createBranch(this.xid, this.resourceManagers.size() + 1);
            xaRes.start(branchId, 0);
            this.activeXaResources.put(xaRes, this.addBranchXid(xaRes, branchId));
            return true;
        }
        catch (XAException e) {
            log.warn((Object)("Unable to enlist XAResource " + xaRes + ", errorCode: " + e.errorCode), (Throwable)e);
            return false;
        }
    }

    public synchronized boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (flag != 0x20000000 && flag != 0x4000000 && flag != 0x2000000) {
            throw new IllegalStateException("invalid flag for delistResource: " + flag);
        }
        if (xaRes == null) {
            throw new IllegalArgumentException("XAResource is null");
        }
        switch (this.status) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
            }
        }
        TransactionBranch manager = (TransactionBranch)this.activeXaResources.remove(xaRes);
        if (manager == null) {
            if (flag == 0x2000000) {
                throw new IllegalStateException("trying to suspend an inactive xaresource: " + xaRes);
            }
            manager = (TransactionBranch)this.suspendedXaResources.remove(xaRes);
            if (manager == null) {
                throw new IllegalStateException("Resource not known to transaction: " + xaRes);
            }
        }
        try {
            xaRes.end(manager.getBranchId(), flag);
            if (flag == 0x2000000) {
                this.suspendedXaResources.put(xaRes, manager);
            }
            return true;
        }
        catch (XAException e) {
            log.warn((Object)("Unable to delist XAResource " + xaRes + ", error code: " + e.errorCode), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
        this.beforePrepare();
        try {
            boolean timedout = false;
            if (TransactionTimer.getCurrentTime() > this.timeout) {
                this.status = 1;
                timedout = true;
            }
            if (this.status == 1) {
                this.rollbackResources(this.resourceManagers);
                if (!timedout) throw new RollbackException("Unable to commit");
                throw new RollbackException("Transaction timout");
            }
            TransactionImpl transactionImpl = this;
            // MONITORENTER : transactionImpl
            if (this.status == 0) {
                this.status = this.resourceManagers.size() == 0 ? 3 : (this.resourceManagers.size() == 1 ? 8 : 7);
            }
            // MONITOREXIT : transactionImpl
            if (this.resourceManagers.size() == 0) {
                transactionImpl = this;
                // MONITORENTER : transactionImpl
                this.status = 3;
                // MONITOREXIT : transactionImpl
                Object var8_4 = null;
                this.afterCompletion();
                TransactionImpl transactionImpl2 = this;
                // MONITORENTER : transactionImpl2
                this.status = 6;
                // MONITOREXIT : transactionImpl2
                return;
            }
            if (this.resourceManagers.size() == 1) {
                TransactionBranch manager = (TransactionBranch)this.resourceManagers.getFirst();
                try {
                    manager.getCommitter().commit(manager.getBranchId(), true);
                    TransactionImpl transactionImpl3 = this;
                    // MONITORENTER : transactionImpl3
                    this.status = 3;
                    // MONITOREXIT : transactionImpl3
                }
                catch (XAException e) {
                    TransactionImpl transactionImpl4 = this;
                    // MONITORENTER : transactionImpl4
                    this.status = 4;
                    // MONITOREXIT : transactionImpl4
                    throw (RollbackException)new RollbackException("Error during one-phase commit").initCause(e);
                }
                Object var8_5 = null;
                this.afterCompletion();
                TransactionImpl transactionImpl5 = this;
                // MONITORENTER : transactionImpl5
                this.status = 6;
                // MONITOREXIT : transactionImpl5
                return;
            }
            boolean willCommit = this.internalPrepare();
            if (!willCommit) {
                this.rollbackResources(this.resourceManagers);
                throw new RollbackException("Unable to commit");
            }
            this.commitResources(this.resourceManagers);
            Object var8_6 = null;
            this.afterCompletion();
            TransactionImpl transactionImpl6 = this;
            // MONITORENTER : transactionImpl6
            this.status = 6;
            // MONITOREXIT : transactionImpl6
            return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.afterCompletion();
            TransactionImpl transactionImpl = this;
            // MONITORENTER : transactionImpl
            this.status = 6;
            // MONITOREXIT : transactionImpl
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int prepare() throws SystemException, RollbackException {
        int result;
        block14: {
            TransactionImpl transactionImpl;
            int n;
            block13: {
                this.beforePrepare();
                result = 3;
                try {
                    LinkedList rms;
                    TransactionImpl transactionImpl2 = this;
                    synchronized (transactionImpl2) {
                        if (this.status == 0) {
                            if (this.resourceManagers.size() == 0) {
                                this.status = 3;
                                n = result;
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 11, 12] lbl10 : MonitorExitStatement: MONITOREXIT : var3_2
                                Object var7_5 = null;
                                if (result != 3) return n;
                                this.afterCompletion();
                                transactionImpl = this;
                                break block13;
                            }
                            this.status = 7;
                        }
                        rms = this.resourceManagers;
                    }
                    boolean willCommit = this.internalPrepare();
                    if (!willCommit) {
                        this.rollbackResources(rms);
                        throw new RollbackException("Unable to commit");
                    }
                    if (!rms.isEmpty()) {
                        result = 0;
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (result != 3) throw throwable;
                    this.afterCompletion();
                    TransactionImpl transactionImpl3 = this;
                    synchronized (transactionImpl3) {
                        this.status = 6;
                        throw throwable;
                    }
                }
            }
            synchronized (transactionImpl) {
                this.status = 6;
                return n;
            }
        }
        Object var7_6 = null;
        if (result != 3) return result;
        this.afterCompletion();
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = 6;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preparedCommit() throws SystemException {
        TransactionImpl transactionImpl;
        try {
            this.commitResources(this.resourceManagers);
            Object var2_1 = null;
            this.afterCompletion();
            transactionImpl = this;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.afterCompletion();
            TransactionImpl transactionImpl2 = this;
            synchronized (transactionImpl2) {
                this.status = 6;
            }
            throw throwable;
        }
        synchronized (transactionImpl) {
            this.status = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforePrepare() {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            switch (this.status) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
                }
            }
        }
        this.beforeCompletion();
        this.endResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalPrepare() throws SystemException {
        boolean willCommit;
        Object manager;
        Iterator rms = this.resourceManagers.iterator();
        while (rms.hasNext()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (this.status != 7) {
                    break;
                }
            }
            manager = (TransactionBranch)rms.next();
            try {
                int vote = ((TransactionBranch)manager).getCommitter().prepare(((TransactionBranch)manager).getBranchId());
                if (vote != 3) continue;
                rms.remove();
            }
            catch (XAException e) {
                TransactionImpl transactionImpl2 = this;
                synchronized (transactionImpl2) {
                    this.status = 1;
                    rms.remove();
                    break;
                }
            }
        }
        manager = this;
        synchronized (manager) {
            boolean bl = willCommit = this.status != 1;
            if (willCommit) {
                this.status = 2;
            }
        }
        if (willCommit && !this.resourceManagers.isEmpty()) {
            try {
                this.logMark = this.txnLog.prepare(this.xid, this.resourceManagers);
            }
            catch (LogException e) {
                try {
                    this.rollbackResources(this.resourceManagers);
                }
                catch (Exception se) {
                    log.error((Object)"Unable to rollback after failure to log prepare", se.getCause());
                }
                throw (SystemException)new SystemException("Error logging prepare; transaction was rolled back)").initCause(e);
            }
        }
        return willCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SystemException {
        TransactionImpl transactionImpl;
        LinkedList rms;
        TransactionImpl transactionImpl2 = this;
        synchronized (transactionImpl2) {
            switch (this.status) {
                case 0: {
                    this.status = 1;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Status is " + TransactionImpl.getStateString(this.status));
                }
            }
            rms = this.resourceManagers;
        }
        this.beforeCompletion();
        this.endResources();
        try {
            this.rollbackResources(rms);
            if (this.logMark != null) {
                try {
                    this.txnLog.rollback(this.xid, this.logMark);
                }
                catch (LogException e) {
                    try {
                        this.rollbackResources(rms);
                    }
                    catch (Exception se) {
                        log.error((Object)"Unable to rollback after failure to log decision", se.getCause());
                    }
                    throw (SystemException)new SystemException("Error logging rollback").initCause(e);
                }
            }
            Object var5_6 = null;
            this.afterCompletion();
            transactionImpl = this;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.afterCompletion();
            TransactionImpl transactionImpl3 = this;
            synchronized (transactionImpl3) {
                this.status = 6;
            }
            throw throwable;
        }
        synchronized (transactionImpl) {
            this.status = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeCompletion() {
        int i = 0;
        while (true) {
            Synchronization synch;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                if (i == this.syncList.size()) {
                    return;
                }
                synch = (Synchronization)this.syncList.get(i++);
            }
            try {
                synch.beforeCompletion();
            }
            catch (Exception e) {
                log.warn((Object)"Unexpected exception from beforeCompletion; transaction will roll back", (Throwable)e);
                TransactionImpl transactionImpl2 = this;
                synchronized (transactionImpl2) {
                    this.status = 1;
                }
            }
        }
    }

    private void afterCompletion() {
        Iterator i = this.syncList.iterator();
        while (i.hasNext()) {
            Synchronization synch = (Synchronization)i.next();
            try {
                synch.afterCompletion(this.status);
            }
            catch (Exception e) {
                log.warn((Object)"Unexpected exception from afterCompletion; continuing", (Throwable)e);
            }
        }
    }

    private void endResources() {
        this.endResources(this.activeXaResources);
        this.endResources(this.suspendedXaResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endResources(IdentityHashMap resourceMap) {
        while (true) {
            int flags;
            TransactionBranch manager;
            XAResource xaRes;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                Set entrySet = resourceMap.entrySet();
                if (entrySet.isEmpty()) {
                    return;
                }
                Map.Entry entry = entrySet.iterator().next();
                xaRes = (XAResource)entry.getKey();
                manager = (TransactionBranch)entry.getValue();
                flags = this.status == 1 ? 0x20000000 : 0x4000000;
                resourceMap.remove(xaRes);
            }
            try {
                xaRes.end(manager.getBranchId(), flags);
            }
            catch (XAException e) {
                log.warn((Object)("Error ending association for XAResource " + xaRes + "; transaction will roll back. XA error code: " + e.errorCode), (Throwable)e);
                TransactionImpl transactionImpl2 = this;
                synchronized (transactionImpl2) {
                    this.status = 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackResources(List rms) throws SystemException {
        SystemException cause = null;
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = 9;
        }
        Iterator i = rms.iterator();
        while (i.hasNext()) {
            TransactionBranch manager = (TransactionBranch)i.next();
            try {
                manager.getCommitter().rollback(manager.getBranchId());
            }
            catch (XAException e) {
                log.error((Object)("Unexpected exception rolling back " + manager.getCommitter() + "; continuing with rollback"), (Throwable)e);
                if (cause != null) continue;
                cause = new SystemException(e.errorCode);
            }
        }
        transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = 4;
        }
        if (cause != null) {
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResources(List rms) throws SystemException {
        SystemException cause = null;
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = 8;
        }
        Iterator i = rms.iterator();
        while (i.hasNext()) {
            TransactionBranch manager = (TransactionBranch)i.next();
            try {
                manager.getCommitter().commit(manager.getBranchId(), false);
            }
            catch (XAException e) {
                log.error((Object)("Unexpected exception committing" + manager.getCommitter() + "; continuing to commit other RMs"), (Throwable)e);
                if (cause != null) continue;
                cause = new SystemException(e.errorCode);
            }
        }
        if (!rms.isEmpty()) {
            try {
                this.txnLog.commit(this.xid, this.logMark);
            }
            catch (LogException e) {
                log.error((Object)("Unexpected exception logging commit completion for xid " + this.xid), (Throwable)e);
                throw (SystemException)new SystemException("Unexpected error logging commit completion for xid " + this.xid).initCause(e);
            }
        }
        transactionImpl = this;
        synchronized (transactionImpl) {
            this.status = 3;
        }
        if (cause != null) {
            throw cause;
        }
    }

    private static String getStateString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransactionImpl) {
            TransactionImpl other = (TransactionImpl)obj;
            return this.xid.equals(other.xid);
        }
        return false;
    }

    public TransactionBranch addBranchXid(XAResource xaRes, Xid branchId) {
        TransactionBranch manager = new TransactionBranch(xaRes, branchId);
        this.resourceManagers.add(manager);
        return manager;
    }

    private static class TransactionBranch
    implements TransactionBranchInfo {
        private final XAResource committer;
        private final Xid branchId;

        public TransactionBranch(XAResource xaRes, Xid branchId) {
            this.committer = xaRes;
            this.branchId = branchId;
        }

        public XAResource getCommitter() {
            return this.committer;
        }

        public Xid getBranchId() {
            return this.branchId;
        }

        public String getResourceName() {
            if (this.committer instanceof NamedXAResource) {
                return ((NamedXAResource)this.committer).getName();
            }
            throw new IllegalStateException("Cannot log transactions unles XAResources are named! " + this.committer);
        }

        public Xid getBranchXid() {
            return this.branchId;
        }
    }
}

