/*
 * Decompiled with CFR 0.152.
 */
package org.jencks;

import java.lang.reflect.Method;
import javax.jms.MessageListener;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.jencks.AcknowledgeEndpoint;
import org.jencks.LocalTransactionEndpoint;
import org.jencks.SimpleEndpoint;
import org.jencks.XAEndpoint;

public abstract class EndpointFactorySupport
implements MessageEndpointFactory {
    protected TransactionManager transactionManager;
    private String name;
    int acknowledgeMode = 0;

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public String getAcknowledgeTpe() {
        switch (this.acknowledgeMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
        }
        return "UNKNOWN";
    }

    public void setAcknowledgeType(String acknowledgeMode) {
        if ("SESSION_TRANSACTED".equals(acknowledgeMode)) {
            this.setAcknowledgeMode(0);
        } else if ("AUTO_ACKNOWLEDGE".equals(acknowledgeMode)) {
            this.setAcknowledgeMode(1);
        } else if ("DUPS_OK_ACKNOWLEDGE".equals(acknowledgeMode)) {
            this.setAcknowledgeMode(3);
        } else if ("CLIENT_ACKNOWLEDGE".equals(acknowledgeMode)) {
            this.setAcknowledgeMode(2);
        } else {
            throw new IllegalArgumentException("Value of AcknowledgeType must be set to SESSION_TRANSACTED, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE, or CLIENT_ACKNOWLEDGE");
        }
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        MessageListener messageListener = this.createMessageListener();
        if (this.acknowledgeMode == 0) {
            if (this.transactionManager != null) {
                xaResource = this.wrapXAResource(xaResource);
                return new XAEndpoint(messageListener, xaResource, this.transactionManager);
            }
            if (xaResource instanceof LocalTransaction) {
                return new LocalTransactionEndpoint(messageListener, (LocalTransaction)((Object)xaResource));
            }
            throw new UnavailableException("Endpoint configured to use transactions but resource could not support this.");
        }
        if (this.acknowledgeMode == 3) {
            return new AcknowledgeEndpoint(messageListener);
        }
        return new SimpleEndpoint(messageListener);
    }

    public String toString() {
        return super.toString() + "[transactionManager=" + this.transactionManager + "]";
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        return this.transactionManager != null;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected abstract MessageListener createMessageListener() throws UnavailableException;

    protected XAResource wrapXAResource(XAResource xaResource) {
        String name = this.getName();
        if (xaResource instanceof NamedXAResource || name == null) {
            return xaResource;
        }
        return new WrapperNamedXAResource(xaResource, name);
    }
}

