/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.factory;

import java.util.Map;
import javax.resource.spi.ConnectionManager;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ConnectionManagerFactoryBean
implements FactoryBean,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private TransactionSupport transactionSupport;
    private PoolingSupport poolingSupport;
    private boolean containerManagedSecurity;
    private TransactionContextManager transactionContextManager;
    private ConnectionTracker connectionTracker;
    private ConnectionManager connectionManager;

    public Object getObject() throws Exception {
        if (this.connectionManager == null) {
            this.connectionManager = new GenericConnectionManager(this.transactionSupport, this.poolingSupport, this.containerManagedSecurity, this.getConnectionTracker(), this.getTransactionContextManager(), this.getClass().getName(), this.getClass().getClassLoader());
        }
        return this.connectionManager;
    }

    public Class getObjectType() {
        return ConnectionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setPoolingSupport(PoolingSupport support) {
        this.poolingSupport = support;
    }

    public void setTransactionContextManager(TransactionContextManager manager) {
        this.transactionContextManager = manager;
    }

    public void setTransactionSupport(TransactionSupport support) {
        this.transactionSupport = support;
    }

    public void setConnectionTracker(ConnectionTracker tracker) {
        this.connectionTracker = tracker;
    }

    public void setContainerManagedSecurity(boolean containerManagedSecurity) {
        this.containerManagedSecurity = containerManagedSecurity;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transactionSupport == null) {
            this.transactionSupport = NoTransactions.INSTANCE;
        }
        if (this.poolingSupport == null) {
            this.poolingSupport = new NoPool();
        }
    }

    public ConnectionTracker getConnectionTracker() {
        Map map;
        if (this.connectionTracker == null && this.applicationContext != null && (map = this.applicationContext.getBeansOfType(ConnectionTracker.class)).size() == 1) {
            this.connectionTracker = (ConnectionTracker)map.values().iterator().next();
        }
        return this.connectionTracker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TransactionContextManager getTransactionContextManager() {
        if (this.transactionContextManager != null) return this.transactionContextManager;
        if (this.applicationContext == null) throw new IllegalStateException("no TransactionContextManager is set");
        Map map = this.applicationContext.getBeansOfType(TransactionContextManager.class);
        if (map.size() != 1) throw new IllegalStateException("no TransactionContextManager is registered");
        this.transactionContextManager = (TransactionContextManager)map.values().iterator().next();
        return this.transactionContextManager;
    }
}

