/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.interceptor;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.DefaultInstanceContext;
import org.apache.geronimo.transaction.InstanceContext;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;

public class TransactionContexFilter
implements Filter {
    private TrackedConnectionAssociator associator;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HashSet unshareableResources = new HashSet();
        HashSet applicationManagedSecurityResources = new HashSet();
        InstanceContext oldContext = this.enterContext(unshareableResources, applicationManagedSecurityResources);
        chain.doFilter(request, response);
        this.exitContext(oldContext);
    }

    private InstanceContext enterContext(Set unshareableResources, Set applicationManagedSecurityResources) {
        try {
            InstanceContext oldContext = this.associator.enter(new DefaultInstanceContext(unshareableResources, applicationManagedSecurityResources));
            if (this.logger.isDebugEnabled()) {
                this.logger.info((Object)"Geronimo transaction context set.");
            }
            return oldContext;
        }
        catch (ResourceException resourceException) {
            return null;
        }
    }

    private void exitContext(InstanceContext oldContext) {
        try {
            this.associator.exit(oldContext);
            if (this.logger.isDebugEnabled()) {
                this.logger.info((Object)"Geronimo transaction context unset.");
            }
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public void destroy() {
    }

    public void setAssociator(TrackedConnectionAssociator associator) {
        this.associator = associator;
    }
}

