/*
 * Decompiled with CFR 0.152.
 */
package org.jencks.pool;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import org.jencks.pool.ConnectionKey;
import org.jencks.pool.PooledSpringXAConnection;
import org.springframework.transaction.jta.JtaTransactionManager;

public class PooledSpringXAConnectionFactory
implements ConnectionFactory {
    private XAConnectionFactory connectionFactory;
    private TransactionManager transactionManager;
    private Map cache = new ConcurrentHashMap();
    private Map pooledClientIds = new ConcurrentHashMap();

    public PooledSpringXAConnectionFactory(XAConnectionFactory connectionFactory, TransactionManager transactionManager) {
        this.connectionFactory = connectionFactory;
        this.transactionManager = transactionManager;
    }

    public PooledSpringXAConnectionFactory() {
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setJtaTransactionManager(JtaTransactionManager jtaTransactionManager) {
        this.setTransactionManager(jtaTransactionManager.getTransactionManager());
    }

    public XAConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(XAConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        ConnectionKey key = new ConnectionKey(userName, password);
        PooledSpringXAConnection connection = (PooledSpringXAConnection)this.cache.get(key);
        if (connection == null) {
            XAConnection delegate = this.createConnection(key);
            connection = new PooledSpringXAConnection(this, this.getTransactionManager(), delegate);
            this.cache.put(key, connection);
        }
        return connection.newInstance();
    }

    protected XAConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return this.connectionFactory.createXAConnection();
        }
        return this.connectionFactory.createXAConnection(key.getUserName(), key.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateClientID(String requestedClientID) {
        int num;
        if (requestedClientID == null) {
            return null;
        }
        PooledSpringXAConnectionFactory pooledSpringXAConnectionFactory = this;
        synchronized (pooledSpringXAConnectionFactory) {
            Integer lastCount = (Integer)this.pooledClientIds.get(requestedClientID);
            num = lastCount == null ? 1 : lastCount + 1;
            this.pooledClientIds.put(requestedClientID, new Integer(num));
        }
        return requestedClientID + "-" + num;
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }
}

