/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class IlrArchiveLoader
extends IlrRulesetArchiveLoader {
    IlrRulesetArchive archive;
    private static int nbReadBytes = 1024;

    public IlrArchiveLoader(IlrRulesetArchive ilrRulesetArchive) {
        this.archive = ilrRulesetArchive;
    }

    public IlrRulesetArchive.Element getEntry(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IlrRulesetArchive.Element element = null;
        int[] nArray = new int[1];
        this.extractBytes(string, byteArrayOutputStream, nArray);
        if (nArray[0] != -1) {
            element = this.currentArchive.createElement(string, byteArrayOutputStream.toByteArray(), false, nArray[0]);
        }
        return element;
    }

    public IlrRulesetArchive.Element getCompressedEntry(String string) {
        IlrRulesetArchive.Element element = null;
        int[] nArray = new int[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            this.extractBytes(string, gZIPOutputStream, nArray);
        }
        catch (IOException iOException) {
            String string2 = IlrMessages.format("messages.RulesetArchive.18", string);
            throw new IlrRulesetArchive.RulesetArchiveException(iOException, string2);
        }
        if (nArray[0] != -1) {
            element = this.currentArchive.createElement(string, byteArrayOutputStream.toByteArray(), true, nArray[0]);
        }
        return element;
    }

    private void extractBytes(String string, OutputStream outputStream, int[] nArray) {
        IlrRulesetArchive.Element element = this.archive.getElement(string);
        try {
            if (element != null) {
                byte[] byArray = element.getContent();
                if (byArray != null) {
                    outputStream.write(byArray, 0, byArray.length);
                    nArray[0] = element.getUncompressedSize();
                } else {
                    nArray[0] = -1;
                }
                outputStream.close();
            } else {
                nArray[0] = -1;
            }
        }
        catch (IOException iOException) {
            String string2 = IlrMessages.format("messages.RulesetArchive.2", string);
            nArray[0] = -1;
            throw new IlrRulesetArchive.RulesetArchiveException(iOException, string2);
        }
    }

    boolean collectUserData(Map map) {
        Collection collection = this.archive.getElements();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IlrRulesetArchive.Element element = (IlrRulesetArchive.Element)iterator.next();
            String string = element.getKey();
            if (!IlrRulesetArchive.isUserData(string)) continue;
            IlrRulesetArchive.Element element2 = element.copy();
            map.put(element.getKey(), element2);
        }
        return true;
    }
}

