/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrContentManager;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class IlrFileStorage
implements IlrContentManager {
    private HashMap contents = new HashMap();
    private String directory;
    private boolean deleteRoot = false;

    public IlrFileStorage(String string) {
        this(string, false);
    }

    public IlrFileStorage(String string, boolean bl) {
        this.setDirectory(string, bl);
    }

    public IlrFileStorage() {
    }

    public void setDirectory(String string, boolean bl) {
        this.deleteRoot = bl;
        this.directory = string;
        try {
            File file = new File(this.directory);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public byte[] getContent(IlrRulesetArchive.Element element) {
        byte[] byArray;
        if (this.directory == null) {
            String string = IlrMessages.getMessage("messages.ContentManager.2");
            throw new IlrRulesetArchive.RulesetArchiveException(string);
        }
        String string = (String)this.contents.get(element);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = -1;
            byte[] byArray2 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = fileInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.close();
            fileInputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            String string2 = IlrMessages.format("messages.ContentManager.1", string);
            throw new IlrRulesetArchive.RulesetArchiveException(iOException, string2);
        }
        return byArray;
    }

    public void setContent(IlrRulesetArchive.Element element, byte[] byArray) {
        if (this.directory == null) {
            String string = IlrMessages.getMessage("messages.ContentManager.2");
            throw new IlrRulesetArchive.RulesetArchiveException(string);
        }
        String string = this.directory + '/' + element.getKey();
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        try {
            File file = new File(string2);
            file.mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (SecurityException securityException) {
            String string3 = IlrMessages.format("messages.ContentManager.0", string2);
            throw new IlrRulesetArchive.RulesetArchiveException(securityException, string3);
        }
        catch (IOException iOException) {
            String string4 = IlrMessages.format("messages.ContentManager.0", string2);
            throw new IlrRulesetArchive.RulesetArchiveException(iOException, string4);
        }
        this.contents.put(element, string);
    }

    public void reset() {
        String[] stringArray;
        Object object;
        Collection collection = this.contents.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                object = (String)iterator.next();
                stringArray = new File((String)object);
                stringArray.delete();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
        this.contents.clear();
        if (this.directory == null) {
            return;
        }
        object = new File(this.directory);
        stringArray = ((File)object).list();
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2;
                File file = new File(this.directory, stringArray[i]);
                if (!file.isDirectory() || (stringArray2 = file.list()).length != 0) continue;
                file.delete();
            }
        }
        try {
            if (this.deleteRoot) {
                ((File)object).delete();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }
}

