/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;

public class IlrJarArchiveLoader
extends IlrRulesetArchiveLoader {
    private Hashtable unreadJarEntries;
    private JarInputStream jarInputStream;
    private static int nbReadBytes = 1024;

    public IlrJarArchiveLoader(JarInputStream jarInputStream) {
        this.jarInputStream = jarInputStream;
    }

    public IlrRulesetArchive.Element getEntry(String string) {
        return this.extractBytes(string, false);
    }

    public IlrRulesetArchive.Element getCompressedEntry(String string) {
        return this.extractBytes(string, true);
    }

    public void endLoad() {
        this.jarInputStream = null;
    }

    private IlrRulesetArchive.Element findEntry(String string) {
        if (this.unreadJarEntries == null) {
            return null;
        }
        IlrRulesetArchive.Element element = (IlrRulesetArchive.Element)this.unreadJarEntries.get(string);
        if (element == null) {
            return null;
        }
        return element;
    }

    private void removeEntry(String string) {
        if (this.unreadJarEntries == null) {
            return;
        }
        this.unreadJarEntries.remove(string);
    }

    private void addEntry(ZipEntry zipEntry, boolean bl) {
        if (this.unreadJarEntries == null) {
            this.unreadJarEntries = new Hashtable();
        }
        IlrRulesetArchive.Element element = this.extractBytes(zipEntry, bl);
        this.unreadJarEntries.put(zipEntry.getName(), element);
    }

    private IlrRulesetArchive.Element extractBytes(String string, boolean bl) {
        this.checkStream();
        IlrRulesetArchive.Element element = this.findEntry(string);
        if (element != null) {
            this.removeEntry(string);
            return element;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = this.jarInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (string2.equals(string)) {
                    element = this.extractBytes(zipEntry, bl);
                    this.jarInputStream.closeEntry();
                    break;
                }
                this.addEntry(zipEntry, bl);
                this.jarInputStream.closeEntry();
            }
            return element;
        }
        catch (IOException iOException) {
            String string3 = IlrMessages.format("messages.RulesetArchive.19", string);
            throw new IlrRulesetArchive.RulesetArchiveException(iOException, string3);
        }
    }

    private IlrRulesetArchive.Element extractBytes(ZipEntry zipEntry, boolean bl) {
        Object object;
        int[] nArray = new int[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl) {
            try {
                object = new GZIPOutputStream(byteArrayOutputStream);
                this.extractBytes(zipEntry, (OutputStream)object, nArray);
            }
            catch (IOException iOException) {
                String string = IlrMessages.getMessage("messages.RulesetArchive.12");
                throw new IlrRulesetArchive.RulesetArchiveException(iOException, string);
            }
        } else {
            this.extractBytes(zipEntry, byteArrayOutputStream, nArray);
        }
        object = this.currentArchive.createElement(zipEntry.getName(), byteArrayOutputStream.toByteArray(), bl, nArray[0]);
        return object;
    }

    private void extractBytes(ZipEntry zipEntry, OutputStream outputStream, int[] nArray) {
        this.checkStream();
        try {
            nArray[0] = 0;
            int n = 0;
            byte[] byArray = new byte[nbReadBytes];
            while ((n = this.jarInputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n);
                nArray[0] = nArray[0] + n;
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            String string = IlrMessages.format("messages.RulesetArchive.19", zipEntry.getName());
            nArray[0] = -1;
            throw new IlrRulesetArchive.RulesetArchiveException(iOException, string);
        }
    }

    private String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        String string2 = string.substring(n + 1, string.length());
        return string2;
    }

    boolean collectUserData(Map map) {
        Object object;
        Object object2;
        Object object3;
        this.checkStream();
        if (this.unreadJarEntries != null) {
            object3 = this.unreadJarEntries.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (!IlrRulesetArchive.isUserData((String)object2)) continue;
                object = (IlrRulesetArchive.Element)this.unreadJarEntries.get(object2);
                map.put(object2, object);
            }
        }
        object3 = null;
        try {
            object2 = this.jarInputStream.getNextEntry();
            while (object2 != null) {
                object3 = ((ZipEntry)object2).getName();
                if (IlrRulesetArchive.isUserData((String)object3)) {
                    object = new int[1];
                    IlrRulesetArchive.Element element = this.extractBytes((ZipEntry)object2, true);
                    this.jarInputStream.closeEntry();
                    map.put(object3, element);
                    break;
                }
                this.addEntry((ZipEntry)object2, true);
                this.jarInputStream.closeEntry();
                object2 = this.jarInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            object = IlrMessages.format("messages.RulesetArchive.19", object3);
            throw new IlrRulesetArchive.RulesetArchiveException(iOException, (String)object);
        }
        return true;
    }

    private void checkStream() {
        if (this.jarInputStream == null) {
            String string = IlrMessages.getMessage("messages.RulesetArchive.20");
            throw new IlrRulesetArchive.RulesetArchiveException(string);
        }
    }
}

