/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrContentManager;
import ilog.rules.archive.IlrMemoryStorage;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IlrRulesetArchive
implements Serializable {
    private HashMap elementByNames = new HashMap();
    private transient JarOutputStream jarOutputStream;
    private boolean isBusiness = false;
    private boolean isUnknownArtifactAnError;
    private String indexName;
    private IlrContentManager contentManager = null;
    private transient IlrRulesetArchiveLoader loader;
    String encoding = "UTF-8";
    static final String xmlEncoding = "UTF-8";
    static final int nbReadBytes = 10000;
    public static final String SEPARATOR = "/";
    public static final String IRL_EXTENSION = ".irl";
    static final String META_INF = "META-INF";
    public static final String RESOURCES = "RESOURCES";
    public static final String DESCRIPTOR = "META-INF/descriptor.xml";
    public static final String VARIABLES = "variables";
    public static final String VARIABLES_IRL = "variables.irl";
    static String SETUP = "setup";
    public static final String SETUP_IRL = SETUP + ".irl";
    public static final String METADATA = "RESOURCES/metadata.xml";
    public static final String INDEX = "index.xml";
    public static final String BOM_INFO = "RESOURCES/bominfo.xml";
    public static final String ENGINE_CONF_NAME = "RESOURCES/engine.conf";
    public static final String HEADER = "RESOURCES/header.irl";
    public static final String BOMXOM = "RESOURCES/";
    public static final String USER_DATA_DIR = "USER_DATA/";
    public static final String IRL_DIR = "IRL/";
    public static final String LOOKUPTABLE_DIR = "LOOKUP_TABLE";
    public static final int IRL = 0;
    public static final int BOM = 1;
    public static final int B2X = 2;
    public static final int XOM = 3;
    public static final int ENGINE_CONF = 4;
    public static final int USER_DATA = 5;
    public static final int XSD = 6;
    public static final int WSDL = 7;
    public static final int MISC = 8;
    public static final int GENERATED = 20;
    private boolean indexExtracted = false;
    private String rulesetSignature;
    private int extractedMajorJRulesVersion;
    private int extractedMinorJRulesVersion;
    public static int localMajorJRulesVersion = 6;
    public static int localMinorJRulesVersion = 5;
    public ArrayList bomPathes;
    public HashMap bom2XomNames;
    private ArrayList bomTocs;
    private ArrayList b2xTocs;
    public ArrayList xomTocs;
    public ArrayList xsdTocs;
    private HashMap xsdDocs;
    public ArrayList wsdlTocs;
    private HashMap miscTocs;
    public HashMap irlTocs;
    private BooleanAttribute isBusinessDataXmlServiceEnable = new BooleanAttribute();

    public ClassLoader getClassLoader() {
        return IlrMessages.getMessages().getClassLoader();
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        IlrMessages.getMessages().setClassLoader(classLoader);
    }

    public boolean needExtraction() {
        return this.irlTocs == null;
    }

    public int getSize() {
        int n = 0;
        if (this.elementByNames != null) {
            Collection collection = this.elementByNames.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                n += element.getSize();
            }
        }
        return n;
    }

    public int getIndexSize() {
        Element element = this.getElement(this.indexName);
        if (element != null) {
            return element.getSize();
        }
        return 0;
    }

    public IlrRulesetArchive(String string) {
        this(new IlrMemoryStorage(), string);
    }

    public IlrRulesetArchive() {
        this(new IlrMemoryStorage(), xmlEncoding);
    }

    public IlrRulesetArchive(IlrContentManager ilrContentManager, String string) {
        this.contentManager = ilrContentManager;
        this.encoding = string;
    }

    IlrRulesetArchive(IlrContentManager ilrContentManager) {
        this(ilrContentManager, xmlEncoding);
    }

    private void setLoader(IlrRulesetArchiveLoader ilrRulesetArchiveLoader) {
        this.loader = ilrRulesetArchiveLoader;
        ilrRulesetArchiveLoader.setCurrentArchive(this);
    }

    public Collection getElements() {
        return this.elementByNames.values();
    }

    public IlrContentManager getContentManager() {
        return this.contentManager;
    }

    public void reset() {
        this.elementByNames.clear();
        this.contentManager.reset();
        this.indexExtracted = false;
        this.rulesetSignature = null;
        this.resetParsing();
        this.resetExtraction();
    }

    public void resetParsing() {
        if (this.irlTocs != null) {
            this.irlTocs.clear();
        }
        this.irlTocs = null;
        if (this.xomTocs != null) {
            this.xomTocs.clear();
        }
        this.xomTocs = null;
        if (this.xsdTocs != null) {
            this.xsdTocs.clear();
        }
        this.xsdTocs = null;
        if (this.wsdlTocs != null) {
            this.wsdlTocs.clear();
        }
        this.wsdlTocs = null;
        if (this.bomPathes != null) {
            this.bomPathes.clear();
        }
        this.bomPathes = null;
        if (this.b2xTocs != null) {
            this.b2xTocs.clear();
        }
        this.b2xTocs = null;
    }

    private void resetExtraction() {
        if (this.bomTocs != null) {
            this.bomTocs.clear();
        }
        this.bomTocs = null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getXmlEncoding() {
        return xmlEncoding;
    }

    public Collection getElements(int n) {
        Object object;
        Serializable serializable;
        if (!this.indexExtracted) {
            serializable = this.getElement(this.indexName);
            if (serializable == null) {
                return null;
            }
            object = ((Element)serializable).getContent();
            this.extractIndex((byte[])object);
            this.tagElements();
        }
        serializable = new ArrayList();
        object = this.getElements();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element.kind != n) continue;
            ((ArrayList)serializable).add(element);
        }
        return serializable;
    }

    public String getRulesetSignature() {
        if (this.rulesetSignature == null) {
            boolean bl;
            Element element = this.getElement(DESCRIPTOR);
            if (element == null) {
                return null;
            }
            String string = element.toString();
            int n = string.indexOf(62);
            String string2 = string.substring(0, n + 1);
            int n2 = string.indexOf("xmlns");
            int n3 = string.indexOf(62, n2);
            String string3 = string.substring(n2, n3);
            String string4 = IlrRulesetArchive.namespaceDescriptor("signature-declaration");
            int n4 = string.indexOf(string4) - 1;
            int n5 = n4 + string4.length() + 1;
            char c = string.charAt(n5);
            boolean bl2 = bl = c == '/';
            if (bl) {
                int n6 = n5 + 2;
                String string5 = string.substring(n4, n6);
                n3 = string5.indexOf("/>");
                String string6 = string5.substring(0, n3);
                this.rulesetSignature = string2 + "\n" + string6 + ' ' + string3 + "/>";
            } else {
                int n7 = string.lastIndexOf(string4) + string4.length() + 1;
                String string7 = string.substring(n4, n7);
                n3 = string7.indexOf(62);
                String string8 = string7.substring(0, n3);
                String string9 = string7.substring(n3 + 1, string7.length());
                this.rulesetSignature = string2 + "\n" + string8 + " " + string3 + '>' + string9;
            }
        }
        return this.rulesetSignature;
    }

    public Object getSchema(String string, String string2) {
        ArrayList arrayList;
        if (string2 != null && this.xsdDocs != null && (arrayList = (ArrayList)this.xsdDocs.get(string2)) != null) {
            SchemaDocument schemaDocument;
            if (string != null) {
                int n;
                for (n = 0; !string.equals(((SchemaDocument)arrayList.get(n)).namespace) && n < arrayList.size(); ++n) {
                }
                schemaDocument = (SchemaDocument)arrayList.get(n);
            } else {
                schemaDocument = (SchemaDocument)arrayList.get(0);
            }
            if (schemaDocument != null) {
                if (schemaDocument.location == null) {
                    String string3 = BOMXOM + schemaDocument.entryName;
                    Element element = this.getElement(string3);
                    return new ByteArrayInputStream(element.getContent());
                }
                return schemaDocument.location;
            }
        }
        return null;
    }

    public Map getSchemaNames(boolean bl) {
        if (this.xsdDocs != null) {
            HashMap hashMap = new HashMap();
            Iterator iterator = this.xsdDocs.values().iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList = (ArrayList)iterator.next();
                for (int i = 0; i < arrayList.size(); ++i) {
                    SchemaDocument schemaDocument = (SchemaDocument)arrayList.get(i);
                    if (bl && schemaDocument.location != null) continue;
                    if (hashMap.get(schemaDocument.namespace) == null) {
                        hashMap.put(schemaDocument.namespace, new ArrayList());
                    }
                    ((List)hashMap.get(schemaDocument.namespace)).add(schemaDocument.xsdName);
                }
            }
            return hashMap;
        }
        return null;
    }

    private void tagElements() {
        this.tagModelElements(this.bomTocs, RESOURCES, 1);
        this.tagModelElements(this.b2xTocs, RESOURCES, 2);
        this.tagModelElements(this.xomTocs, RESOURCES, 3);
        this.tagModelElements(this.xsdTocs, RESOURCES, 6);
        this.tagModelElements(this.wsdlTocs, RESOURCES, 7);
        this.tagIRLElements();
        this.tagMiscElements();
    }

    private void tagModelElements(ArrayList arrayList, String string, int n) {
        if (arrayList == null) {
            return;
        }
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayList.get(i);
            String string3 = string + SEPARATOR + string2;
            this.tagElement(string3, n);
        }
    }

    private void tagIRLElements() {
        if (this.irlTocs == null) {
            return;
        }
        Iterator iterator = this.irlTocs.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PackageContent packageContent = (PackageContent)this.irlTocs.get(string);
            this.tagIRLElements(packageContent);
        }
    }

    private void tagIRLElements(PackageContent packageContent) {
        if (packageContent == null) {
            return;
        }
        this.tagIRLElements(packageContent.rules);
        this.tagIRLElements(packageContent.functions);
        this.tagIRLElements(packageContent.tasks);
        this.tagIRLElements(packageContent.irls);
        this.tagElement(packageContent.variables, 0);
    }

    private void tagIRLElements(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            this.tagElement(string, 0);
        }
    }

    private void tagElement(String string, int n) {
        if (string == null) {
            return;
        }
        Element element = this.getElement(string);
        if (element != null) {
            element.setKind(n);
        }
    }

    private void tagMiscElements() {
        if (this.miscTocs == null) {
            return;
        }
        Iterator iterator = this.miscTocs.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)this.miscTocs.get(string);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                this.tagElement(string2, 8);
            }
        }
    }

    private Element extractElement(String string, int n) {
        return this.extractElement(string, n, true);
    }

    private Element extractElement(String string, int n, boolean bl) {
        Element element = this.loader.getCompressedEntry(string);
        if (element == null) {
            element = this.loader.getEntry(string);
        }
        if (element != null) {
            element.setKind(n);
            if (bl) {
                this.addElement(element);
            }
        }
        return element;
    }

    Element createElement(String string, byte[] byArray, boolean bl, int n) {
        Element element = new Element(string, -1);
        element.setContent(byArray, bl);
        element.setUncompressedSize(n);
        return element;
    }

    public void addElement(Element element) {
        int n = element.key.indexOf(INDEX);
        if (n != -1) {
            this.indexName = element.key;
        }
        this.elementByNames.put(element.key, element);
    }

    public Element getElement(String string) {
        return (Element)this.elementByNames.get(string);
    }

    public static String computeEntryName(String string) {
        String string2 = string.replace('.', SEPARATOR.charAt(0));
        string2 = string2 + IRL_EXTENSION;
        return string2;
    }

    public static String computeFQName(String string, String string2) {
        return string.length() > 0 ? string + '.' + string2 : string2;
    }

    public static String computeEntryName(String string, String string2) {
        String string3 = string;
        int n = string3.indexOf(SEPARATOR);
        if (!string.equals("")) {
            string3 = string;
            if (n == -1) {
                string3 = string3 + SEPARATOR;
            }
        }
        string3 = string3 + string2;
        return string3;
    }

    public boolean isBusiness() {
        return this.isBusiness;
    }

    void isBusiness(boolean bl) {
        this.isBusiness = bl;
    }

    public void isUnknownArtifactAnError(boolean bl) {
        this.isUnknownArtifactAnError = bl;
    }

    public boolean isUnknownArtifactAnError() {
        return this.isUnknownArtifactAnError;
    }

    private void insertInJar(Element element) throws IOException {
        String string = element.getKey();
        byte[] byArray = element.getContent();
        this.insertInJar(string, byArray);
    }

    private void insertInJar(String string, byte[] byArray) throws IOException {
        JarEntry jarEntry = new JarEntry(string);
        this.jarOutputStream.putNextEntry(jarEntry);
        this.jarOutputStream.write(byArray, 0, byArray.length);
        this.jarOutputStream.closeEntry();
    }

    public void write(JarOutputStream jarOutputStream) throws IOException {
        this.jarOutputStream = jarOutputStream;
        Collection collection = this.getElements();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.insertInJar(element);
        }
        this.jarOutputStream = null;
    }

    public boolean compare(IlrRulesetArchive ilrRulesetArchive) {
        Collection collection = this.getElements();
        Collection collection2 = ilrRulesetArchive.getElements();
        if (collection.size() != collection2.size()) {
            return false;
        }
        if (this.isBusiness != ilrRulesetArchive.isBusiness) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element;
            Element element2 = (Element)iterator.next();
            boolean bl = element2.compare(element = ilrRulesetArchive.getElement(element2.key));
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static String getObjectModelName(String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(SEPARATOR);
        return string.substring(n2 + 1, n);
    }

    public static String getBom2XomFromBom(String string, Map map) {
        String string2 = IlrRulesetArchive.getObjectModelName(string);
        return (String)map.get(string2);
    }

    public Element getBom2XomElement(String string) {
        if (this.b2xTocs == null) {
            return null;
        }
        String string2 = BOMXOM + IlrRulesetArchive.getBom2XomFromBom(string, this.bom2XomNames);
        if (string2 == null) {
            return null;
        }
        return this.getElement(string2);
    }

    public static org.w3c.dom.Element readXmlDocument(final String string, final String string2) {
        return (org.w3c.dom.Element)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return IlrRulesetArchive.readXmlDocumentInternal(string, string2);
            }
        });
    }

    private static org.w3c.dom.Element readXmlDocumentInternal(String string, String string2) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(xmlEncoding));
            Document document = documentBuilder.parse(byteArrayInputStream);
            byteArrayInputStream.close();
            return document.getDocumentElement();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string3 = IlrMessages.format("messages.RulesetArchive.1", string2, string);
            throw new RulesetArchiveException(parserConfigurationException, string3);
        }
        catch (SAXException sAXException) {
            String string4 = IlrMessages.format("messages.RulesetArchive.1", string2, string);
            throw new RulesetArchiveException(sAXException, string4);
        }
        catch (IOException iOException) {
            String string5 = IlrMessages.format("messages.RulesetArchive.1", string2, string);
            throw new RulesetArchiveException(iOException, string5);
        }
    }

    public static String convertIntoString(byte[] byArray, String string) {
        try {
            String string2 = new String(byArray, string);
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = IlrMessages.getMessage("messages.RulesetArchive.4");
            throw new RulesetArchiveException(unsupportedEncodingException, string3);
        }
    }

    static void alreadyInsertedError(String string) {
        String string2 = IlrMessages.format("messages.RulesetArchive.3", string);
        throw new RulesetArchiveException(string2);
    }

    static void entryNameNotValid(String string) {
        String string2 = IlrMessages.format("messages.RulesetArchive.21", string);
        throw new RulesetArchiveException(string2);
    }

    public static IlrRulesetArchive extractArchive(IlrRulesetArchiveLoader ilrRulesetArchiveLoader) {
        return IlrRulesetArchive.extractArchive(ilrRulesetArchiveLoader, new IlrMemoryStorage());
    }

    public static IlrRulesetArchive extractArchive(IlrRulesetArchiveLoader ilrRulesetArchiveLoader, IlrContentManager ilrContentManager) {
        IlrRulesetArchive ilrRulesetArchive = new IlrRulesetArchive(ilrContentManager);
        ilrRulesetArchive.setLoader(ilrRulesetArchiveLoader);
        ilrRulesetArchive.extractArchive();
        return ilrRulesetArchive;
    }

    private void extractArchive() {
        this.extractDescriptor();
        this.extractBomInfo();
        this.extractContent(ENGINE_CONF_NAME, 4, false);
        this.extractContent(HEADER, 0, false);
        this.extractIndex();
        this.extractModelElements(this.bomTocs, 1);
        this.extractModelElements(this.xomTocs, 3);
        this.extractModelElements(this.xsdTocs, 6);
        this.extractModelElements(this.wsdlTocs, 7);
        this.extractModelElements(this.b2xTocs, 2);
        this.extractContent(METADATA, 20, true);
        this.extractArtifacts();
        this.extractMiscElements();
        this.extractUserData();
        this.loader.endLoad();
        this.resetExtraction();
    }

    public String getIRL(String string, String string2) {
        String string3;
        Element element;
        if (string2.endsWith(IRL_EXTENSION)) {
            string2 = string2.substring(0, string2.lastIndexOf(IRL_EXTENSION));
        }
        String string4 = IlrRulesetArchive.computeFQName(string, string2);
        String string5 = IlrRulesetArchive.computeEntryName(string4);
        String string6 = "";
        if (this.isExtractedVersionAtLeast(6, 5)) {
            string6 = IRL_DIR;
        }
        if ((element = this.getElement(string6 + string5)) == null) {
            return null;
        }
        byte[] byArray = element.getContent();
        try {
            string3 = new String(byArray, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string7 = IlrMessages.getMessage("messages.RulesetArchive.4");
            throw new RulesetArchiveException(unsupportedEncodingException, string7);
        }
        return string3;
    }

    public String getContent(String string) {
        Element element = this.getElement(string);
        if (element == null) {
            return null;
        }
        return element.toString();
    }

    public static void throwExtractionError(String string) {
        String string2 = IlrMessages.format("messages.RulesetArchive.5", string);
        throw new RulesetArchiveException(string2);
    }

    public static void throwXmlParsingError(String string) {
        String string2 = IlrMessages.getMessage("messages.RulesetArchive.16");
        throw new RulesetArchiveException(string2 + ": " + string);
    }

    public static void checkXmlExtractionError(org.w3c.dom.Element element, String string) {
        if (element == null) {
            IlrRulesetArchive.throwXmlParsingError(IlrMessages.format("messages.RulesetArchive.14", string));
        }
    }

    public static void checkXmlExtractionError(Attr attr, String string) {
        if (attr == null) {
            IlrRulesetArchive.throwXmlParsingError(IlrMessages.format("messages.RulesetArchive.15", string));
        }
    }

    private void extractDescriptor() {
        Element element = this.extractElement(DESCRIPTOR, 20);
        this.interpretDescriptor(element);
    }

    private void interpretDescriptor(Element element) {
        if (element == null) {
            element = this.getElement(DESCRIPTOR);
        }
        if (element != null) {
            byte[] byArray = element.getContent();
            if (byArray == null) {
                IlrRulesetArchive.throwExtractionError(DESCRIPTOR);
            }
            String string = IlrRulesetArchive.convertIntoString(byArray, xmlEncoding);
            this.decomposeDescriptor(string);
        } else {
            IlrRulesetArchive.throwExtractionError(DESCRIPTOR);
        }
    }

    private void decomposeDescriptor(String string) {
        org.w3c.dom.Element element = IlrRulesetArchive.readXmlDocument(string, "descriptor");
        this.extractSignature(element);
        this.extractBusinessState(element);
        this.extractBusinessXMLService(element);
        this.extractUnknownArtifact(element);
        this.extractArchiveEncoding(element);
        this.extractJRulesVersion(element);
        this.extractRulesetVersion(element);
    }

    public static org.w3c.dom.Element getElementChild(org.w3c.dom.Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            return (org.w3c.dom.Element)node;
        }
        return null;
    }

    private static String namespace(String string, String string2) {
        return string + ":" + string2;
    }

    public static String namespaceMetadata(String string) {
        return IlrRulesetArchive.namespace("metadata", string);
    }

    public static String namespaceSignature(String string) {
        return IlrRulesetArchive.namespace("sig", string);
    }

    public static String namespaceDescriptor(String string) {
        return IlrRulesetArchive.namespace("desc", string);
    }

    public static String namespaceIndex(String string) {
        return IlrRulesetArchive.namespace("index", string);
    }

    public static String namespaceBom(String string) {
        return IlrRulesetArchive.namespace("bom", string);
    }

    private void extractSignature(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceDescriptor("signature-declaration"));
        IlrRulesetArchive.checkXmlExtractionError(element2, "signature-declaration");
    }

    private void extractBusinessState(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceDescriptor("isbusiness"));
        IlrRulesetArchive.checkXmlExtractionError(element2, "isbusiness");
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            String string = node.getNodeValue();
            Boolean bl = Boolean.valueOf(string);
            boolean bl2 = bl;
            this.isBusiness(bl2);
            break;
        }
    }

    private void extractBusinessXMLService(org.w3c.dom.Element element) {
        Node node;
        NodeList nodeList;
        int n;
        int n2;
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceDescriptor("businessxmlserviceenable"));
        if (element2 != null && (n2 = 0) < (n = (nodeList = element2.getChildNodes()).getLength()) && (node = nodeList.item(n2)).getNodeType() == 3) {
            String string = node.getNodeValue();
            Boolean bl = Boolean.valueOf(string);
            if (!this.isBusinessDataXmlServiceEnable.setByApi) {
                this.isBusinessDataXmlServiceEnable.value = bl;
            }
            if (this.isBusinessDataXmlServiceEnable.value && !this.isBusiness()) {
                throw new RulesetArchiveException(IlrMessages.getMessage("messages.RulesetArchive.22"));
            }
        }
    }

    private void extractUnknownArtifact(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceDescriptor("error-for-unknown-artifact"));
        if (element2 == null) {
            return;
        }
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            String string = node.getNodeValue();
            Boolean bl = Boolean.valueOf(string);
            boolean bl2 = bl;
            this.isUnknownArtifactAnError(bl2);
            break;
        }
    }

    private void extractArchiveEncoding(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceDescriptor("encoding"));
        IlrRulesetArchive.checkXmlExtractionError(element2, "encoding");
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            this.encoding = node.getNodeValue();
            break;
        }
    }

    private void extractJRulesVersion(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceDescriptor("jrules-version"));
        if (element2 == null) {
            return;
        }
        String string = "major";
        String string2 = "minor";
        Attr attr = element2.getAttributeNode(string);
        IlrRulesetArchive.checkXmlExtractionError(attr, string);
        this.extractedMajorJRulesVersion = Integer.parseInt(attr.getValue());
        Attr attr2 = element2.getAttributeNode(string2);
        IlrRulesetArchive.checkXmlExtractionError(attr2, string2);
        this.extractedMinorJRulesVersion = Integer.parseInt(attr2.getValue());
    }

    private void extractRulesetVersion(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceDescriptor("version"));
        IlrRulesetArchive.checkXmlExtractionError(element2, "version");
        String string = "major";
        String string2 = "minor";
        Attr attr = element2.getAttributeNode(string);
        IlrRulesetArchive.checkXmlExtractionError(attr, string);
        Attr attr2 = element2.getAttributeNode(string2);
        IlrRulesetArchive.checkXmlExtractionError(attr2, string2);
    }

    private void extractBomInfo() {
        Element element = this.extractElement(BOM_INFO, 20);
        this.interpretBomInfo(element);
    }

    private void interpretBomInfo(Element element) {
        Element element2 = element;
        if (element2 == null) {
            element2 = this.getElement(BOM_INFO);
        }
        if (element2 != null) {
            this.decomposeBomInfo(element2.toString());
        } else {
            IlrRulesetArchive.throwExtractionError(BOM_INFO);
        }
    }

    private void decomposeBomInfo(String string) {
        org.w3c.dom.Element element = IlrRulesetArchive.readXmlDocument(string, "bom");
        this.extractBomPathes(element);
    }

    private void extractBomPathes(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceBom("bompathes"));
        if (element2 == null) {
            return;
        }
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            org.w3c.dom.Element element3 = (org.w3c.dom.Element)node;
            this.extractBomPath(element3);
        }
    }

    private void extractBomPath(org.w3c.dom.Element element) {
        Attr attr = element.getAttributeNode("value");
        IlrRulesetArchive.checkXmlExtractionError(attr, "value");
        String string = attr.getValue();
        if (this.bomPathes == null) {
            this.bomPathes = new ArrayList();
        }
        this.bomPathes.add(string);
    }

    private void extractContent(String string, int n, boolean bl) {
        Element element = this.extractElement(string, n);
        if (bl && element == null) {
            IlrRulesetArchive.throwExtractionError(string);
        }
    }

    private void extractIndex() {
        String string = this.isExtractedVersionAtLeast(6, 5) ? META_INF : RESOURCES;
        String string2 = string + SEPARATOR + INDEX;
        Element element = this.extractElement(string2, 20);
        this.interpretIndex(element);
    }

    private void interpretIndex(Element element) {
        if (this.irlTocs != null) {
            return;
        }
        Element element2 = element;
        if (element2 == null) {
            String string = this.isExtractedVersionAtLeast(6, 5) ? META_INF : RESOURCES;
            String string2 = string + SEPARATOR + INDEX;
            element2 = this.getElement(string2);
        }
        if (element2 != null) {
            this.extractIndex(element2.getContent());
        } else {
            IlrRulesetArchive.throwExtractionError(INDEX);
        }
    }

    public void interpret() {
        this.interpretDescriptor(null);
        this.interpretIndex(null);
        this.interpretBomInfo(null);
        this.tagElements();
    }

    private void extractIndex(byte[] byArray) {
        String string = IlrRulesetArchive.convertIntoString(byArray, xmlEncoding);
        this.decomposeIndex(string);
        this.indexExtracted = true;
    }

    private void decomposeIndex(String string) {
        org.w3c.dom.Element element = IlrRulesetArchive.readXmlDocument(string, "index");
        this.extractToc(element);
    }

    private void extractToc(org.w3c.dom.Element element) {
        org.w3c.dom.Element element2 = IlrRulesetArchive.getElementChild(element, IlrRulesetArchive.namespaceIndex("toc"));
        IlrRulesetArchive.checkXmlExtractionError(element2, "toc");
        org.w3c.dom.Element element3 = IlrRulesetArchive.getElementChild(element2, IlrRulesetArchive.namespaceIndex("bomToc"));
        IlrRulesetArchive.checkXmlExtractionError(element3, "bomToc");
        this.bomTocs = this.extractTocContent(element3);
        org.w3c.dom.Element element4 = IlrRulesetArchive.getElementChild(element2, IlrRulesetArchive.namespaceIndex("bom2xomToc"));
        IlrRulesetArchive.checkXmlExtractionError(element4, "bom2xomToc");
        this.b2xTocs = this.extractTocContent(element4);
        this.organizeB2X();
        org.w3c.dom.Element element5 = IlrRulesetArchive.getElementChild(element2, IlrRulesetArchive.namespaceIndex("xomToc"));
        IlrRulesetArchive.checkXmlExtractionError(element5, "xomToc");
        this.xomTocs = this.extractTocContent(element5);
        org.w3c.dom.Element element6 = IlrRulesetArchive.getElementChild(element2, IlrRulesetArchive.namespaceIndex("irlToc"));
        IlrRulesetArchive.checkXmlExtractionError(element6, "irlToc");
        this.extractIRLContent(element6);
        if (this.isExtractedVersionAtLeast(6, 5)) {
            org.w3c.dom.Element element7 = IlrRulesetArchive.getElementChild(element2, IlrRulesetArchive.namespaceIndex("xsdToc"));
            IlrRulesetArchive.checkXmlExtractionError(element7, "xsdToc");
            this.extractXSDTocContent(element7);
            org.w3c.dom.Element element8 = IlrRulesetArchive.getElementChild(element2, IlrRulesetArchive.namespaceIndex("wsdlToc"));
            IlrRulesetArchive.checkXmlExtractionError(element8, "wsdlToc");
            this.wsdlTocs = this.extractTocContent(element8);
            org.w3c.dom.Element element9 = IlrRulesetArchive.getElementChild(element2, IlrRulesetArchive.namespaceIndex("miscElementsToc"));
            IlrRulesetArchive.checkXmlExtractionError(element9, "miscElementsToc");
            this.extractMiscTocContent(element9);
        }
    }

    private void extractIRLContent(org.w3c.dom.Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            org.w3c.dom.Element element2 = (org.w3c.dom.Element)node;
            String string = element2.getAttribute("name");
            PackageContent packageContent = this.extractPackageContent(element2);
            if (packageContent == null) continue;
            if (this.irlTocs == null) {
                this.irlTocs = new HashMap();
            }
            this.irlTocs.put(string, packageContent);
        }
    }

    private PackageContent extractPackageContent(org.w3c.dom.Element element) {
        PackageContent packageContent = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            org.w3c.dom.Element element2 = (org.w3c.dom.Element)node;
            if (packageContent == null) {
                packageContent = new PackageContent();
            }
            String string = element2.getTagName();
            ArrayList arrayList = this.extractTocContent(element2);
            if (arrayList == null) continue;
            if (string.equals(IlrRulesetArchive.namespaceIndex("rules"))) {
                packageContent.setRules(arrayList);
                continue;
            }
            if (string.equals(IlrRulesetArchive.namespaceIndex("functions"))) {
                packageContent.setFunctions(arrayList);
                continue;
            }
            if (string.equals(IlrRulesetArchive.namespaceIndex("tasks"))) {
                packageContent.setTasks(arrayList);
                continue;
            }
            if (string.equals(IlrRulesetArchive.namespaceIndex("irls"))) {
                packageContent.setIrls(arrayList);
                continue;
            }
            if (!string.equals(IlrRulesetArchive.namespaceIndex(VARIABLES))) continue;
            String string2 = (String)arrayList.get(0);
            packageContent.setVariables(string2);
        }
        return packageContent;
    }

    private ArrayList extractTocContent(org.w3c.dom.Element element) {
        ArrayList<String> arrayList = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            org.w3c.dom.Element element2 = (org.w3c.dom.Element)node;
            String string = element2.getAttribute("name");
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private void extractXSDTocContent(org.w3c.dom.Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            org.w3c.dom.Element element2 = (org.w3c.dom.Element)node;
            SchemaDocument schemaDocument = new SchemaDocument();
            schemaDocument.entryName = element2.getAttribute("name");
            schemaDocument.namespace = element2.getAttribute("schemaNamespace");
            schemaDocument.xsdName = element2.getAttribute("xsdName");
            String string = element2.getAttribute("URL");
            if (string != null && string.length() > 0) {
                try {
                    schemaDocument.location = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
            }
            if (this.xsdTocs == null) {
                this.xsdTocs = new ArrayList();
            }
            if (schemaDocument.location == null) {
                this.xsdTocs.add(schemaDocument.entryName);
            }
            if (this.xsdDocs == null) {
                this.xsdDocs = new HashMap();
            }
            if (this.xsdDocs.get(schemaDocument.xsdName) == null) {
                this.xsdDocs.put(schemaDocument.xsdName, new ArrayList());
            }
            ((ArrayList)this.xsdDocs.get(schemaDocument.xsdName)).add(schemaDocument);
        }
    }

    private void organizeB2X() {
        if (this.b2xTocs == null) {
            return;
        }
        this.bom2XomNames = new HashMap();
        int n = this.b2xTocs.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.b2xTocs.get(i);
            String string2 = IlrRulesetArchive.getObjectModelName(string);
            this.bom2XomNames.put(string2, string);
        }
    }

    private void extractMiscTocContent(org.w3c.dom.Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            org.w3c.dom.Element element2 = (org.w3c.dom.Element)node;
            String string = element2.getAttribute("type");
            ArrayList arrayList = this.extractTocContent(element2);
            if (this.miscTocs == null) {
                this.miscTocs = new HashMap();
            }
            this.miscTocs.put(string, arrayList);
        }
    }

    private void extractModelElements(ArrayList arrayList, int n) {
        if (arrayList == null) {
            return;
        }
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string = (String)arrayList.get(i);
            String string2 = BOMXOM + string;
            Element element = this.extractElement(string2, n);
            if (element != null) continue;
            IlrRulesetArchive.throwExtractionError(string2);
        }
    }

    private void extractMiscElements() {
        if (this.miscTocs == null) {
            return;
        }
        Iterator iterator = this.miscTocs.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)this.miscTocs.get(string);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                Element element = this.extractElement(string2, 8);
                if (element != null) continue;
                IlrRulesetArchive.throwExtractionError(string2);
            }
        }
    }

    static boolean isUserData(String string) {
        int n = string.indexOf(SEPARATOR);
        String string2 = n == -1 ? "" : string.substring(0, n);
        int n2 = string.lastIndexOf(46);
        String string3 = "";
        if (n2 != -1) {
            string3 = string.substring(n2, string.length());
        }
        int n3 = string.lastIndexOf(SEPARATOR);
        return !string2.equals(RESOURCES) && !string2.equals(META_INF) && !string3.equals(IRL_EXTENSION) && n3 != string.length() - 1;
    }

    private void extractUserData() {
        HashMap hashMap = new HashMap();
        this.loader.collectUserData(hashMap);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Element element = (Element)hashMap.get(string);
            element.setKind(5);
            this.addElement(element);
        }
    }

    private void extractArtifacts() {
        if (this.irlTocs != null) {
            Iterator iterator = this.irlTocs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                PackageContent packageContent = (PackageContent)this.irlTocs.get(string);
                this.extractPackageContent(packageContent);
            }
        }
    }

    private void extractPackageContent(PackageContent packageContent) {
        this.extractPackageContent(packageContent.rules);
        this.extractPackageContent(packageContent.functions);
        this.extractPackageContent(packageContent.tasks);
        this.extractPackageContent(packageContent.irls);
        this.extractPackageContent(packageContent.variables);
    }

    private void extractPackageContent(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            this.extractPackageContent(string);
        }
    }

    private void extractPackageContent(String string) {
        if (string == null) {
            return;
        }
        Element element = this.extractElement(string, 0);
        if (element == null) {
            IlrRulesetArchive.throwExtractionError(string);
        }
    }

    boolean isExtractedVersionAtLeast(int n, int n2) {
        return this.extractedMajorJRulesVersion >= n && this.extractedMinorJRulesVersion >= n2;
    }

    static boolean isCurrentVersionAtLeast(int n, int n2) {
        return localMajorJRulesVersion >= n && localMinorJRulesVersion >= n2;
    }

    public boolean isBusinessDataXmlServiceEnable() {
        return this.isBusinessDataXmlServiceEnable.value;
    }

    public void setBusinessDataXmlServiceEnable(boolean bl) {
        this.isBusinessDataXmlServiceEnable.value = bl;
        this.isBusinessDataXmlServiceEnable.setByApi = true;
        this.irlTocs = null;
    }

    public static class ErrorChecker
    implements ErrorHandler {
        private void display(SAXParseException sAXParseException, String string) {
            System.out.println(string + sAXParseException.getMessage() + " in " + sAXParseException.getSystemId() + " at line " + sAXParseException.getLineNumber() + " at column " + sAXParseException.getColumnNumber());
        }

        public void error(SAXParseException sAXParseException) {
            this.display(sAXParseException, "Parsing error:  ");
        }

        public void warning(SAXParseException sAXParseException) {
            this.display(sAXParseException, "Parsing warning:  ");
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.display(sAXParseException, "Parsing error:  ");
            System.out.println("Cannot continue.");
        }
    }

    public static class PackageContent
    implements Serializable {
        public ArrayList rules = new ArrayList();
        public ArrayList functions = new ArrayList();
        public ArrayList tasks = new ArrayList();
        public ArrayList irls = new ArrayList();
        public String variables;
        public int nbArtifacts;

        PackageContent() {
        }

        void addRule(String string) {
            if (this.rules.indexOf(string) != -1) {
                IlrRulesetArchive.alreadyInsertedError(string);
            }
            this.rules.add(string);
            ++this.nbArtifacts;
        }

        void setRules(ArrayList arrayList) {
            this.rules = arrayList;
            if (arrayList != null) {
                this.nbArtifacts += arrayList.size();
            }
        }

        void addFunction(String string) {
            if (this.functions.indexOf(string) != -1) {
                IlrRulesetArchive.alreadyInsertedError(string);
            }
            this.functions.add(string);
            ++this.nbArtifacts;
        }

        void setFunctions(ArrayList arrayList) {
            this.functions = arrayList;
            if (arrayList != null) {
                this.nbArtifacts += arrayList.size();
            }
        }

        void addTask(String string) {
            if (this.tasks.indexOf(string) != -1) {
                IlrRulesetArchive.alreadyInsertedError(string);
            }
            this.tasks.add(string);
            ++this.nbArtifacts;
        }

        void setTasks(ArrayList arrayList) {
            this.tasks = arrayList;
            if (arrayList != null) {
                this.nbArtifacts += arrayList.size();
            }
        }

        void setVariables(String string) {
            if (this.variables != null) {
                IlrRulesetArchive.alreadyInsertedError(string);
            }
            this.variables = string;
            ++this.nbArtifacts;
        }

        void addIrls(String string) {
            if (this.irls.indexOf(string) != -1) {
                IlrRulesetArchive.alreadyInsertedError(string);
            }
            this.irls.add(string);
            ++this.nbArtifacts;
        }

        void setIrls(ArrayList arrayList) {
            this.irls = arrayList;
            if (arrayList != null) {
                this.nbArtifacts += arrayList.size();
            }
        }
    }

    private static class BooleanAttribute
    implements Serializable {
        private boolean setByApi;
        private boolean value;

        private BooleanAttribute() {
        }
    }

    private static class SchemaDocument {
        private String xsdName;
        private String namespace;
        private String entryName;
        private URL location;

        private SchemaDocument() {
        }
    }

    public class Element
    implements Serializable {
        private String key;
        private int kind;
        private boolean compressed = false;
        private int uncompressedSize = 0;

        public Element(String string) {
            this.key = string;
            this.kind = -1;
            this.tagElement();
        }

        Element(String string, int n) {
            this.key = string;
            this.kind = n;
        }

        private void tagElement() {
            if (this.key.equals(IlrRulesetArchive.DESCRIPTOR) || this.key.equals(IlrRulesetArchive.INDEX) || this.key.equals(IlrRulesetArchive.BOM_INFO) || this.key.equals(IlrRulesetArchive.METADATA)) {
                this.kind = 20;
            } else if (this.key.equals(IlrRulesetArchive.ENGINE_CONF_NAME)) {
                this.kind = 4;
            } else if (this.key.equals(IlrRulesetArchive.HEADER)) {
                this.kind = 0;
            }
        }

        public String getKey() {
            return this.key;
        }

        public void setUncompressedSize(int n) {
            this.uncompressedSize = n;
        }

        public void setContent(byte[] byArray) {
            this.setContent(byArray, false);
            this.uncompressedSize = byArray.length;
        }

        public void setContent(byte[] byArray, boolean bl) {
            this.compressed = bl;
            IlrRulesetArchive.this.contentManager.setContent(this, byArray);
        }

        public void compressAndSetContent(byte[] byArray) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                gZIPOutputStream.write(byArray, 0, byArray.length);
                gZIPOutputStream.close();
                byteArrayOutputStream.close();
                this.uncompressedSize = byArray.length;
                this.setContent(byteArrayOutputStream.toByteArray(), true);
            }
            catch (IOException iOException) {
                String string = IlrMessages.getMessage("messages.RulesetArchive.12");
                throw new RulesetArchiveException(iOException, string);
            }
        }

        public byte[] getContent() {
            byte[] byArray = IlrRulesetArchive.this.contentManager.getContent(this);
            if (byArray == null) {
                return null;
            }
            if (!this.compressed) {
                return byArray;
            }
            return this.uncompress(byArray);
        }

        private byte[] uncompress(byte[] byArray) {
            byte[] byArray2 = new byte[this.uncompressedSize];
            try {
                int n;
                int n2;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                int n3 = 0;
                while ((n3 += gZIPInputStream.read(byArray2, n3, n2 = (n = Math.min(byArray2.length, 10000 + n3)) - n3)) < byArray2.length) {
                }
                gZIPInputStream.close();
            }
            catch (IOException iOException) {
                String string = IlrMessages.format("messages.RulesetArchive.17", this.key);
                throw new RulesetArchiveException(iOException, string);
            }
            return byArray2;
        }

        public int getKind() {
            return this.kind;
        }

        public void setKind(int n) {
            this.kind = n;
        }

        public String toString() {
            String string;
            String string2 = this.kind == 20 ? IlrRulesetArchive.xmlEncoding : IlrRulesetArchive.this.getEncoding();
            try {
                string = this.kind == 5 ? "[IlrRulesetArchive.Element " + this.key + "]" : new String(this.getContent(), string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = IlrMessages.getMessage("messages.RulesetArchive.4");
                throw new RulesetArchiveException(unsupportedEncodingException, string3);
            }
            return string;
        }

        public int getSize() {
            byte[] byArray = IlrRulesetArchive.this.contentManager.getContent(this);
            if (byArray != null) {
                return byArray.length;
            }
            return 0;
        }

        int getUncompressedSize() {
            return this.uncompressedSize;
        }

        boolean compare(Element element) {
            if (element == null) {
                return false;
            }
            String string = IlrRulesetArchive.convertIntoString(this.getContent(), IlrRulesetArchive.this.encoding);
            String string2 = IlrRulesetArchive.convertIntoString(element.getContent(), IlrRulesetArchive.this.encoding);
            if (string.hashCode() != string2.hashCode()) {
                return false;
            }
            return string.equals(string2);
        }

        public Element copy() {
            Element element = new Element(this.key);
            element.uncompressedSize = this.uncompressedSize;
            byte[] byArray = this.getContent();
            if (this.compressed) {
                element.compressAndSetContent(byArray);
            } else {
                element.setContent(byArray);
            }
            element.kind = this.kind;
            return element;
        }
    }

    public static class RulesetArchiveException
    extends RuntimeException {
        private Throwable target;
        private String precision;

        public RulesetArchiveException(Throwable throwable, String string) {
            super(throwable.getMessage());
            this.target = throwable;
            this.precision = string;
        }

        public RulesetArchiveException(String string) {
            this.precision = string;
        }

        public String getMessage() {
            String string = this.precision;
            if (this.target != null) {
                if (string.length() != 0) {
                    string = string + ":\n";
                }
                string = string + this.target.getMessage();
            }
            return string;
        }

        public void printHeader(PrintWriter printWriter) {
            String string = IlrMessages.format("messages.Misc.12", this.getShortName(this.getClass()));
            printWriter.println('\n' + string + ". " + this.precision + ':');
        }

        public void printStackTrace(PrintWriter printWriter) {
            this.printHeader(printWriter);
            if (this.target != null) {
                printWriter.println("Target exception stack trace:");
                this.target.printStackTrace(printWriter);
            } else {
                super.printStackTrace(printWriter);
            }
        }

        String getShortName(Class clazz) {
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            return string.substring(n + 1);
        }
    }
}

