/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrContentManager;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.util.engine.IlrXmlRulesetArchiveTag;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class IlrRulesetArchiveBuilderBase {
    protected ArrayList artifacts = new ArrayList();
    protected ArrayList artifactNames = new ArrayList();
    protected HashMap irlTocs;
    protected ArrayList bomPathes;
    protected HashMap bom2XomNames;
    protected HashMap miscTocs;
    protected String xsdMetadataFileName;
    protected String xsdIndexFileName;
    protected String xsdDescriptorFileName;
    protected String xsdBomInfoFileName;
    protected ArrayList bomTocs;
    protected ArrayList b2xTocs;
    protected ArrayList xomTocs;
    protected ArrayList xsdTocs;
    protected ArrayList wsdlTocs;
    protected ArrayList userDataTocs;
    private int majorNbVersion;
    private int minorNbVersion;
    private PrintWriter messageWriter;
    private boolean isUnknownArtifactAnError;
    protected ArrayList archiveBuildingErrors = new ArrayList();
    protected IlrRulesetArchive currentArchive;
    protected String encoding = "UTF-8";
    protected static final int RULE = 0;
    protected static final int FUNCTION = 1;
    protected static final int TASK = 2;
    protected static final int VARIABLE = 3;
    protected static final int MISC = 4;
    private int nbXsdNameIndex = 0;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected TransformerFactory transformerFactory;

    public IlrRulesetArchiveBuilderBase() {
        this.currentArchive = new IlrRulesetArchive();
    }

    public IlrRulesetArchiveBuilderBase(IlrContentManager ilrContentManager) {
        this.currentArchive = new IlrRulesetArchive(ilrContentManager);
    }

    public ClassLoader getClassLoader() {
        return IlrMessages.getMessages().getClassLoader();
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        IlrMessages.getMessages().setClassLoader(classLoader);
    }

    public void setEncoding(String string) {
        this.currentArchive.encoding = string;
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void reset() {
        this.artifacts.clear();
        this.artifactNames.clear();
        if (this.irlTocs != null) {
            this.irlTocs.clear();
        }
        if (this.bomTocs != null) {
            this.bomTocs.clear();
        }
        if (this.b2xTocs != null) {
            this.b2xTocs.clear();
        }
        if (this.xomTocs != null) {
            this.xomTocs.clear();
        }
        if (this.miscTocs != null) {
            this.miscTocs.clear();
        }
        if (this.xsdTocs != null) {
            this.xsdTocs.clear();
        }
        if (this.wsdlTocs != null) {
            this.wsdlTocs.clear();
        }
        if (this.userDataTocs != null) {
            this.userDataTocs.clear();
        }
        if (this.bom2XomNames != null) {
            this.bom2XomNames.clear();
        }
        if (this.bomPathes != null) {
            this.bomPathes.clear();
        }
        this.archiveBuildingErrors.clear();
    }

    public void setMessageWriter(PrintWriter printWriter) {
        this.messageWriter = printWriter;
    }

    public void isUnknownArtifactAnError(boolean bl) {
        this.isUnknownArtifactAnError = bl;
    }

    public void addIRLEntry(String string, InputStream inputStream) {
        try {
            if (inputStream == null) {
                return;
            }
            if (string.endsWith(".irl")) {
                string = string.substring(0, string.lastIndexOf(".irl"));
            }
            this.storeArtifact("", string, this.getContentInByteArray(inputStream, string), 4);
            inputStream.close();
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string);
        }
    }

    public void addRuleEntry(String string, String string2, String string3) {
        byte[] byArray = this.convertIntoBytes(string3);
        this.addRuleEntry(string, string2, byArray);
    }

    public void addRuleEntry(String string, String string2, InputStream inputStream) {
        String string3 = IlrRulesetArchive.computeFQName(string, string2);
        String string4 = IlrRulesetArchive.computeEntryName(string3);
        try {
            if (inputStream == null) {
                return;
            }
            this.addRuleEntry(string, string2, this.getContentInByteArray(inputStream, string4));
            inputStream.close();
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string4);
        }
    }

    private void addRuleEntry(String string, String string2, byte[] byArray) {
        String string3 = IlrRulesetArchive.computeFQName(string, string2);
        this.storeArtifact(string, string3, byArray, 0);
    }

    public void addFunctionEntry(String string, String string2, String string3) {
        byte[] byArray = this.convertIntoBytes(string3);
        this.addFunctionEntry(string, string2, byArray);
    }

    public void addFunctionEntry(String string, String string2, InputStream inputStream) {
        String string3 = IlrRulesetArchive.computeFQName(string, string2);
        String string4 = IlrRulesetArchive.computeEntryName(string3);
        try {
            if (inputStream == null) {
                return;
            }
            this.addFunctionEntry(string, string2, this.getContentInByteArray(inputStream, string4));
            inputStream.close();
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string4);
        }
    }

    private void addFunctionEntry(String string, String string2, byte[] byArray) {
        String string3 = IlrRulesetArchive.computeFQName(string, string2);
        this.storeArtifact(string, string3, byArray, 1);
    }

    public void addRuleflowEntry(String string, String string2, String string3) {
        byte[] byArray = this.convertIntoBytes(string3);
        this.addRuleflowEntry(string, string2, byArray);
    }

    public void addRuleflowEntry(String string, String string2, InputStream inputStream) {
        String string3 = IlrRulesetArchive.computeFQName(string, string2);
        String string4 = IlrRulesetArchive.computeEntryName(string3);
        try {
            if (inputStream == null) {
                return;
            }
            this.addRuleflowEntry(string, string2, this.getContentInByteArray(inputStream, string4));
            inputStream.close();
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string4);
        }
    }

    private void addRuleflowEntry(String string, String string2, byte[] byArray) {
        String string3 = IlrRulesetArchive.computeFQName(string, string2);
        this.storeArtifact(string, string3, byArray, 2);
    }

    protected void storeArtifact(String string, String string2, byte[] byArray, int n) {
        String string3 = IlrRulesetArchive.computeEntryName(string2);
        IlrRulesetArchiveBuilderBase.checkEntryName(string3);
        this.registerArtifact(string3, byArray);
        this.registerInToc(string, string3, n);
    }

    protected void registerInToc(String string, String string2, int n) {
        IlrRulesetArchive.PackageContent packageContent;
        String string3 = "";
        if (IlrRulesetArchive.isCurrentVersionAtLeast(6, 5)) {
            string3 = "IRL/";
        }
        String string4 = string3 + string2;
        if (this.irlTocs == null) {
            this.irlTocs = new HashMap();
        }
        if ((packageContent = (IlrRulesetArchive.PackageContent)this.irlTocs.get(string)) == null) {
            packageContent = new IlrRulesetArchive.PackageContent();
            this.irlTocs.put(string, packageContent);
        }
        switch (n) {
            case 0: {
                packageContent.addRule(string4);
                break;
            }
            case 1: {
                packageContent.addFunction(string4);
                break;
            }
            case 2: {
                packageContent.addTask(string4);
                break;
            }
            case 3: {
                packageContent.setVariables(string4);
                break;
            }
            case 4: {
                packageContent.addIrls(string4);
            }
        }
    }

    public void setVersion(int n, int n2) {
        this.majorNbVersion = n;
        this.minorNbVersion = n2;
    }

    public void setEngineConfEntry(InputStream inputStream) {
        try {
            byte[] byArray = this.getContentInByteArray(inputStream, "RESOURCES/engine.conf");
            this.byteEntry("RESOURCES/engine.conf", 4, byArray);
            inputStream.close();
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, "RESOURCES/engine.conf");
        }
    }

    public void setBusinessModelPath(ArrayList arrayList) {
        this.bomPathes = arrayList;
    }

    public void addBusinessModelEntry(String string, InputStream inputStream) {
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.bomTocs, string);
            if (this.bomPathes == null) {
                this.bomPathes = new ArrayList();
            }
            byte[] byArray = this.getContentInByteArray(inputStream, string);
            inputStream.close();
            this.fillBomXom(string, byArray, 1);
            if (this.bomTocs == null) {
                this.bomTocs = new ArrayList();
            }
            this.bomTocs.add(string);
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string);
        }
    }

    public void addMappingEntry(String string, InputStream inputStream) {
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.b2xTocs, string);
            byte[] byArray = this.getContentInByteArray(inputStream, string);
            inputStream.close();
            this.fillBomXom(string, byArray, 2);
            String string2 = IlrRulesetArchive.getObjectModelName(string);
            if (this.bom2XomNames == null) {
                this.bom2XomNames = new HashMap();
            }
            if (this.b2xTocs == null) {
                this.b2xTocs = new ArrayList();
            }
            this.b2xTocs.add(string);
            this.bom2XomNames.put(string2, string);
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string);
        }
    }

    public void addDynamicModelEntry(String string, InputStream inputStream) {
        string = this.normalizeEntryNameGiven(string);
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.xomTocs, string);
            if (this.xomTocs == null) {
                this.xomTocs = new ArrayList();
            }
            this.xomTocs.add(string);
            byte[] byArray = this.getContentInByteArray(inputStream, string);
            inputStream.close();
            this.fillBomXom(string, byArray, 3);
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string);
        }
    }

    public void enableBusinessXMLService(boolean bl) {
        this.currentArchive.setBusinessDataXmlServiceEnable(bl);
    }

    static void checkDuplicatedEntry(ArrayList arrayList, Object object) {
        if (arrayList == null) {
            return;
        }
        if (arrayList.contains(object)) {
            IlrRulesetArchive.alreadyInsertedError(object.toString());
        }
    }

    static void checkEntryName(String string) {
        if (string.length() > 65535) {
            IlrRulesetArchive.entryNameNotValid(string);
        }
        if (string.indexOf("//") > 0 || string.indexOf("*") > 0 || string.indexOf("?") > 0) {
            IlrRulesetArchive.entryNameNotValid(string);
        }
    }

    public void addXsdEntry(String string, InputStream inputStream) {
        string = this.normalizeEntryNameGiven(string);
        this.addSchema(string, null, string, inputStream, null);
    }

    public void addSchema(String string, String string2, InputStream inputStream) {
        String string3 = this.createEntryName(string2) + ".xsd";
        this.addSchema(string3, string, string2, inputStream, null);
    }

    public void addSchema(String string, String string2, URL uRL) {
        String string3 = this.createEntryName(string2) + ".xsd";
        this.addSchema(string3, string, string2, null, uRL);
    }

    private void addSchema(String string, String string2, String string3, InputStream inputStream, URL uRL) {
        SchemaDocument schemaDocument = new SchemaDocument(string, string3, string2, uRL);
        if (inputStream != null) {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.xsdTocs, schemaDocument);
            byte[] byArray = this.getContentInByteArray(inputStream, string3);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this.problemDuringArchiveEntryCreation(iOException, string3);
            }
            this.fillBomXom(string, byArray, 6);
        }
        if (this.xsdTocs == null) {
            this.xsdTocs = new ArrayList();
        }
        this.xsdTocs.add(schemaDocument);
    }

    public void addWsdlEntry(String string, InputStream inputStream) {
        string = this.normalizeEntryNameGiven(string);
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.wsdlTocs, string);
            if (this.wsdlTocs == null) {
                this.wsdlTocs = new ArrayList();
            }
            this.wsdlTocs.add(string);
            byte[] byArray = this.getContentInByteArray(inputStream, string);
            inputStream.close();
            this.fillBomXom(string, byArray, 7);
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string);
        }
    }

    public void addUserDataEntry(String string, InputStream inputStream) {
        try {
            if (this.userDataTocs == null) {
                this.userDataTocs = new ArrayList();
            }
            this.userDataTocs.add(string);
            byte[] byArray = this.getContentInByteArray(inputStream, string);
            inputStream.close();
            this.byteEntry("USER_DATA/" + string, 5, byArray);
        }
        catch (IOException iOException) {
            this.problemDuringArchiveEntryCreation(iOException, string);
        }
    }

    public void setXsdMetadata(String string) {
        this.xsdMetadataFileName = string;
    }

    public void setXsdIndex(String string) {
        this.xsdIndexFileName = string;
    }

    public void setXsdDescriptor(String string) {
        this.xsdDescriptorFileName = string;
    }

    public void setXsdBomInfo(String string) {
        this.xsdBomInfoFileName = string;
    }

    protected void addError(Exception exception, String string) {
        this.archiveBuildingErrors.add(string);
        throw new IlrRulesetArchive.RulesetArchiveException(exception, string);
    }

    protected void addError(String string) {
        this.archiveBuildingErrors.add(string);
        throw new IlrRulesetArchive.RulesetArchiveException(string);
    }

    public IlrRulesetArchive generate() {
        String[] stringArray = this.getErrors();
        int n = stringArray.length;
        if (n > 0) {
            this.printErrors();
            return null;
        }
        IlrRulesetArchive ilrRulesetArchive = this.currentArchive;
        try {
            ilrRulesetArchive = this.generateArchive(ilrRulesetArchive);
            ilrRulesetArchive.interpret();
        }
        catch (IlrRulesetArchive.RulesetArchiveException rulesetArchiveException) {
            this.printErrors();
            ilrRulesetArchive = null;
        }
        return ilrRulesetArchive;
    }

    public String[] getErrors() {
        int n = this.archiveBuildingErrors.size();
        String[] stringArray = new String[n];
        this.archiveBuildingErrors.toArray(stringArray);
        return stringArray;
    }

    public void printErrors() {
        String[] stringArray = this.getErrors();
        int n = stringArray.length;
        if (this.messageWriter == null) {
            this.messageWriter = new PrintWriter(System.out, true);
        }
        for (int i = 0; i < n; ++i) {
            this.messageWriter.println(stringArray[i]);
        }
    }

    protected IlrRulesetArchive generateArchive(IlrRulesetArchive ilrRulesetArchive) {
        this.fillArchive();
        this.currentArchive = null;
        return ilrRulesetArchive;
    }

    protected void fillArchive() {
        this.fillResources();
        this.fillMetaInf();
        this.fillIndex();
    }

    protected void fillResources() {
        this.fillMetadata();
        this.fillBomInfos();
        if (this.bomTocs != null) {
            this.currentArchive.isBusiness(true);
        }
    }

    protected void fillMetaInf() {
        XmlDescriptorBase xmlDescriptorBase = this.makeDescriptor();
        String string = this.xmlEntry("META-INF/descriptor.xml", xmlDescriptorBase);
        if (this.xsdDescriptorFileName != null) {
            this.validateXmlDocument(string);
        }
    }

    protected XmlDescriptorBase makeDescriptor() {
        return new XmlDescriptorBase();
    }

    protected void fillMetadata() {
        XmlMetadataBase xmlMetadataBase = this.createMetadata();
        String string = this.xmlEntry("RESOURCES/metadata.xml", xmlMetadataBase);
        if (this.xsdMetadataFileName != null) {
            this.validateXmlDocument(string);
        }
    }

    protected XmlMetadataBase createMetadata() {
        return new XmlMetadataBase();
    }

    protected void fillIndex() {
        XmlIndex xmlIndex = new XmlIndex();
        String string = IlrRulesetArchive.isCurrentVersionAtLeast(6, 5) ? "META-INF" : "RESOURCES";
        String string2 = string + "/" + "index.xml";
        String string3 = this.xmlEntry(string2, xmlIndex);
        if (this.xsdIndexFileName != null) {
            this.validateXmlDocument(string3);
        }
    }

    protected void fillBomInfos() {
        XmlBomInfo xmlBomInfo = new XmlBomInfo();
        String string = this.xmlEntry("RESOURCES/bominfo.xml", xmlBomInfo);
        if (this.xsdBomInfoFileName != null) {
            this.validateXmlDocument(string);
        }
    }

    protected void fillBomXom(String string, byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer("RESOURCES");
        if (!string.startsWith("/")) {
            stringBuffer.append("/");
        }
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        IlrRulesetArchiveBuilderBase.checkEntryName(string2);
        this.byteEntry(string2, n, byArray);
    }

    protected void registerArtifact(String string, byte[] byArray) {
        String string2 = "";
        if (IlrRulesetArchive.isCurrentVersionAtLeast(6, 5)) {
            string2 = "IRL/";
        }
        this.byteEntry(string2 + string, 0, byArray);
    }

    public void addMiscElementEntry(String string, String string2, byte[] byArray) {
        ArrayList<String> arrayList;
        String string3;
        String string4 = string3 = !string.equals("") ? string + "/" + string2 : string2;
        if (this.miscTocs == null) {
            this.miscTocs = new HashMap();
        }
        if ((arrayList = (ArrayList<String>)this.miscTocs.get(string)) == null) {
            arrayList = new ArrayList<String>();
            this.miscTocs.put(string, arrayList);
        }
        arrayList.add(string2);
        this.byteEntry(string3, 8, byArray);
    }

    protected String xmlEntry(String string, XmlBase xmlBase) {
        StringWriter stringWriter = new StringWriter();
        String string2 = null;
        try {
            xmlBase.write(stringWriter);
            string2 = stringWriter.toString();
            this.createUTF8Element(string, 20, string2);
        }
        catch (IOException iOException) {
            String string3 = IlrMessages.format("messages.RulesetArchive.2", string);
            this.addError(iOException, string3);
        }
        return string2;
    }

    protected final byte[] convertIntoBytes(String string) {
        byte[] byArray = null;
        try {
            if (string != null && string.length() > 0) {
                byArray = string.getBytes(this.encoding);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = null;
            String string2 = IlrMessages.getMessage("messages.RulesetArchive.4");
            this.addError(unsupportedEncodingException, string2);
        }
        return byArray;
    }

    protected final byte[] getContentInByteArray(InputStream inputStream, String string) {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        WritableByteChannel writableByteChannel = Channels.newChannel(byteArrayOutputStream);
        try {
            int n = 0;
            do {
                byteBuffer.clear();
                n = readableByteChannel.read(byteBuffer);
                byteBuffer.flip();
                writableByteChannel.write(byteBuffer);
            } while (n > 0);
        }
        catch (IOException iOException) {
            throw new RuntimeException(string, iOException);
        }
        finally {
            try {
                readableByteChannel.close();
                writableByteChannel.close();
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void problemDuringArchiveEntryCreation(IOException iOException, String string) {
        String string2 = IlrMessages.format("messages.RulesetArchive.0", string);
        this.addError(iOException, string2);
    }

    protected void byteEntry(String string, int n, byte[] byArray) {
        this.createElement(string, n, byArray);
    }

    private void createElement(String string, int n, String string2) {
        this.createElement(string, n, string2, this.encoding);
    }

    private void createUTF8Element(String string, int n, String string2) {
        this.createElement(string, n, string2, "UTF-8");
    }

    private void createElement(String string, int n, String string2, String string3) {
        try {
            byte[] byArray = string2.getBytes(string3);
            this.createElement(string, n, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string4 = IlrMessages.format("messages.RulesetArchive.0", string);
            this.addError(unsupportedEncodingException, string4);
        }
    }

    private void createElement(String string, int n, byte[] byArray) {
        IlrRulesetArchive ilrRulesetArchive = this.currentArchive;
        ilrRulesetArchive.getClass();
        IlrRulesetArchive.Element element = ilrRulesetArchive.new IlrRulesetArchive.Element(string, n);
        element.setContent(byArray);
        this.currentArchive.addElement(element);
    }

    private void validateXmlDocument(String string) {
        DOMParser dOMParser = new DOMParser();
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", true);
            dOMParser.setFeature("http://apache.org/xml/features/validation/schema", true);
            dOMParser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        catch (Exception exception) {
            String string2 = IlrMessages.format("RulesetArchive.RulesetSignature.4", exception.toString());
            this.addError(exception, string2);
        }
        ErrorChecker errorChecker = new ErrorChecker();
        dOMParser.setErrorHandler((ErrorHandler)errorChecker);
        try {
            dOMParser.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            String string3 = IlrMessages.format("RulesetArchive.RulesetSignature.4", exception.toString());
            this.addError(exception, string3);
        }
    }

    public void setXMLBuilderFactory(DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
        this.transformerFactory = transformerFactory;
    }

    private String createEntryName(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[5];
        Arrays.fill(cArray2, 'a');
        for (int i = 0; i < cArray.length && i < cArray2.length; ++i) {
            char c = cArray[i];
            if (!Character.isJavaIdentifierStart(c)) continue;
            cArray2[i] = c;
        }
        String string2 = new String(cArray2);
        return string2 + Integer.toString(this.nbXsdNameIndex++);
    }

    private String normalizeEntryNameGiven(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private class ErrorChecker
    extends DefaultHandler {
        private void display(SAXParseException sAXParseException, String string) {
            System.out.println(string + sAXParseException.getMessage() + " in " + sAXParseException.getSystemId() + " at line " + sAXParseException.getLineNumber() + " at column " + sAXParseException.getColumnNumber());
        }

        public void error(SAXParseException sAXParseException) {
            this.display(sAXParseException, "Parsing error:  ");
        }

        public void warning(SAXParseException sAXParseException) {
            this.display(sAXParseException, "Parsing warning:  ");
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.display(sAXParseException, "Parsing error:  ");
            System.out.println("Cannot continue.");
            super.fatalError(sAXParseException);
        }
    }

    private final class SchemaDocument {
        private String entryName;
        private String name;
        private String namespace;
        private URL location;

        private SchemaDocument(String string, String string2, String string3, URL uRL) {
            this.entryName = string;
            this.name = string2;
            this.namespace = string3;
            this.location = uRL;
        }

        public int hashCode() {
            return this.entryName.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof SchemaDocument) {
                SchemaDocument schemaDocument = (SchemaDocument)object;
                return this.entryName.equals(schemaDocument.entryName);
            }
            return false;
        }

        public String toString() {
            return this.entryName.toString();
        }
    }

    protected class XmlIndex
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/ruleset_index_1.0", "XmlIndex", null);
            Node node = document.getFirstChild();
            Element element = document.createElement("index:ruleset-index");
            element.setAttribute("xmlns:index", "http://www.ilog.com/products/xml/schemas/ruleset_index_1.0");
            document.replaceChild(element, node);
            if (IlrRulesetArchiveBuilderBase.this.xsdIndexFileName != null) {
                element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String string = "http://www.ilog.com/products/xml/schemas/ruleset_index_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdIndexFileName;
                element.setAttribute("xsi:schemaLocation", string);
            }
            this.beginIndent();
            this.createWhiteSpaceElt(document, element);
            this.buildGenerationDate(document, element, "index");
            this.buildToc(document, element);
            this.endIndent();
            return document;
        }

        private void buildToc(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("index:toc");
            element.appendChild(element2);
            this.beginIndent();
            this.buildModelToc(document, element2, IlrRulesetArchiveBuilderBase.this.bomTocs, "bomToc");
            this.buildModelToc(document, element2, IlrRulesetArchiveBuilderBase.this.b2xTocs, "bom2xomToc");
            this.buildModelToc(document, element2, IlrRulesetArchiveBuilderBase.this.xomTocs, "xomToc");
            this.buildXSDModelToc(document, element2);
            this.buildModelToc(document, element2, IlrRulesetArchiveBuilderBase.this.wsdlTocs, "wsdlToc");
            this.buildModelToc(document, element2, IlrRulesetArchiveBuilderBase.this.userDataTocs, "userDataToc");
            this.buildArtifactsToc(document, element2);
            this.buildMiscElementsToc(document, element2);
            this.endIndent();
            this.createWhiteSpaceElt(document, element2);
        }

        private void buildModelToc(Document document, Element element, ArrayList arrayList, String string) {
            Element element2 = document.createElement("index:" + string);
            this.createWhiteSpaceElt(document, element);
            element.appendChild(element2);
            this.buildTocEntries(document, arrayList, element2);
        }

        private void buildXSDModelToc(Document document, Element element) {
            Element element2 = document.createElement("index:xsdToc");
            this.createWhiteSpaceElt(document, element);
            element.appendChild(element2);
            this.buildXSDTocEntries(document, element2);
        }

        private void buildArtifactsToc(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("index:irlToc");
            element.appendChild(element2);
            if (IlrRulesetArchiveBuilderBase.this.irlTocs == null) {
                return;
            }
            Iterator iterator = IlrRulesetArchiveBuilderBase.this.irlTocs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.beginIndent();
                this.createWhiteSpaceElt(document, element2);
                Element element3 = document.createElement("index:package");
                element2.appendChild(element3);
                element3.setAttribute("name", string);
                IlrRulesetArchive.PackageContent packageContent = (IlrRulesetArchive.PackageContent)IlrRulesetArchiveBuilderBase.this.irlTocs.get(string);
                this.buildTocTypedEntries(document, packageContent, element3);
            }
            this.endIndent();
            this.createWhiteSpaceElt(document, element2);
        }

        private void buildTocTypedEntries(Document document, IlrRulesetArchive.PackageContent packageContent, Element element) {
            if (packageContent == null) {
                return;
            }
            this.beginIndent();
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("index:irls");
            element.appendChild(element2);
            this.buildTocEntries(document, packageContent.irls, element2);
            this.createWhiteSpaceElt(document, element);
            Element element3 = document.createElement("index:rules");
            element.appendChild(element3);
            this.buildTocEntries(document, packageContent.rules, element3);
            this.createWhiteSpaceElt(document, element);
            Element element4 = document.createElement("index:functions");
            element.appendChild(element4);
            this.buildTocEntries(document, packageContent.functions, element4);
            this.createWhiteSpaceElt(document, element);
            Element element5 = document.createElement("index:tasks");
            element.appendChild(element5);
            this.buildTocEntries(document, packageContent.tasks, element5);
            this.createWhiteSpaceElt(document, element);
            Element element6 = document.createElement("index:variables");
            element.appendChild(element6);
            this.beginIndent();
            this.buildTocEntry(document, packageContent.variables, element6);
            this.endIndent();
            this.createWhiteSpaceElt(document, element6);
            this.endIndent();
            this.createWhiteSpaceElt(document, element);
        }

        private void buildTocEntries(Document document, ArrayList arrayList, Element element) {
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            this.beginIndent();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                this.buildTocEntry(document, string, element);
            }
            this.endIndent();
            this.createWhiteSpaceElt(document, element);
        }

        private void buildXSDTocEntries(Document document, Element element) {
            if (IlrRulesetArchiveBuilderBase.this.xsdTocs == null || IlrRulesetArchiveBuilderBase.this.xsdTocs.size() == 0) {
                return;
            }
            this.beginIndent();
            int n = IlrRulesetArchiveBuilderBase.this.xsdTocs.size();
            for (int i = 0; i < n; ++i) {
                SchemaDocument schemaDocument = (SchemaDocument)IlrRulesetArchiveBuilderBase.this.xsdTocs.get(i);
                this.buildXSDTocEntry(document, schemaDocument, element);
            }
            this.endIndent();
            this.createWhiteSpaceElt(document, element);
        }

        private void buildTocEntry(Document document, String string, Element element) {
            if (string == null) {
                return;
            }
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("index:entry");
            element.appendChild(element2);
            element2.setAttribute("name", string);
        }

        private void buildXSDTocEntry(Document document, SchemaDocument schemaDocument, Element element) {
            if (schemaDocument == null) {
                return;
            }
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("index:xsdEntry");
            element.appendChild(element2);
            element2.setAttribute("name", schemaDocument.entryName);
            element2.setAttribute("schemaNamespace", schemaDocument.namespace);
            element2.setAttribute("xsdName", schemaDocument.name);
            if (schemaDocument.location != null) {
                element2.setAttribute("URL", schemaDocument.location.toString());
            } else {
                element2.setAttribute("URL", null);
            }
        }

        private void buildMiscElementsToc(Document document, Element element) {
            if (!IlrRulesetArchive.isCurrentVersionAtLeast(6, 5)) {
                return;
            }
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("index:miscElementsToc");
            element.appendChild(element2);
            if (IlrRulesetArchiveBuilderBase.this.miscTocs == null) {
                return;
            }
            this.beginIndent();
            Iterator iterator = IlrRulesetArchiveBuilderBase.this.miscTocs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.createWhiteSpaceElt(document, element2);
                Element element3 = document.createElement("index:misc");
                element2.appendChild(element3);
                element3.setAttribute("type", string);
                ArrayList arrayList = (ArrayList)IlrRulesetArchiveBuilderBase.this.miscTocs.get(string);
                int n = arrayList.size();
                this.beginIndent();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)arrayList.get(i);
                    String string3 = !string.equals("") ? string + '/' + string2 : string2;
                    this.buildTocEntry(document, string3, element3);
                }
                this.endIndent();
                this.createWhiteSpaceElt(document, element3);
            }
            this.endIndent();
            this.createWhiteSpaceElt(document, element2);
        }
    }

    protected class XmlMetadataBase
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/ruleset_metadata_1.0", "XmlMetadata", null);
            Node node = document.getFirstChild();
            Element element = document.createElement("metadata:ruleset-metadata");
            element.setAttribute("xmlns:metadata", "http://www.ilog.com/products/xml/schemas/ruleset_metadata_1.0");
            document.replaceChild(element, node);
            if (IlrRulesetArchiveBuilderBase.this.xsdMetadataFileName != null) {
                element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String string = "http://www.ilog.com/products/xml/schemas/ruleset_metadata_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdMetadataFileName;
                element.setAttribute("xsi:schemaLocation", string);
            }
            this.beginIndent();
            this.buildMetadata(document, element);
            this.endIndent();
            return document;
        }

        protected void buildMetadata(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            this.buildGenerationDate(document, element, "metadata");
        }
    }

    protected class XmlDescriptorBase
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/ruleset_descriptor_1.0", "XmlDescriptorBase", null);
            Node node = document.getFirstChild();
            Element element = document.createElement("desc:ruleset-descriptor");
            element.setAttribute("xmlns:desc", "http://www.ilog.com/products/xml/schemas/ruleset_descriptor_1.0");
            element.setAttribute("xmlns:sig", "http://www.ilog.com/products/xml/schemas/signature_2.0");
            document.replaceChild(element, node);
            if (IlrRulesetArchiveBuilderBase.this.xsdDescriptorFileName != null) {
                element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String string = "http://www.ilog.com/products/xml/schemas/ruleset_descriptor_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdDescriptorFileName;
                element.setAttribute("xsi:schemaLocation", string);
            }
            this.beginIndent();
            this.createWhiteSpaceElt(document, element);
            this.addElement(document, element, "desc:ruleset-name", "ruleset");
            this.buildIsBusinessElt(document, element);
            this.buildBusinessXMLServiceElt(document, element);
            this.createWhiteSpaceElt(document, element);
            this.buildGenerationDate(document, element, "desc");
            this.buildRulesetParameterElements(document, element);
            this.buildUnknownArtifact(document, element);
            this.buildArchiveEncoding(document, element);
            this.buildJRulesVersion(document, element);
            this.buildRulesetVersion(document, element);
            this.endIndent();
            return document;
        }

        protected void buildIsBusinessElt(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            String string = String.valueOf(IlrRulesetArchiveBuilderBase.this.currentArchive.isBusiness());
            this.addElement(document, element, "desc:isbusiness", string);
        }

        protected void buildBusinessXMLServiceElt(Document document, Element element) {
            if (!IlrRulesetArchiveBuilderBase.this.currentArchive.isBusiness() && IlrRulesetArchiveBuilderBase.this.currentArchive.isBusinessDataXmlServiceEnable()) {
                throw new IlrRulesetArchive.RulesetArchiveException(IlrMessages.getMessage("messages.RulesetArchive.22"));
            }
            this.createWhiteSpaceElt(document, element);
            String string = String.valueOf(IlrRulesetArchiveBuilderBase.this.currentArchive.isBusinessDataXmlServiceEnable());
            this.addElement(document, element, "desc:businessxmlserviceenable", string);
        }

        protected void buildRulesetParameterElements(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("desc:signature-declaration");
            element.appendChild(element2);
        }

        protected void buildArchiveEncoding(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            this.addElement(document, element, "desc:encoding", IlrRulesetArchiveBuilderBase.this.currentArchive.encoding);
        }

        protected void buildUnknownArtifact(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            this.addElement(document, element, "desc:error-for-unknown-artifact", String.valueOf(IlrRulesetArchiveBuilderBase.this.isUnknownArtifactAnError));
        }

        protected void buildJRulesVersion(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("desc:jrules-version");
            element.appendChild(element2);
            element2.setAttribute("major", String.valueOf(IlrRulesetArchive.localMajorJRulesVersion));
            element2.setAttribute("minor", String.valueOf(IlrRulesetArchive.localMinorJRulesVersion));
        }

        protected void buildRulesetVersion(Document document, Element element) {
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("desc:version");
            element.appendChild(element2);
            element2.setAttribute("major", String.valueOf(IlrRulesetArchiveBuilderBase.this.majorNbVersion));
            element2.setAttribute("minor", String.valueOf(IlrRulesetArchiveBuilderBase.this.minorNbVersion));
        }
    }

    protected class XmlBomInfo
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/bominfo_1.0", "XmlBomInfo", null);
            Node node = document.getFirstChild();
            Element element = document.createElement("bom:bom-info");
            element.setAttribute("xmlns:bom", "http://www.ilog.com/products/xml/schemas/bominfo_1.0");
            document.replaceChild(element, node);
            if (IlrRulesetArchiveBuilderBase.this.xsdBomInfoFileName != null) {
                element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String string = "http://www.ilog.com/products/xml/schemas/bominfo_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdBomInfoFileName;
                element.setAttribute("xsi:schemaLocation", string);
            }
            this.beginIndent();
            this.createWhiteSpaceElt(document, element);
            this.buildGenerationDate(document, element, "bom");
            this.buildBomPathes(document, element);
            this.endIndent();
            return document;
        }

        private void buildBomPathes(Document document, Element element) {
            if (IlrRulesetArchiveBuilderBase.this.bomPathes == null || IlrRulesetArchiveBuilderBase.this.bomPathes.size() == 0) {
                return;
            }
            this.createWhiteSpaceElt(document, element);
            Element element2 = document.createElement("bom:bompathes");
            element.appendChild(element2);
            this.beginIndent();
            int n = IlrRulesetArchiveBuilderBase.this.bomPathes.size();
            for (int i = 0; i < n; ++i) {
                Element element3 = document.createElement("bom:bompath");
                String string = (String)IlrRulesetArchiveBuilderBase.this.bomPathes.get(i);
                this.createWhiteSpaceElt(document, element2);
                element2.appendChild(element3);
                element3.setAttribute("value", string);
            }
            this.endIndent();
            this.createWhiteSpaceElt(document, element2);
        }
    }

    protected abstract class XmlBase {
        protected boolean errorEncountered;
        protected DocumentBuilderFactory documentBuilderFact = null;
        protected DocumentBuilder documentBuilder = null;
        protected DOMImplementation domImplementation = null;
        protected int indent = 0;

        protected XmlBase() {
            try {
                this.documentBuilderFact = IlrRulesetArchiveBuilderBase.this.documentBuilderFactory != null ? IlrRulesetArchiveBuilderBase.this.documentBuilderFactory : DocumentBuilderFactory.newInstance();
                this.documentBuilder = this.documentBuilderFact.newDocumentBuilder();
                this.domImplementation = this.documentBuilder.getDOMImplementation();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
        }

        public boolean write(Writer writer) throws IOException {
            this.errorEncountered = false;
            Document document = this.buildDocument();
            this.writeDocument(document, writer);
            return !this.errorEncountered;
        }

        private void writeDocument(final Document document, final Writer writer) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    this.writeDocumentInternal(document, writer);
                    return null;
                }
            });
        }

        private void writeDocumentInternal(Document document, Writer writer) {
            try {
                TransformerFactory transformerFactory = IlrRulesetArchiveBuilderBase.this.transformerFactory == null ? TransformerFactory.newInstance() : IlrRulesetArchiveBuilderBase.this.transformerFactory;
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("omit-xml-declaration", "no");
                DOMSource dOMSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(writer);
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                throw new RuntimeException(transformerException);
            }
        }

        private void printDoubleDigit(int n, StringBuffer stringBuffer) {
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
        }

        protected void buildGenerationDate(Document document, Element element, String string) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(gregorianCalendar.get(1));
            stringBuffer.append('-');
            this.printDoubleDigit(gregorianCalendar.get(2) + 1, stringBuffer);
            stringBuffer.append('-');
            this.printDoubleDigit(gregorianCalendar.get(5), stringBuffer);
            stringBuffer.append('T');
            this.printDoubleDigit(gregorianCalendar.get(11), stringBuffer);
            stringBuffer.append(':');
            this.printDoubleDigit(gregorianCalendar.get(12), stringBuffer);
            stringBuffer.append(':');
            this.printDoubleDigit(gregorianCalendar.get(13), stringBuffer);
            stringBuffer.append('Z');
            this.addElement(document, element, string + ":" + "generation-date", stringBuffer.toString());
        }

        protected void addElement(Document document, Element element, String string, String string2) {
            Element element2 = document.createElement(string);
            Text text = document.createTextNode(string2);
            element2.appendChild(text);
            element.appendChild(element2);
        }

        protected void createWhiteSpaceElt(Document document, Node node) {
            String string = "";
            for (int i = 0; i < this.indent; ++i) {
                string = string + "  ";
            }
            Text text = document.createTextNode("\n" + string);
            node.appendChild(text);
        }

        protected void beginIndent() {
            ++this.indent;
        }

        protected void endIndent() {
            --this.indent;
        }

        protected abstract Document buildDocument();
    }
}

