/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base;

import ilog.rules.base.IlrError;
import ilog.rules.base.IlrErrorException;
import ilog.rules.base.IlrErrorManager;
import ilog.rules.base.IlrWarning;
import ilog.rules.util.prefs.IlrMessages;
import java.util.ArrayList;
import java.util.List;

public class IlrDefaultErrorManager
implements IlrErrorManager {
    List errors = new ArrayList();
    List warnings = new ArrayList();

    public void addError(IlrError ilrError) {
        this.errors.add(ilrError);
    }

    public void addWarning(IlrWarning ilrWarning) {
        this.warnings.add(ilrWarning);
    }

    public Object localize(Object object) {
        return null;
    }

    public String localizeAsString(Object object) {
        return null;
    }

    public IlrErrorException createException() {
        return new IlrErrorException(this.getErrors(), this.getWarnings());
    }

    public IlrError[] getErrors() {
        IlrError[] ilrErrorArray = new IlrError[this.errors.size()];
        return this.errors.toArray(ilrErrorArray);
    }

    public IlrWarning[] getWarnings() {
        IlrWarning[] ilrWarningArray = new IlrWarning[this.warnings.size()];
        return this.warnings.toArray(ilrWarningArray);
    }

    public void reset() {
        this.errors.clear();
        this.warnings.clear();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public String formatMessage(String string, String[] stringArray) {
        String string2 = string + ": <Internal error, no message property for this ID>";
        return IlrMessages.getMessage(null, string, string2, stringArray);
    }

    public IlrError addError(String string, String[] stringArray) {
        String string2 = this.formatMessage(string, stringArray);
        IlrError ilrError = new IlrError(string2, string);
        this.addError(ilrError);
        return ilrError;
    }

    public IlrError addError(String string, String[] stringArray, Exception exception) {
        String string2 = this.formatMessage(string, stringArray);
        IlrError ilrError = new IlrError(string2, string, exception);
        this.addError(ilrError);
        return ilrError;
    }

    public IlrWarning addWarning(String string, String[] stringArray) {
        String string2 = this.formatMessage(string, stringArray);
        IlrWarning ilrWarning = new IlrWarning(string2, string);
        this.addWarning(ilrWarning);
        return ilrWarning;
    }
}

