/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml;

import ilog.rules.base.IlrErrorException;
import ilog.rules.base.IlrErrorManager;
import ilog.rules.base.IlrWarning;
import ilog.rules.base.xml.IlrQName;
import ilog.rules.base.xml.IlrXmlConstants;
import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlNamespaceManager;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IlrXmlDefaultConverterManager
implements IlrXmlConstants {
    protected HashMap converterFromXmlElement = new HashMap();
    protected HashMap converterFromXmlType = new HashMap();
    protected HashMap converterFromClass = new HashMap();
    protected IlrErrorManager errorManager;
    protected boolean objectGraphSupport;
    protected static final Object NULLPLACEHOLDER = new Object();

    public IlrXmlDefaultConverterManager(IlrErrorManager ilrErrorManager, boolean bl) {
        this.errorManager = ilrErrorManager;
        this.objectGraphSupport = bl;
    }

    public void writeObject(Object object, IlrQName ilrQName, IlrXmlNamespaceManager ilrXmlNamespaceManager, Document document, HashMap hashMap) throws IlrErrorException {
        MarshallingContext marshallingContext = this.objectGraphSupport ? new GraphMarshallingContext(ilrXmlNamespaceManager, document, hashMap) : new TreeMarshallingContext(ilrXmlNamespaceManager, document, hashMap);
        Element element = marshallingContext.writeObject(object, null, ilrQName);
        if (element == null) {
            this.errorManager.addError("xml.data.ERROR_XML_001", new String[]{object.getClass().getName()});
        } else {
            document.appendChild(element);
            this.declareNamespaceAttributes(element, ilrXmlNamespaceManager);
            this.declareSchemaLocationAttribute(element, marshallingContext);
        }
    }

    protected void declareNamespaceAttributes(Element element, IlrXmlNamespaceManager ilrXmlNamespaceManager) {
        Iterator iterator = ilrXmlNamespaceManager.iteratePrefix();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = ilrXmlNamespaceManager.getNamespace(string);
            element.setAttribute("xmlns:" + string, string2);
        }
    }

    protected void declareSchemaLocationAttribute(Element element, MarshallingContext marshallingContext) {
        String string;
        Iterator iterator = marshallingContext.xsdLocationFromNs.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = (String)marshallingContext.xsdLocationFromNs.get(string);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string + " " + string2);
        }
        string = stringBuffer.toString();
        if (string.length() != 0) {
            element.setAttribute("xsi:schemaLocation", string);
        }
    }

    public Object readObject(Document document, HashMap hashMap, Class clazz) throws IlrErrorException {
        IlrXmlNamespaceManager ilrXmlNamespaceManager = this.createNamespaceManager(document.getDocumentElement());
        UnmarshallingContext unmarshallingContext = this.objectGraphSupport ? new GraphUnmarshallingContext(ilrXmlNamespaceManager, document, hashMap) : new TreeUnmarshallingContext(ilrXmlNamespaceManager, document, hashMap);
        Object object = unmarshallingContext.readObject(null, document.getDocumentElement());
        if (object != null && clazz != null && !clazz.isAssignableFrom(object.getClass())) {
            this.errorManager.addError("xml.data.ERROR_XML_002", new String[]{object.toString(), object.getClass().getName(), clazz.getName()});
            return null;
        }
        return object;
    }

    private IlrXmlNamespaceManager createNamespaceManager(Element element) {
        IlrXmlNamespaceManager ilrXmlNamespaceManager = new IlrXmlNamespaceManager();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) continue;
            ilrXmlNamespaceManager.addNamespace(node.getLocalName(), node.getNodeValue());
        }
        return ilrXmlNamespaceManager;
    }

    public void addConverter(IlrXmlConverter ilrXmlConverter) {
        Class[] classArray;
        IlrQName ilrQName;
        IlrQName ilrQName2 = ilrXmlConverter.getXmlElement();
        if (ilrQName2 != null) {
            this.converterFromXmlElement.put(ilrQName2.toString(), ilrXmlConverter);
        }
        if ((ilrQName = ilrXmlConverter.getXmlType()) != null) {
            this.converterFromXmlType.put(ilrQName.toString(), ilrXmlConverter);
        }
        if ((classArray = ilrXmlConverter.getSupportedClasses()) != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                this.converterFromClass.put(clazz == null ? NULLPLACEHOLDER : clazz, ilrXmlConverter);
            }
        }
    }

    public void removeConverter(IlrXmlConverter ilrXmlConverter) {
        Class[] classArray;
        IlrQName ilrQName;
        IlrQName ilrQName2 = ilrXmlConverter.getXmlElement();
        if (ilrQName2 != null) {
            this.converterFromXmlElement.remove(ilrQName2.toString());
        }
        if ((ilrQName = ilrXmlConverter.getXmlType()) != null) {
            this.converterFromXmlType.remove(ilrQName.toString());
        }
        if ((classArray = ilrXmlConverter.getSupportedClasses()) != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                this.converterFromClass.remove(clazz == null ? NULLPLACEHOLDER : clazz);
            }
        }
    }

    protected IlrXmlConverter getConverter(IlrXmlMarshallingContext ilrXmlMarshallingContext, Element element, Object object) {
        return (IlrXmlConverter)this.converterFromClass.get(object.getClass());
    }

    protected IlrXmlConverter getConverter(IlrXmlUnmarshallingContext ilrXmlUnmarshallingContext, Element element) {
        IlrQName ilrQName = ilrXmlUnmarshallingContext.getXsiType(element);
        IlrXmlConverter ilrXmlConverter = null;
        if (ilrQName != null) {
            ilrXmlConverter = (IlrXmlConverter)this.converterFromXmlType.get(ilrQName.toString());
        }
        if (ilrXmlConverter == null) {
            String string = IlrQName.toString(element.getNamespaceURI(), element.getLocalName(), null);
            ilrXmlConverter = (IlrXmlConverter)this.converterFromXmlElement.get(string);
        }
        return ilrXmlConverter;
    }

    private class TreeUnmarshallingContext
    extends UnmarshallingContext {
        public TreeUnmarshallingContext(IlrXmlNamespaceManager ilrXmlNamespaceManager, Document document, HashMap hashMap) {
            super(ilrXmlNamespaceManager, document, hashMap);
        }

        public Object readObject(Object object, Element element) throws IlrErrorException {
            if (element == null) {
                return null;
            }
            IlrXmlConverter ilrXmlConverter = IlrXmlDefaultConverterManager.this.getConverter(this, element);
            if (ilrXmlConverter == null) {
                IlrXmlDefaultConverterManager.this.errorManager.addError("xml.data.ERROR_XML_006", new String[]{element.getTagName()});
                return null;
            }
            try {
                Object object2 = ilrXmlConverter.readObject(element, this);
                return object2;
            }
            catch (RuntimeException runtimeException) {
                IlrXmlDefaultConverterManager.this.errorManager.addError("xml.data.ERROR_XML_012", new String[]{runtimeException.getClass().getName(), runtimeException.getMessage(), element.getTagName()}, runtimeException);
                throw IlrXmlDefaultConverterManager.this.errorManager.createException();
            }
        }
    }

    private class GraphUnmarshallingContext
    extends UnmarshallingContext {
        private Map id2Object = new HashMap();
        private Stack parentIdStack = new Stack();

        public GraphUnmarshallingContext(IlrXmlNamespaceManager ilrXmlNamespaceManager, Document document, HashMap hashMap) {
            super(ilrXmlNamespaceManager, document, hashMap);
        }

        public Object readObject(Object object, Element element) throws IlrErrorException {
            String string;
            Object object2;
            Object object3;
            if (this.parentIdStack.size() > 0 && !this.id2Object.containsKey(object3 = this.parentIdStack.peek())) {
                this.id2Object.put(object3, object);
            }
            if (element == null) {
                return null;
            }
            object3 = element.getAttribute("reference");
            if (((String)object3).length() != 0) {
                object2 = this.id2Object.get(object3);
                if (object2 != null) {
                    return object2;
                }
                string = IlrXmlDefaultConverterManager.this.errorManager.formatMessage("xml.data.WARNING_XML_001", new String[]{object3});
                IlrXmlDefaultConverterManager.this.errorManager.addWarning(new IlrWarning("xml.data.WARNING_XML_001", string));
            }
            if ((object2 = IlrXmlDefaultConverterManager.this.getConverter(this, element)) == null) {
                IlrXmlDefaultConverterManager.this.errorManager.addError("xml.data.ERROR_XML_006", new String[]{element.getTagName()});
                return null;
            }
            string = element.getAttribute("id");
            this.parentIdStack.push(string);
            Object object4 = object2.readObject(element, this);
            if (string.length() != 0) {
                this.id2Object.put(string, object4);
            }
            this.parentIdStack.pop();
            return object4;
        }
    }

    private abstract class UnmarshallingContext
    implements IlrXmlUnmarshallingContext {
        private IlrXmlNamespaceManager nsManager;
        private Document document;
        private HashMap data;

        public UnmarshallingContext(IlrXmlNamespaceManager ilrXmlNamespaceManager, Document document, HashMap hashMap) {
            this.nsManager = ilrXmlNamespaceManager;
            this.document = document;
            this.data = hashMap;
        }

        public Object readObject(Object object, Element element, Class clazz) throws IlrErrorException {
            Object object2 = this.readObject(object, element);
            if (object2 != null && !clazz.isAssignableFrom(object2.getClass())) {
                IlrXmlDefaultConverterManager.this.errorManager.addError("xml.data.ERROR_XML_002", new String[]{object2.toString(), object2.getClass().getName(), clazz.getName()});
                return null;
            }
            return object2;
        }

        private boolean isSelectedNode(Node node, String string, String string2) {
            if (node.getNodeType() == 1) {
                boolean bl = string == null || string != null && string.equals(node.getNamespaceURI());
                boolean bl2 = string2 == null || string2.equals(node.getLocalName());
                return bl && bl2;
            }
            return false;
        }

        public Element getFirstElement(Element element, String string, String string2) {
            Node node;
            if (element == null) {
                return null;
            }
            for (node = element.getFirstChild(); node != null && !this.isSelectedNode(node, string, string2); node = node.getNextSibling()) {
            }
            return (Element)node;
        }

        public Element getNextElement(Element element, String string, String string2) {
            Node node;
            if (element == null) {
                return null;
            }
            for (node = element.getNextSibling(); node != null && !this.isSelectedNode(node, string, string2); node = node.getNextSibling()) {
            }
            return (Element)node;
        }

        public Document getDocument() {
            return this.document;
        }

        public String getNamespace(String string) {
            return this.getNamespaceManager().getNamespace(string);
        }

        public IlrErrorManager getErrorManager() {
            return IlrXmlDefaultConverterManager.this.errorManager;
        }

        public IlrXmlNamespaceManager getNamespaceManager() {
            return this.nsManager;
        }

        public Object getData(String string) {
            return this.data.get(string);
        }

        public IlrXmlConverter getConverterFromClass(Class clazz) {
            return (IlrXmlConverter)IlrXmlDefaultConverterManager.this.converterFromClass.get(clazz);
        }

        public IlrQName getXsiType(Element element) {
            String string = element.getAttributeNS("http://www.w3.org/2000/10/XMLSchema-instance", "type");
            if (string == null) {
                return null;
            }
            IlrQName ilrQName = IlrQName.parse(string);
            String string2 = this.getNamespace(ilrQName.getPrefix());
            return new IlrQName(string2, ilrQName.getLocalPart());
        }
    }

    private class GraphMarshallingContext
    extends MarshallingContext {
        private Map object2Element = new IdentityHashMap();
        private int idCounter;

        public GraphMarshallingContext(IlrXmlNamespaceManager ilrXmlNamespaceManager, Document document, HashMap hashMap) {
            super(ilrXmlNamespaceManager, document, hashMap);
        }

        private String getId(Element element) {
            String string = element.getAttribute("id");
            if (string.length() == 0) {
                ++this.idCounter;
                string = "" + this.idCounter;
                element.setAttribute("id", string);
            }
            return string;
        }

        protected void writeObjectInternal(Object object, Element element, IlrXmlConverter ilrXmlConverter) throws IlrErrorException {
            if (ilrXmlConverter.isReferenceWorthy()) {
                Element element2 = (Element)this.object2Element.get(object);
                if (element2 == null) {
                    this.object2Element.put(object, element);
                    ilrXmlConverter.writeObject(object, element, this);
                } else {
                    String string = this.getId(element2);
                    element.setAttribute("reference", string);
                }
            } else {
                ilrXmlConverter.writeObject(object, element, this);
            }
        }
    }

    private class TreeMarshallingContext
    extends MarshallingContext {
        public TreeMarshallingContext(IlrXmlNamespaceManager ilrXmlNamespaceManager, Document document, HashMap hashMap) {
            super(ilrXmlNamespaceManager, document, hashMap);
        }

        protected void writeObjectInternal(Object object, Element element, IlrXmlConverter ilrXmlConverter) throws IlrErrorException {
            ilrXmlConverter.writeObject(object, element, this);
        }
    }

    private abstract class MarshallingContext
    implements IlrXmlMarshallingContext {
        private IlrXmlNamespaceManager nsManager;
        private Document document;
        private HashMap data;
        private HashMap xsdLocationFromNs = new HashMap();

        public MarshallingContext(IlrXmlNamespaceManager ilrXmlNamespaceManager, Document document, HashMap hashMap) {
            this.nsManager = ilrXmlNamespaceManager;
            this.document = document;
            this.data = hashMap;
        }

        public Element writeObject(Object object, Element element) throws IlrErrorException {
            return this.writeObject(object, element, null);
        }

        public Element writeObject(Object object, Element element, IlrQName ilrQName) throws IlrErrorException {
            IlrXmlConverter ilrXmlConverter = IlrXmlDefaultConverterManager.this.getConverter(this, element, object);
            Element element2 = null;
            if (ilrXmlConverter == null) {
                IlrXmlDefaultConverterManager.this.errorManager.addError("xml.data.ERROR_XML_003", new String[]{object.getClass().getName()});
            } else {
                IlrQName ilrQName2 = null;
                if (ilrQName == null) {
                    ilrQName = ilrXmlConverter.getXmlElement();
                } else if (!ilrQName.equals(ilrXmlConverter.getXmlElement())) {
                    ilrQName2 = ilrXmlConverter.getXmlType();
                }
                if (ilrQName == null) {
                    IlrXmlDefaultConverterManager.this.errorManager.addError("xml.data.ERROR_XML_004", new String[]{object.toString(), object.getClass().getName()});
                } else {
                    IlrQName ilrQName3 = ilrXmlConverter.getSchemaLocation();
                    if (ilrQName3 != null) {
                        this.addSchemaLocation(ilrQName3.getNamespaceURI(), ilrQName3.getLocalPart());
                    }
                    if ((element2 = this.createElement(ilrQName.getNamespaceURI(), ilrQName.getLocalPart())) != null && element != null) {
                        element.appendChild(element2);
                    }
                    this.writeObjectInternal(object, element2, ilrXmlConverter);
                    if (ilrQName2 != null) {
                        this.setXsiTypeAttribute(element2, ilrQName2);
                    }
                }
            }
            return element2;
        }

        protected abstract void writeObjectInternal(Object var1, Element var2, IlrXmlConverter var3) throws IlrErrorException;

        public Element createElement(String string, String string2) {
            if (string == null) {
                return this.createElement(string2);
            }
            String string3 = this.nsManager.getPrefix(string);
            if (string3 == null) {
                string3 = this.nsManager.getNewPrefix(string, "ns");
            }
            String string4 = string3 == null ? string2 : string3 + ":" + string2;
            return this.document.createElementNS(string, string4);
        }

        public Element createElement(String string) {
            return this.document.createElement(string);
        }

        public void setAttribute(Element element, String string, String string2, String string3) {
            String string4;
            if (string == null) {
                element.setAttribute(string2, string3);
            }
            if ((string4 = this.nsManager.getPrefix(string)) == null) {
                string4 = this.nsManager.getNewPrefix(string, "ns");
            }
            String string5 = string4 == null ? string2 : string4 + ":" + string2;
            element.setAttributeNS(string, string5, string3);
        }

        public Document getDocument() {
            return this.document;
        }

        public IlrErrorManager getErrorManager() {
            return IlrXmlDefaultConverterManager.this.errorManager;
        }

        public IlrXmlNamespaceManager getNamespaceManager() {
            return this.nsManager;
        }

        public void setXsiTypeAttribute(Element element, IlrQName ilrQName) {
            String string = this.nsManager.getPrefix(ilrQName.getNamespaceURI());
            if (string == null) {
                string = this.nsManager.getNewPrefix(ilrQName.getNamespaceURI(), "ns");
            }
            String string2 = IlrQName.toString(null, ilrQName.getLocalPart(), string);
            this.setAttribute(element, "http://www.w3.org/2000/10/XMLSchema-instance", "type", string2);
        }

        public Object getData(Object object) {
            return this.data.get(object);
        }

        public Object putData(Object object, Object object2) {
            return this.data.put(object, object2);
        }

        public Object removeData(Object object) {
            return this.data.remove(object);
        }

        public void addSchemaLocation(String string, String string2) {
            this.xsdLocationFromNs.put(string, string2);
        }
    }
}

