/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml;

import ilog.rules.base.IlrErrorException;
import ilog.rules.base.IlrErrorManager;
import ilog.rules.base.IlrWarning;
import ilog.rules.base.xml.IlrQName;
import ilog.rules.base.xml.IlrXmlConstants;
import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlDefaultConverterManager;
import ilog.rules.base.xml.IlrXmlNamespaceManager;
import ilog.rules.base.xml.IlrXmlService;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IlrXmlDefaultService
implements IlrXmlService,
IlrXmlConstants {
    IlrXmlDefaultConverterManager converterManager;
    protected IlrErrorManager errorManager;
    boolean validating = false;

    public IlrXmlDefaultService(IlrErrorManager ilrErrorManager, boolean bl) {
        this(ilrErrorManager, new IlrXmlDefaultConverterManager(ilrErrorManager, bl));
    }

    protected IlrXmlDefaultService(IlrErrorManager ilrErrorManager, IlrXmlDefaultConverterManager ilrXmlDefaultConverterManager) {
        this.errorManager = ilrErrorManager;
        this.converterManager = ilrXmlDefaultConverterManager;
    }

    public void addConverter(IlrXmlConverter ilrXmlConverter) {
        this.converterManager.addConverter(ilrXmlConverter);
    }

    public void removeConverter(IlrXmlConverter ilrXmlConverter) {
        this.converterManager.removeConverter(ilrXmlConverter);
    }

    public IlrWarning[] getWarnings() {
        return this.errorManager.getWarnings();
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public Object readObject(Reader reader, String string, HashMap hashMap, Class clazz) throws IlrErrorException {
        this.errorManager.reset();
        Object object = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(this.validating);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(reader);
            inputSource.setPublicId(string);
            Document document = documentBuilder.parse(new InputSource(reader));
            object = this.converterManager.readObject(document, hashMap, clazz);
            if (this.errorManager.hasErrors()) {
                throw this.errorManager.createException();
            }
            return object;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorManager.addError("xml.data.ERROR_XML_007", new String[]{parserConfigurationException.getMessage()}, parserConfigurationException);
            throw this.errorManager.createException();
        }
        catch (IOException iOException) {
            this.errorManager.addError("xml.data.ERROR_XML_007", new String[]{iOException.getMessage()}, iOException);
            throw this.errorManager.createException();
        }
        catch (SAXException sAXException) {
            this.errorManager.addError("xml.data.ERROR_XML_008", new String[]{sAXException.getMessage()});
            throw this.errorManager.createException();
        }
    }

    private IlrXmlNamespaceManager createNamespaceManager() {
        IlrXmlNamespaceManager ilrXmlNamespaceManager = new IlrXmlNamespaceManager();
        ilrXmlNamespaceManager.addNamespace("xsi", "http://www.w3.org/2000/10/XMLSchema-instance");
        return ilrXmlNamespaceManager;
    }

    public void writeObject(Object object, Writer writer, HashMap hashMap) throws IlrErrorException {
        this.writeObject(object, null, writer, hashMap);
    }

    public void writeObject(Object object, IlrQName ilrQName, Writer writer, HashMap hashMap) throws IlrErrorException {
        this.errorManager.reset();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            this.converterManager.writeObject(object, ilrQName, this.createNamespaceManager(), document, hashMap);
            this.writeDocument(document, writer);
            if (this.errorManager.hasErrors()) {
                throw this.errorManager.createException();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorManager.addError("xml.data.ERROR_XML_007", new String[]{parserConfigurationException.getMessage()}, parserConfigurationException);
        }
        if (this.errorManager.hasErrors()) {
            throw this.errorManager.createException();
        }
    }

    private void writeDocument(Document document, Writer writer) throws IlrErrorException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            this.errorManager.addError("xml.data.ERROR_XML_007", new String[]{exception.getMessage()}, exception);
            throw this.errorManager.createException();
        }
    }
}

