/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.mbean.util;

import ilog.rules.bres.mbean.util.IlrMBeanManager;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_jbossHA;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_mx4j;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_oc4j1013m;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_oc4j1013s;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_weblogic81;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_weblogic9;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_websphere;
import java.util.Properties;

public class IlrMBeanManagerFactory {
    public static final int NOT_DEFINED = -1;
    public static final int DEFAULT = 0;
    public static final int MX4J = 1;
    public static final int WEBLOGIC81 = 2;
    public static final int WEBSPHERE = 3;
    public static final int JBOSSHA = 4;
    public static final int WEBLOGIC90 = 5;
    public static final int OC4J1013S = 6;
    public static final int OC4J1013M = 7;
    private static final String JMX_CHOICE = "ilog.jmx.implementation";
    private int jmx_impl = -1;
    private Properties properties;

    public IlrMBeanManagerFactory(Properties properties) {
        this.properties = properties;
        if (properties != null) {
            String string = properties.getProperty(JMX_CHOICE);
            try {
                this.jmx_impl = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public synchronized int getJmxImplementation() {
        if (this.jmx_impl != -1) {
            return this.jmx_impl;
        }
        this.jmx_impl = this.findJmxImplementation();
        return this.jmx_impl;
    }

    public IlrMBeanManager createMBeanManager() {
        switch (this.getJmxImplementation()) {
            case 0: {
                return new IlrMBeanManagerImpl(this.properties);
            }
            case 2: {
                return new IlrMBeanManagerImpl_weblogic81(this.properties);
            }
            case 3: {
                return new IlrMBeanManagerImpl_websphere(this.properties);
            }
            case 4: {
                return new IlrMBeanManagerImpl_jbossHA(this.properties);
            }
            case 1: {
                return new IlrMBeanManagerImpl_mx4j(this.properties);
            }
            case 5: {
                return new IlrMBeanManagerImpl_weblogic9(this.properties);
            }
            case 6: {
                return new IlrMBeanManagerImpl_oc4j1013s(this.properties);
            }
            case 7: {
                return new IlrMBeanManagerImpl_oc4j1013m(this.properties);
            }
        }
        return null;
    }

    private int findJmxImplementation() {
        try {
            Class.forName("oracle.ias.opmn.optic.OpmnQuery");
            Class.forName("oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory");
            if (IlrMBeanManagerImpl_oc4j1013m.isAvailable()) {
                return 7;
            }
            return 6;
        }
        catch (Throwable throwable) {
            try {
                Class.forName("oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory");
                return 6;
            }
            catch (Throwable throwable2) {
                try {
                    Class.forName("weblogic.management.jmx.modelmbean.WLSModelMBean");
                    return 5;
                }
                catch (Throwable throwable3) {
                    try {
                        Class.forName("weblogic.management.MBeanHome");
                        return 2;
                    }
                    catch (Throwable throwable4) {
                        try {
                            Class.forName("com.ibm.websphere.management.AdminServiceFactory");
                            return 3;
                        }
                        catch (Throwable throwable5) {
                            try {
                                Class.forName("org.jboss.ha.framework.interfaces.HAPartition");
                                Class.forName("org.jboss.invocation.InvokerInterceptor");
                                return 4;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    Class.forName("mx4j.tools.adaptor.http.HttpAdaptor");
                                    Class.forName("mx4j.tools.adaptor.http.XSLTProcessor");
                                    Class.forName("mx4j.tools.naming.NamingService");
                                    return 1;
                                }
                                catch (Throwable throwable7) {
                                    return 0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

