/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.mbean.util;

import ilog.rules.bres.mbean.util.IlrMBeanManager;
import ilog.rules.bres.mbean.util.InvocationResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

class IlrMBeanManagerImpl
implements IlrMBeanManager {
    protected static final int INVOC_METHOD = 1;
    protected static final int INVOC_SET = 2;
    protected static final int INVOC_GET = 3;
    protected Properties props = new Properties();
    protected String typeElement;
    protected String domain;
    protected MBeanServer mbeanServer = null;
    protected UnregisterPrivilegedExceptionAction unregisterAction = new UnregisterPrivilegedExceptionAction();

    public IlrMBeanManagerImpl(Properties properties) {
        this("type", "BRES", properties);
    }

    IlrMBeanManagerImpl(String string, String string2, Properties properties) {
        this.typeElement = string;
        this.domain = string2;
        if (properties != null) {
            this.props = properties;
        }
    }

    public void initMBeanManager() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
                IlrMBeanManagerImpl.this.mbeanServer = arrayList.size() > 0 ? arrayList.get(0) : MBeanServerFactory.createMBeanServer();
                return null;
            }
        });
    }

    public Properties getProperties() {
        return (Properties)this.props.clone();
    }

    public String getImplementationName() {
        return "Sun";
    }

    public MBeanServer getLocalMBeanServer() {
        return this.mbeanServer;
    }

    public ObjectName registerMBean(String string, Properties properties, final Object object) throws Exception {
        properties.setProperty(this.typeElement, string);
        final ObjectName objectName = new ObjectName(this.domain, properties);
        try {
            return (ObjectName)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    ObjectInstance objectInstance = IlrMBeanManagerImpl.this.mbeanServer.registerMBean(object, objectName);
                    return objectInstance.getObjectName();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    public synchronized void unregisterMBean(ObjectName objectName) throws Exception {
        try {
            this.unregisterAction.init(this.mbeanServer, objectName);
            AccessController.doPrivileged(this.unregisterAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    public Set findLocalMBeans(final ObjectName objectName) throws MalformedObjectNameException {
        return (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return IlrMBeanManagerImpl.this.mbeanServer.queryNames(objectName, null);
            }
        });
    }

    public List getAttribute(ObjectName objectName, String string) {
        return this.invoke(3, null, objectName, string, null, null);
    }

    public List getAttribute(String string, ObjectName objectName, String string2) {
        return this.invoke(3, string, objectName, string2, null, null);
    }

    public List setAttribute(ObjectName objectName, String string, Object object) {
        return this.invoke(2, null, objectName, string, new Object[]{object}, null);
    }

    public List setAttribute(String string, ObjectName objectName, String string2, Object object) {
        return this.invoke(2, string, objectName, string2, new Object[]{object}, null);
    }

    public List invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) {
        return this.invoke(1, null, objectName, string, objectArray, stringArray);
    }

    public List invoke(String string, ObjectName objectName, String string2, Object[] objectArray, String[] stringArray) {
        return this.invoke(1, string, objectName, string2, objectArray, stringArray);
    }

    public ObjectName getQuery(String string) throws MalformedObjectNameException {
        return this.getQuery(string, null, null);
    }

    public ObjectName getQuery(String string, Properties properties) throws MalformedObjectNameException {
        return this.getQuery(string, null, null);
    }

    public ObjectName getQuery(String string, String string2, Properties properties) throws MalformedObjectNameException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.domain);
        stringBuffer.append(':');
        if (string != null) {
            stringBuffer.append(this.typeElement);
            stringBuffer.append('=');
            stringBuffer.append(string);
            stringBuffer.append(',');
        }
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(',');
        }
        if (properties != null) {
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                stringBuffer.append(entry.getKey());
                stringBuffer.append('=');
                stringBuffer.append(entry.getValue());
                stringBuffer.append(',');
            }
        }
        stringBuffer.append("*");
        return new ObjectName(stringBuffer.toString());
    }

    protected List invoke(final int n, String string, final ObjectName objectName, final String string2, final Object[] objectArray, final String[] stringArray) {
        return (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<InvocationResult> arrayList = new ArrayList<InvocationResult>();
                Set<ObjectName> set = IlrMBeanManagerImpl.this.mbeanServer.queryNames(objectName, null);
                Iterator<ObjectName> iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName2 = iterator.next();
                    arrayList.add(IlrMBeanManagerImpl.this.invokeDispatcher(IlrMBeanManagerImpl.this.mbeanServer, "localhost", n, objectName2, string2, objectArray, stringArray));
                }
                return arrayList;
            }
        });
    }

    protected InvocationResult invokeDispatcher(MBeanServer mBeanServer, String string, int n, ObjectName objectName, String string2, Object[] objectArray, String[] stringArray) {
        Object object = null;
        try {
            switch (n) {
                case 1: {
                    object = mBeanServer.invoke(objectName, string2, objectArray, stringArray);
                    break;
                }
                case 2: {
                    mBeanServer.setAttribute(objectName, new Attribute(string2, objectArray[0]));
                    break;
                }
                case 3: {
                    object = mBeanServer.getAttribute(objectName, string2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Throwable throwable) {
            return new InvocationResult(throwable, string, objectName);
        }
        return new InvocationResult(object, string, objectName);
    }

    private static class UnregisterPrivilegedExceptionAction
    implements PrivilegedExceptionAction {
        private MBeanServer mbeanServer;
        private ObjectName objectName;

        private UnregisterPrivilegedExceptionAction() {
        }

        public void init(MBeanServer mBeanServer, ObjectName objectName) {
            this.mbeanServer = mBeanServer;
            this.objectName = objectName;
        }

        public Object run() throws InstanceNotFoundException, MBeanRegistrationException {
            this.mbeanServer.unregisterMBean(this.objectName);
            return null;
        }
    }
}

