/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.mbean.util;

import com.evermind.security.User;
import com.evermind.server.ThreadState;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl_oc4j1013s;
import ilog.rules.bres.mbean.util.InvocationResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.ias.opmn.optic.IasCluster;
import oracle.ias.opmn.optic.OpmnConn;
import oracle.ias.opmn.optic.OpmnEntity;
import oracle.ias.opmn.optic.OpmnHostPort;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiDomain;
import oracle.oc4j.admin.management.mejb.MEjbFactory;

class IlrMBeanManagerImpl_oc4j1013m
extends IlrMBeanManagerImpl_oc4j1013s {
    protected static final String OC4J_COMPONENT = "OC4J";
    protected static final String RMI_PROTOCOL = "rmi";
    protected static final String oracleHome = System.getProperty("oracle.ons.oracleconfighome");

    public IlrMBeanManagerImpl_oc4j1013m(Properties properties) {
        super(properties);
    }

    public String getImplementationName() {
        return "OC4J 10.1.3 managed";
    }

    public static boolean isAvailable() {
        try {
            if (new OpmnQuery(null, 0, OpmnHostPort.LOCAL, oracleHome).getIasCluster() != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected List invoke(final int n, final String string, final ObjectName objectName, final String string2, final Object[] objectArray, final String[] stringArray) {
        return (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<InvocationResult> arrayList = new ArrayList<InvocationResult>();
                List list = IlrMBeanManagerImpl_oc4j1013m.this.getServerDomains();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    OC4JServer oC4JServer = (OC4JServer)iterator.next();
                    if (string != null && !string.equals(oC4JServer.serverInfo)) continue;
                    Management management = null;
                    Set set = null;
                    try {
                        management = MEjbFactory.getManagement((Domain)oC4JServer.domain);
                        set = management.queryNames(objectName, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                    Iterator iterator2 = set.iterator();
                    while (iterator2.hasNext()) {
                        ObjectName objectName2 = (ObjectName)iterator2.next();
                        arrayList.add(IlrMBeanManagerImpl_oc4j1013m.this.invokeDispatcher(management, oC4JServer.serverInfo, n, objectName2, string2, objectArray, stringArray));
                    }
                }
                return arrayList;
            }
        });
    }

    protected InvocationResult invokeDispatcher(Management management, String string, int n, ObjectName objectName, String string2, Object[] objectArray, String[] stringArray) {
        Object object = null;
        try {
            switch (n) {
                case 1: {
                    object = management.invoke(objectName, string2, objectArray, stringArray);
                    break;
                }
                case 2: {
                    management.setAttribute(objectName, new Attribute(string2, objectArray[0]));
                    break;
                }
                case 3: {
                    object = management.getAttribute(objectName, string2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Throwable throwable) {
            return new InvocationResult(throwable, string, objectName);
        }
        return new InvocationResult(object, string, objectName);
    }

    protected List getServerDomains() {
        ArrayList<OC4JServer> arrayList = new ArrayList<OC4JServer>();
        try {
            OpmnQuery opmnQuery = new OpmnQuery(null, 0, OpmnHostPort.LOCAL, oracleHome);
            IasCluster iasCluster = opmnQuery.getIasCluster();
            User user = ThreadState.getCurrentState().getUser();
            ArrayList arrayList2 = new ArrayList();
            this.getJVMs((OpmnEntity)iasCluster, arrayList2);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                OpmnProcess opmnProcess = (OpmnProcess)iterator.next();
                OpmnConn opmnConn = this.getRMIConn(opmnProcess);
                if (opmnConn == null) continue;
                arrayList.add(new OC4JServer(opmnProcess, opmnConn, user));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private void getJVMs(OpmnEntity opmnEntity, List list) {
        List list2 = opmnEntity.getChildren();
        if (list2 == null) {
            return;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            OpmnEntity opmnEntity2 = (OpmnEntity)iterator.next();
            if (opmnEntity2 instanceof OpmnProcess) {
                if (!OC4J_COMPONENT.equals(opmnEntity2.getType())) continue;
                list.add(opmnEntity2);
                continue;
            }
            this.getJVMs(opmnEntity2, list);
        }
    }

    private OpmnConn getRMIConn(OpmnProcess opmnProcess) {
        Iterator iterator = opmnProcess.getConnList().iterator();
        while (iterator.hasNext()) {
            OpmnConn opmnConn = (OpmnConn)iterator.next();
            if (!opmnConn.getProtocol().equals(RMI_PROTOCOL)) continue;
            return opmnConn;
        }
        return null;
    }

    static class OC4JServer {
        Oc4jRmiDomain domain;
        String serverInfo;

        public OC4JServer(OpmnProcess opmnProcess, OpmnConn opmnConn, User user) {
            this.domain = new Oc4jRmiDomain(opmnConn.getHost(), Integer.parseInt(opmnConn.getPort()), user.getName(), user.getPassword());
            StringBuffer stringBuffer = new StringBuffer(opmnProcess.getIasInstanceName());
            stringBuffer.append(" - ");
            stringBuffer.append(opmnProcess.getProcessTypeName());
            this.serverInfo = stringBuffer.toString();
        }
    }
}

