/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.mbean.util;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import ilog.rules.bres.mbean.util.IlrMBeanManagerImpl;
import ilog.rules.bres.mbean.util.InvocationResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;

class IlrMBeanManagerImpl_websphere
extends IlrMBeanManagerImpl {
    protected MBeanFactory mbeanFactory = null;
    protected AdminClient adminClient = null;
    protected AdminService adminService = null;
    protected UnregisterPrivilegedExceptionAction unregisterAction = new UnregisterPrivilegedExceptionAction();

    public IlrMBeanManagerImpl_websphere(Properties properties) {
        super("type", "WebSphere", properties);
    }

    public String getImplementationName() {
        return "WebSphere";
    }

    public void initMBeanManager() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IlrMBeanManagerImpl_websphere.this.adminService = AdminServiceFactory.getAdminService();
                IlrMBeanManagerImpl_websphere.this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
                IlrMBeanManagerImpl_websphere.this.mbeanServer = IlrMBeanManagerImpl_websphere.this.mbeanFactory.getMBeanServer();
                return null;
            }
        });
        if (this.adminService == null || this.mbeanFactory == null || this.mbeanServer == null) {
            throw new ConnectorNotAvailableException();
        }
    }

    public ObjectName registerMBean(final String string, final Properties properties, final Object object) throws Exception {
        try {
            return (ObjectName)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AdminException {
                    return IlrMBeanManagerImpl_websphere.this.mbeanFactory.activateMBean(string, (RuntimeCollaborator)object, IlrMBeanManagerImpl_websphere.this.mbeanFactory.getConfigId(object), string + ".xml", properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    public synchronized void unregisterMBean(ObjectName objectName) throws Exception {
        try {
            this.unregisterAction.init(this.mbeanFactory, objectName);
            AccessController.doPrivileged(this.unregisterAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    protected List invoke(final int n, final String string, final ObjectName objectName, final String string2, final Object[] objectArray, final String[] stringArray) {
        return (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    IlrMBeanManagerImpl_websphere.this.adminClient = IlrMBeanManagerImpl_websphere.this.getAdminClient();
                }
                catch (Exception exception) {
                    IlrMBeanManagerImpl_websphere.this.adminClient = null;
                }
                ArrayList<InvocationResult> arrayList = new ArrayList<InvocationResult>();
                Set set = null;
                if (IlrMBeanManagerImpl_websphere.this.adminClient != null) {
                    try {
                        set = IlrMBeanManagerImpl_websphere.this.adminClient.queryNames(objectName, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (IlrMBeanManagerImpl_websphere.this.adminService != null) {
                    set = IlrMBeanManagerImpl_websphere.this.adminService.queryNames(objectName, null);
                }
                if (set != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        ObjectName objectName2 = (ObjectName)iterator.next();
                        String string3 = IlrMBeanManagerImpl_websphere.this.getServerInfo(objectName2);
                        if (string != null && !string.equals(string3)) continue;
                        arrayList.add(IlrMBeanManagerImpl_websphere.this.invokeDispatcher(IlrMBeanManagerImpl_websphere.this.adminClient, IlrMBeanManagerImpl_websphere.this.adminService, string3, n, objectName2, string2, objectArray, stringArray));
                    }
                }
                return arrayList;
            }
        });
    }

    protected InvocationResult invokeDispatcher(AdminClient adminClient, AdminService adminService, String string, int n, ObjectName objectName, String string2, Object[] objectArray, String[] stringArray) {
        Object object = null;
        try {
            switch (n) {
                case 1: {
                    if (adminClient != null) {
                        object = adminClient.invoke(objectName, string2, objectArray, stringArray);
                        break;
                    }
                    object = adminService.invoke(objectName, string2, objectArray, stringArray);
                    break;
                }
                case 2: {
                    if (adminClient != null) {
                        adminClient.setAttribute(objectName, new Attribute(string2, objectArray[0]));
                        break;
                    }
                    adminService.setAttribute(objectName, new Attribute(string2, objectArray[0]));
                    break;
                }
                case 3: {
                    if (adminClient != null) {
                        object = adminClient.getAttribute(objectName, string2);
                        break;
                    }
                    object = adminService.getAttribute(objectName, string2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Throwable throwable) {
            return new InvocationResult(throwable, string, objectName);
        }
        return new InvocationResult(object, string, objectName);
    }

    protected String getServerInfo(ObjectName objectName) {
        StringBuffer stringBuffer = new StringBuffer(ObjectNameHelper.getCellName((ObjectName)objectName));
        stringBuffer.append(" - ");
        stringBuffer.append(ObjectNameHelper.getNodeName((ObjectName)objectName));
        stringBuffer.append(" - ");
        stringBuffer.append(ObjectNameHelper.getProcessName((ObjectName)objectName));
        return stringBuffer.toString();
    }

    protected synchronized AdminClient getAdminClient() throws AdminException, ConnectorException {
        if (this.adminService == null || this.adminClient == null || this.adminClient.isAlive() == null) {
            return this.adminService.getDeploymentManagerAdminClient();
        }
        return null;
    }

    private static class UnregisterPrivilegedExceptionAction
    implements PrivilegedExceptionAction {
        private MBeanFactory mbeanFactory;
        private ObjectName objectName;

        private UnregisterPrivilegedExceptionAction() {
        }

        public void init(MBeanFactory mBeanFactory, ObjectName objectName) {
            this.mbeanFactory = mBeanFactory;
            this.objectName = objectName;
        }

        public Object run() throws AdminException {
            this.mbeanFactory.deactivateMBean(this.objectName);
            return null;
        }
    }
}

