/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.mbean.util;

import ilog.rules.bres.mbean.util.IlrMBeanManager;
import ilog.rules.bres.mbean.util.InvocationResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;

public class IlrSingleMBeanInvocationHandler
implements InvocationHandler {
    private static final String GET_METHOD_PREFIX = "get";
    private static final String IS_METHOD_PREFIX = "is";
    private static final String SET_METHOD_PREFIX = "set";
    protected IlrMBeanManager mbeanManager;
    protected ObjectName objectName;
    protected Map paramMap = new HashMap();

    public IlrSingleMBeanInvocationHandler(IlrMBeanManager ilrMBeanManager, ObjectName objectName) {
        this.mbeanManager = ilrMBeanManager;
        this.objectName = objectName;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        List list;
        String[] stringArray;
        Class[] classArray = method.getParameterTypes();
        String string = method.getName();
        if (string.startsWith(GET_METHOD_PREFIX) && classArray.length == 0) {
            stringArray = string.substring(GET_METHOD_PREFIX.length());
            list = this.mbeanManager.getAttribute(this.objectName, (String)stringArray);
        } else if (string.startsWith(IS_METHOD_PREFIX) && classArray.length == 1) {
            stringArray = string.substring(IS_METHOD_PREFIX.length());
            list = this.mbeanManager.getAttribute(this.objectName, (String)stringArray);
        } else if (string.startsWith(SET_METHOD_PREFIX) && classArray.length == 1) {
            stringArray = string.substring(SET_METHOD_PREFIX.length());
            list = this.mbeanManager.setAttribute(this.objectName, (String)stringArray, objectArray[0]);
        } else {
            stringArray = this.getMethodSignature(method, classArray);
            list = this.mbeanManager.invoke(this.objectName, string, objectArray, stringArray);
        }
        for (int i = 0; i < list.size(); ++i) {
            InvocationResult invocationResult = (InvocationResult)list.get(i);
            if (invocationResult.getError() == null) continue;
            Throwable throwable = invocationResult.getError();
            if (throwable instanceof MBeanException) {
                throw ((MBeanException)throwable).getTargetException();
            }
            if (throwable instanceof RuntimeMBeanException) {
                throw ((RuntimeMBeanException)throwable).getTargetException();
            }
            throw throwable;
        }
        if (list.size() != 1) {
            throw new IllegalStateException();
        }
        InvocationResult invocationResult = (InvocationResult)list.get(0);
        return invocationResult.getResult();
    }

    public String[] getMethodSignature(Method method, Class[] classArray) {
        String[] stringArray = (String[])this.paramMap.get(method);
        if (stringArray != null) {
            return stringArray;
        }
        stringArray = new String[classArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        this.paramMap.put(method, stringArray);
        return stringArray;
    }
}

