/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.archive;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.archive.IlrArchiveException;
import ilog.rules.bres.model.archive.IlrSimpleRulesetArchive;
import ilog.rules.bres.model.xml.IlrRuleAppArchiveDescriptor;
import ilog.rules.bres.util.IlrRulesetArchiveExtractor;
import ilog.rules.bres.util.zip.IlrZIPUtil;
import ilog.rules.tools.IlrVersionFullInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

class IlrArchive {
    private static final String META_INF = "META-INF";
    private static final String RULESETARCHIVE_FILENAME = "ruleset.jar";
    private static final String DESCRIPTOR_PATH = "META-INF/archive.xml";
    private static IlrRuleAppArchiveDescriptor descriptorManager = new IlrRuleAppArchiveDescriptor();

    IlrArchive() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void write(OutputStream outputStream, Set set) throws IlrArchiveException, IOException {
        JarOutputStream jarOutputStream = null;
        try {
            try {
                jarOutputStream = new JarOutputStream(outputStream, IlrArchive.getManifest());
                jarOutputStream.setLevel(9);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    IlrRuleAppInformation ilrRuleAppInformation = (IlrRuleAppInformation)iterator.next();
                    Iterator iterator2 = ilrRuleAppInformation.getRulesets().iterator();
                    while (iterator2.hasNext()) {
                        IlrRulesetArchiveInformation ilrRulesetArchiveInformation = (IlrRulesetArchiveInformation)iterator2.next();
                        IlrArchive.addRulesetArchiveEntry(jarOutputStream, ilrRulesetArchiveInformation);
                    }
                }
                IlrArchive.addDescriptorEntry(jarOutputStream, DESCRIPTOR_PATH, set);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IlrArchiveException("ilog.rules.bres.model.archive", "10001", exception);
            }
            Object var9_10 = null;
            if (jarOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (jarOutputStream == null) throw throwable;
            try {
                jarOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        jarOutputStream.close();
        return;
    }

    Set read(IlrRepositoryFactory ilrRepositoryFactory, JarInputStream jarInputStream) throws IlrArchiveException, IOException {
        Map map = null;
        try {
            map = IlrZIPUtil.toMap(jarInputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10007", illegalArgumentException);
        }
        byte[] byArray = (byte[])map.remove(DESCRIPTOR_PATH);
        if (byArray == null) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10007");
        }
        try {
            Set set = descriptorManager.load(ilrRepositoryFactory, new ByteArrayInputStream(byArray));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IlrMutableRuleAppInformation ilrMutableRuleAppInformation = (IlrMutableRuleAppInformation)iterator.next();
                Iterator iterator2 = ilrMutableRuleAppInformation.getRulesets().iterator();
                while (iterator2.hasNext()) {
                    IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = (IlrMutableRulesetArchiveInformation)iterator2.next();
                    byte[] byArray2 = (byte[])map.remove(IlrArchive.getRulesetArchivePath(ilrMutableRulesetArchiveInformation));
                    if (byArray2 == null) {
                        throw new IlrArchiveException("ilog.rules.bres.model.archive", "10004", new Object[]{ilrMutableRulesetArchiveInformation.toString()});
                    }
                    IlrRulesetArchive ilrRulesetArchive = IlrRulesetArchiveExtractor.extract(new ByteArrayInputStream(byArray2));
                    ilrMutableRulesetArchiveInformation.setRulesetArchive(ilrRulesetArchive);
                }
            }
            return set;
        }
        catch (Exception exception) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10001", exception);
        }
    }

    private static String getRulesetArchivePath(IlrRulesetArchiveInformation ilrRulesetArchiveInformation) {
        StringBuffer stringBuffer = new StringBuffer(ilrRulesetArchiveInformation.getCanonicalRulesetPath().substring(1));
        stringBuffer.append('/').append(RULESETARCHIVE_FILENAME);
        return stringBuffer.toString();
    }

    private static void addRulesetArchiveEntry(JarOutputStream jarOutputStream, IlrRulesetArchiveInformation ilrRulesetArchiveInformation) throws IOException, IlrArchiveException {
        IlrRulesetArchive ilrRulesetArchive = ilrRulesetArchiveInformation.getRulesetArchive();
        if (ilrRulesetArchive == null) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10004", new Object[]{ilrRulesetArchiveInformation.toString()});
        }
        JarEntry jarEntry = new JarEntry(IlrArchive.getRulesetArchivePath(ilrRulesetArchiveInformation));
        jarOutputStream.putNextEntry(jarEntry);
        if (ilrRulesetArchive instanceof IlrSimpleRulesetArchive) {
            ((IlrSimpleRulesetArchive)ilrRulesetArchive).writeJar(jarOutputStream);
        } else {
            JarOutputStream jarOutputStream2 = new JarOutputStream(jarOutputStream);
            jarOutputStream2.setLevel(9);
            ilrRulesetArchive.write(jarOutputStream2);
            jarOutputStream2.finish();
        }
        jarOutputStream.closeEntry();
    }

    private static void addDescriptorEntry(JarOutputStream jarOutputStream, String string, Set set) throws IOException {
        JarEntry jarEntry = new JarEntry(string);
        jarOutputStream.putNextEntry(jarEntry);
        descriptorManager.save(set, jarOutputStream);
        jarOutputStream.closeEntry();
    }

    private static Manifest getManifest() {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(Attributes.Name.SPECIFICATION_TITLE, "RuleApp Archive");
        attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, "ILOG JRules");
        attributes.put(Attributes.Name.IMPLEMENTATION_VENDOR, "ILOG");
        attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, IlrVersionFullInfo.getVersion());
        return manifest;
    }
}

