/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.archive;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrRepositoryException;
import ilog.rules.bres.model.IlrRepositoryFactory;
import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.archive.IlrArchiveException;
import ilog.rules.bres.model.archive.IlrXom2RulesetArchive;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.util.xml.IlrDOMUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IlrArchive500Loader {
    private IlrRepositoryFactory repositoryFactory = new IlrRepositoryFactoryImpl();

    public boolean isReadSupported(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("META-INF/") || !string.endsWith(".bres-xml")) continue;
            return true;
        }
        return false;
    }

    public Set read(Map map, IlrXom2RulesetArchive ilrXom2RulesetArchive) throws IlrArchiveException {
        HashSet<IlrMutableRuleAppInformation> hashSet = new HashSet<IlrMutableRuleAppInformation>();
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (!string.startsWith("META-INF") || !string.endsWith(".bres-xml")) continue;
                byte[] byArray = (byte[])entry.getValue();
                hashSet.add(this.addRuleApp(byArray, map, ilrXom2RulesetArchive));
            }
        }
        catch (Exception exception) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10001", exception);
        }
        return hashSet;
    }

    private IlrMutableRuleAppInformation addRuleApp(byte[] byArray, Map map, IlrXom2RulesetArchive ilrXom2RulesetArchive) throws ParserConfigurationException, SAXException, IlrRepositoryException, IOException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Element element = document.getDocumentElement();
        Element element2 = IlrDOMUtil.getFirstElementByTagName(element, "name");
        String string = IlrDOMUtil.textNodesToString(element2.getChildNodes());
        Element element3 = IlrDOMUtil.getFirstElementByTagName(element, "version");
        Element element4 = IlrDOMUtil.getFirstElementByTagName(element3, "minor-version");
        String string2 = IlrDOMUtil.textNodesToString(element4.getChildNodes());
        Element element5 = IlrDOMUtil.getFirstElementByTagName(element3, "major-version");
        String string3 = IlrDOMUtil.textNodesToString(element5.getChildNodes());
        IlrVersion ilrVersion = this.repositoryFactory.getVersionParser().parse(string3 + "." + string2);
        IlrMutableRuleAppInformation ilrMutableRuleAppInformation = this.repositoryFactory.createRuleApp(string, ilrVersion);
        NodeList nodeList = IlrDOMUtil.getChildElementsByTagName(element, "ruleset");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element6 = (Element)nodeList.item(i);
            this.addRuleset(element6, ilrMutableRuleAppInformation, map, ilrXom2RulesetArchive);
        }
        return ilrMutableRuleAppInformation;
    }

    private void addRuleset(Element element, IlrMutableRuleAppInformation ilrMutableRuleAppInformation, Map map, IlrXom2RulesetArchive ilrXom2RulesetArchive) throws IlrRepositoryException {
        String string;
        Element element2;
        Object object;
        Object object2;
        Element element3 = IlrDOMUtil.getFirstElementByTagName(element, "name");
        String string2 = IlrDOMUtil.textNodesToString(element3.getChildNodes());
        Element element4 = IlrDOMUtil.getFirstElementByTagName(element, "version");
        Element element5 = IlrDOMUtil.getFirstElementByTagName(element4, "major-version");
        String string3 = IlrDOMUtil.textNodesToString(element5.getChildNodes());
        Element element6 = IlrDOMUtil.getFirstElementByTagName(element4, "minor-version");
        String string4 = IlrDOMUtil.textNodesToString(element6.getChildNodes());
        IlrVersion ilrVersion = this.repositoryFactory.getVersionParser().parse(string3 + "." + string4);
        IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = this.repositoryFactory.createRuleset(string2, ilrVersion);
        ilrMutableRuleAppInformation.addRuleset(ilrMutableRulesetArchiveInformation);
        Element element7 = IlrDOMUtil.getFirstElementByTagName(element, "status");
        String string5 = IlrDOMUtil.textNodesToString(element7.getChildNodes());
        if (string5.equals("Enabled")) {
            ilrMutableRulesetArchiveInformation.setProperty("ruleset.status", "enabled");
        } else if (string5.equals("Disabled")) {
            ilrMutableRulesetArchiveInformation.setProperty("ruleset.status", "disabled");
        }
        NodeList nodeList = IlrDOMUtil.getChildElementsByTagName(element, "init-param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = (Element)nodeList.item(i);
            object = IlrDOMUtil.getFirstElementByTagName((Element)object2, "param-name");
            String string6 = IlrDOMUtil.textNodesToString(object.getChildNodes());
            element2 = IlrDOMUtil.getFirstElementByTagName((Element)object2, "param-value");
            string = IlrDOMUtil.textNodesToString(element2.getChildNodes());
            ilrMutableRulesetArchiveInformation.setProperty(string6, string);
        }
        byte[] byArray = null;
        object2 = null;
        object = IlrDOMUtil.getChildElementsByTagName(element, "resource");
        for (int i = 0; i < object.getLength(); ++i) {
            element2 = (Element)object.item(i);
            if (element2.getAttribute("type").equals("irl")) {
                string = element2.getAttribute("ref");
                byArray = (byte[])map.get(string);
                continue;
            }
            if (!element2.getAttribute("type").equals("xom")) continue;
            string = element2.getAttribute("ref");
            object2 = (byte[])map.get(string);
        }
        if (byArray == null) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10030", new Object[]{ilrMutableRulesetArchiveInformation});
        }
        IlrRulesetArchive ilrRulesetArchive = ilrXom2RulesetArchive.getRulesetArchive(ilrMutableRulesetArchiveInformation, byArray, (byte[])object2, null);
        if (ilrRulesetArchive != null) {
            ilrMutableRulesetArchiveInformation.setRulesetArchive(ilrRulesetArchive);
        }
    }
}

