/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.archive;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.bres.model.IlrMutableRuleAppInformation;
import ilog.rules.bres.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.archive.IlrArchiveException;
import ilog.rules.bres.model.archive.IlrXom2RulesetArchive;
import ilog.rules.bres.model.impl.IlrRepositoryFactoryImpl;
import ilog.rules.bres.model.xml.IlrRuleAppArchiveDescriptor;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IlrArchive510Loader {
    private static final String ENCODING_CHARSET_NAME = "UTF-8";
    private static final String META_INF = "META-INF";
    private static final String DEFAULT_RULESET_FILENAME = "ruleset";
    private static final String DESCRIPTOR_PATH = "META-INF/archive.xml";
    private static final String IRL_FILE_EXTENSION = ".irl";
    private static final String XOM_FILE_EXTENSION = ".xom";
    private static IlrRuleAppArchiveDescriptor descriptorManager = new IlrRuleAppArchiveDescriptor();

    public boolean isReadSupported(Map map) {
        if (map.get(DESCRIPTOR_PATH) == null) {
            return false;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.endsWith(IRL_FILE_EXTENSION)) continue;
            return true;
        }
        return false;
    }

    public Set read(Map map, IlrXom2RulesetArchive ilrXom2RulesetArchive) throws IlrArchiveException {
        byte[] byArray = (byte[])map.remove(DESCRIPTOR_PATH);
        if (byArray == null) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10007");
        }
        try {
            Set set = descriptorManager.load(new IlrRepositoryFactoryImpl(), new ByteArrayInputStream(byArray));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IlrMutableRuleAppInformation ilrMutableRuleAppInformation = (IlrMutableRuleAppInformation)iterator.next();
                Iterator iterator2 = ilrMutableRuleAppInformation.getRulesets().iterator();
                while (iterator2.hasNext()) {
                    IlrMutableRulesetArchiveInformation ilrMutableRulesetArchiveInformation = (IlrMutableRulesetArchiveInformation)iterator2.next();
                    String string = this.getResourcePath(ilrMutableRulesetArchiveInformation);
                    byte[] byArray2 = (byte[])map.remove(string + IRL_FILE_EXTENSION);
                    if (byArray2 == null) {
                        throw new IlrArchiveException("ilog.rules.bres.model.archive", "10030", new Object[]{ilrMutableRulesetArchiveInformation});
                    }
                    byte[] byArray3 = (byte[])map.remove(string + XOM_FILE_EXTENSION);
                    IlrRulesetArchive ilrRulesetArchive = ilrXom2RulesetArchive.getRulesetArchive(ilrMutableRulesetArchiveInformation, byArray2, byArray3, ENCODING_CHARSET_NAME);
                    if (ilrRulesetArchive == null) continue;
                    ilrMutableRulesetArchiveInformation.setRulesetArchive(ilrRulesetArchive);
                }
            }
            return set;
        }
        catch (Exception exception) {
            throw new IlrArchiveException("ilog.rules.bres.model.archive", "10001", exception);
        }
    }

    private String getResourcePath(IlrRulesetArchiveInformation ilrRulesetArchiveInformation) {
        StringBuffer stringBuffer = new StringBuffer(ilrRulesetArchiveInformation.getCanonicalRulesetPath().substring(1));
        stringBuffer.append('/').append(DEFAULT_RULESET_FILENAME);
        return stringBuffer.toString();
    }
}

