/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.impl;

import ilog.rules.bres.model.IlrRepository;
import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.impl.IlrRepositoryImpl;
import ilog.rules.bres.persistence.IlrTransactionalResourceProvider;
import java.util.Comparator;
import java.util.Date;

public class IlrEntity {
    public static final Comparator CASE_INSENSITIVE_ORDER = new IlrEntityComparator();
    protected IlrRepositoryImpl repository;
    protected String name;
    protected IlrVersion version;
    protected Date creationDate;
    protected String displayName;
    protected String description;
    protected String path;

    IlrEntity(IlrRepositoryImpl ilrRepositoryImpl, String string, IlrVersion ilrVersion, Date date, String string2, String string3) {
        this.repository = ilrRepositoryImpl;
        this.name = string;
        this.version = ilrVersion;
        this.creationDate = date;
        this.displayName = string2;
        this.description = string3;
        this.initPath();
    }

    public String getName() {
        return this.name;
    }

    public IlrVersion getVersion() {
        return this.version;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IlrRepository getRepository() {
        return this.repository;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IlrEntity)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.path;
    }

    protected void initPath() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/').append(this.name).append('/').append(this.version);
        this.path = stringBuffer.toString();
    }

    protected IlrTransactionalResourceProvider getResourceProvider() {
        if (this.repository != null) {
            return this.repository.getResourceProvider();
        }
        return null;
    }

    static class IlrEntityComparator
    implements Comparator {
        IlrEntityComparator() {
        }

        public int compare(Object object, Object object2) {
            IlrEntity ilrEntity = (IlrEntity)object;
            IlrEntity ilrEntity2 = (IlrEntity)object2;
            int n = ilrEntity.getName().compareToIgnoreCase(ilrEntity2.getName());
            if (n == 0) {
                return ilrEntity.getVersion().compareTo(ilrEntity2.getVersion());
            }
            return n;
        }
    }
}

