/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.impl;

import ilog.rules.bres.model.IlrVersion;
import ilog.rules.bres.model.impl.IlrEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IlrEntityContainer {
    private HashMap entities = new HashMap();

    public IlrEntityContainer(Set set) {
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IlrEntity ilrEntity = (IlrEntity)iterator.next();
            this.addEntity(ilrEntity);
        }
    }

    public IlrEntityContainer(IlrEntityContainer ilrEntityContainer) {
        Iterator iterator = ilrEntityContainer.entities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.entities.put(entry.getKey(), new TreeMap((Map)entry.getValue()));
        }
    }

    public synchronized int getNbEntities() {
        int n = 0;
        Iterator iterator = this.entities.values().iterator();
        while (iterator.hasNext()) {
            TreeMap treeMap = (TreeMap)iterator.next();
            n += treeMap.size();
        }
        return n;
    }

    public synchronized Set getEntities() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.entities.values().iterator();
        while (iterator.hasNext()) {
            TreeMap treeMap = (TreeMap)iterator.next();
            hashSet.addAll(treeMap.values());
        }
        return hashSet;
    }

    public synchronized Set getEntities(String string) {
        TreeMap treeMap = (TreeMap)this.entities.get(string);
        if (treeMap != null) {
            return new HashSet(treeMap.values());
        }
        return new HashSet();
    }

    public synchronized IlrEntity getGreatestEntity(String string) {
        TreeMap treeMap = (TreeMap)this.entities.get(string);
        if (treeMap != null) {
            return (IlrEntity)treeMap.get(treeMap.lastKey());
        }
        return null;
    }

    public synchronized IlrEntity getEntity(String string, IlrVersion ilrVersion) {
        TreeMap treeMap = (TreeMap)this.entities.get(string);
        if (treeMap != null && ilrVersion != null) {
            return (IlrEntity)treeMap.get(ilrVersion);
        }
        return null;
    }

    public synchronized IlrEntity addEntity(IlrEntity ilrEntity) {
        TreeMap<IlrVersion, IlrEntity> treeMap = (TreeMap<IlrVersion, IlrEntity>)this.entities.get(ilrEntity.getName());
        if (treeMap == null) {
            treeMap = new TreeMap<IlrVersion, IlrEntity>();
            this.entities.put(ilrEntity.getName(), treeMap);
        }
        treeMap.put(ilrEntity.getVersion(), ilrEntity);
        return ilrEntity;
    }

    public synchronized IlrEntity removeEntity(IlrEntity ilrEntity) {
        TreeMap treeMap = (TreeMap)this.entities.get(ilrEntity.getName());
        if (treeMap != null) {
            IlrEntity ilrEntity2 = (IlrEntity)treeMap.remove(ilrEntity.getVersion());
            if (treeMap.size() == 0) {
                this.entities.remove(ilrEntity.getName());
            }
            return ilrEntity2;
        }
        return null;
    }

    public synchronized boolean containsEntity(IlrEntity ilrEntity) {
        TreeMap treeMap = (TreeMap)this.entities.get(ilrEntity.getName());
        if (treeMap != null) {
            return treeMap.containsKey(ilrEntity.getVersion());
        }
        return false;
    }
}

