/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.bres.model.impl;

import ilog.rules.bres.model.IlrPath;
import ilog.rules.bres.model.IlrRuleAppInformation;
import ilog.rules.bres.model.IlrRulesetArchiveInformation;
import ilog.rules.bres.model.IlrVersion;

public class IlrPathImpl
implements IlrPath {
    private String ruleAppName;
    private IlrVersion ruleAppVersion;
    private String rulesetName;
    private IlrVersion rulesetVersion;
    private String path;

    IlrPathImpl(IlrRuleAppInformation ilrRuleAppInformation) {
        this.ruleAppName = ilrRuleAppInformation.getName();
        this.ruleAppVersion = ilrRuleAppInformation.getVersion();
        this.path = ilrRuleAppInformation.toString();
    }

    IlrPathImpl(IlrRulesetArchiveInformation ilrRulesetArchiveInformation) {
        this.ruleAppName = ilrRulesetArchiveInformation.getRuleApp().getName();
        this.ruleAppVersion = ilrRulesetArchiveInformation.getRuleApp().getVersion();
        this.rulesetName = ilrRulesetArchiveInformation.getName();
        this.rulesetVersion = ilrRulesetArchiveInformation.getVersion();
        this.path = ilrRulesetArchiveInformation.toString();
    }

    IlrPathImpl(String string, IlrVersion ilrVersion, String string2, IlrVersion ilrVersion2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.ruleAppName = string;
        this.ruleAppVersion = ilrVersion;
        this.rulesetName = string2;
        this.rulesetVersion = ilrVersion2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/').append(string);
        if (ilrVersion != null) {
            stringBuffer.append('/').append(ilrVersion);
        }
        if (string2 != null) {
            stringBuffer.append('/').append(string2);
        }
        if (ilrVersion2 != null) {
            stringBuffer.append('/').append(ilrVersion2);
        }
        this.path = stringBuffer.toString();
    }

    public String getRuleAppName() {
        return this.ruleAppName;
    }

    public IlrVersion getRuleAppVersion() {
        return this.ruleAppVersion;
    }

    public String getRulesetName() {
        return this.rulesetName;
    }

    public IlrVersion getRulesetVersion() {
        return this.rulesetVersion;
    }

    public boolean isRuleAppPath() {
        return this.ruleAppName != null && this.rulesetName == null && this.rulesetVersion == null;
    }

    public boolean isRulesetPath() {
        return this.ruleAppName != null && this.rulesetName != null;
    }

    public boolean isCanonical() {
        return this.ruleAppName != null && this.ruleAppVersion != null && this.rulesetName == null && this.rulesetVersion == null || this.ruleAppName != null && this.ruleAppVersion != null && this.rulesetName != null && this.rulesetVersion != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IlrPathImpl)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.path;
    }
}

